/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.registry.location.remote;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.openbase.bco.registry.location.lib.LocationRegistry;
import org.openbase.bco.registry.location.remote.LocationRegistryRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InvalidStateException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedLocationRegistryRemote {
    private static final Logger logger = LoggerFactory.getLogger(CachedLocationRegistryRemote.class);
    private static LocationRegistryRemote locationRegistryRemote;
    private static boolean shutdown;

    public static void reinitialize() throws InterruptedException, CouldNotPerformException {
        try {
            CachedLocationRegistryRemote.getRegistry();
            locationRegistryRemote.requestData().get(10L, TimeUnit.SECONDS);
        }
        catch (ExecutionException | TimeoutException | CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not reinitialize " + CachedLocationRegistryRemote.class.getSimpleName() + "!", ex);
        }
    }

    public static synchronized LocationRegistry getRegistry() throws InterruptedException, NotAvailableException {
        try {
            if (shutdown) {
                throw new InvalidStateException("Remote service is shutting down!");
            }
            if (locationRegistryRemote == null) {
                try {
                    locationRegistryRemote = new LocationRegistryRemote();
                    locationRegistryRemote.init();
                    locationRegistryRemote.activate();
                }
                catch (CouldNotPerformException ex) {
                    if (locationRegistryRemote != null) {
                        locationRegistryRemote.shutdown();
                        locationRegistryRemote = null;
                    }
                    throw (CouldNotPerformException)ExceptionPrinter.printHistoryAndReturnThrowable((Throwable)new CouldNotPerformException("Could not start cached location registry remote!", (Throwable)ex), (Logger)logger);
                }
            }
            return locationRegistryRemote;
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("cached location registry", (Throwable)ex);
        }
    }

    public static void waitForData() throws InterruptedException, CouldNotPerformException {
        if (locationRegistryRemote == null) {
            CachedLocationRegistryRemote.getRegistry();
        }
        locationRegistryRemote.waitForData();
    }

    public static void waitForData(long timeout, TimeUnit timeUnit) throws CouldNotPerformException, InterruptedException {
        if (locationRegistryRemote == null) {
            CachedLocationRegistryRemote.getRegistry();
        }
        locationRegistryRemote.waitForData(timeout, timeUnit);
    }

    public static void shutdown() {
        if (locationRegistryRemote != null) {
            locationRegistryRemote.shutdown();
            locationRegistryRemote = null;
        }
    }

    static {
        shutdown = false;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                shutdown = true;
                CachedLocationRegistryRemote.shutdown();
            }
        });
    }
}

