/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.registry.location.remote;

import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.openbase.bco.registry.lib.com.AbstractRegistryRemote;
import org.openbase.bco.registry.lib.com.SynchronizedRemoteRegistry;
import org.openbase.bco.registry.location.lib.LocationRegistry;
import org.openbase.bco.registry.location.lib.jp.JPLocationRegistryScope;
import org.openbase.bco.registry.unit.lib.UnitRegistry;
import org.openbase.bco.registry.unit.remote.CachedUnitRegistryRemote;
import org.openbase.jps.core.JPService;
import org.openbase.jps.exception.JPServiceException;
import org.openbase.jps.preset.JPReadOnly;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.extension.rsb.com.RPCHelper;
import org.openbase.jul.extension.rsb.com.RSBRemoteService;
import org.openbase.jul.pattern.Remote;
import org.openbase.jul.storage.registry.RegistryRemote;
import org.openbase.jul.storage.registry.RemoteRegistry;
import org.slf4j.Logger;
import rsb.converter.Converter;
import rsb.converter.DefaultConverterRepository;
import rsb.converter.ProtocolBufferConverter;
import rst.domotic.registry.LocationRegistryDataType;
import rst.domotic.service.ServiceConfigType;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.UnitTemplateType;
import rst.domotic.unit.connection.ConnectionConfigType;
import rst.domotic.unit.location.LocationConfigType;

public class LocationRegistryRemote
extends AbstractRegistryRemote<LocationRegistryDataType.LocationRegistryData>
implements LocationRegistry,
RegistryRemote<LocationRegistryDataType.LocationRegistryData> {
    private final SynchronizedRemoteRegistry<String, UnitConfigType.UnitConfig, UnitConfigType.UnitConfig.Builder> locationUnitConfigRemoteRegistry;
    private final SynchronizedRemoteRegistry<String, UnitConfigType.UnitConfig, UnitConfigType.UnitConfig.Builder> connectionUnitConfigRemoteRegistry;
    private UnitRegistry unitRegistry;

    public LocationRegistryRemote() throws InstantiationException {
        super(JPLocationRegistryScope.class, LocationRegistryDataType.LocationRegistryData.class);
        try {
            this.locationUnitConfigRemoteRegistry = new SynchronizedRemoteRegistry((RSBRemoteService)this, new int[]{200});
            this.connectionUnitConfigRemoteRegistry = new SynchronizedRemoteRegistry((RSBRemoteService)this, new int[]{250});
        }
        catch (CouldNotPerformException ex) {
            throw new InstantiationException((Object)this, (Throwable)ex);
        }
    }

    protected void postInit() throws InitializationException, InterruptedException {
        super.postInit();
        try {
            this.unitRegistry = CachedUnitRegistryRemote.getRegistry();
        }
        catch (NotAvailableException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    public void activate() throws InterruptedException, CouldNotPerformException {
        CachedUnitRegistryRemote.waitForData();
        super.activate();
    }

    public void shutdown() {
        try {
            this.unitRegistry.shutdown();
        }
        finally {
            super.shutdown();
        }
    }

    protected void registerRemoteRegistries() throws CouldNotPerformException {
        this.registerRemoteRegistry((RemoteRegistry)this.locationUnitConfigRemoteRegistry);
        this.registerRemoteRegistry((RemoteRegistry)this.connectionUnitConfigRemoteRegistry);
    }

    public SynchronizedRemoteRegistry<String, UnitConfigType.UnitConfig, UnitConfigType.UnitConfig.Builder> getLocationConfigRemoteRegistry() {
        return this.locationUnitConfigRemoteRegistry;
    }

    public SynchronizedRemoteRegistry<String, UnitConfigType.UnitConfig, UnitConfigType.UnitConfig.Builder> getConnectionConfigRemoteRegistry() {
        return this.connectionUnitConfigRemoteRegistry;
    }

    public Future<UnitConfigType.UnitConfig> registerLocationConfig(UnitConfigType.UnitConfig locationConfig) throws CouldNotPerformException {
        try {
            return RPCHelper.callRemoteMethod((Object)locationConfig, (Remote)this, UnitConfigType.UnitConfig.class);
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not register location config!", (Throwable)ex);
        }
    }

    public UnitConfigType.UnitConfig getLocationConfigById(String locationId) throws CouldNotPerformException {
        this.validateData();
        return (UnitConfigType.UnitConfig)this.locationUnitConfigRemoteRegistry.getMessage((Object)locationId);
    }

    public List<UnitConfigType.UnitConfig> getLocationConfigsByLabel(String locationLabel) throws CouldNotPerformException {
        this.validateData();
        return this.locationUnitConfigRemoteRegistry.getMessages().stream().filter(m -> m.getLabel().equalsIgnoreCase(locationLabel)).collect(Collectors.toCollection(ArrayList::new));
    }

    public List<UnitConfigType.UnitConfig> getUnitConfigsByLabelAndLocation(String unitLabel, String locationId) throws CouldNotPerformException {
        return this.unitRegistry.getUnitConfigsByLabel(unitLabel).stream().filter(u -> u.getPlacementConfig().getLocationId().equals(locationId)).collect(Collectors.toCollection(ArrayList::new));
    }

    public Boolean containsLocationConfig(UnitConfigType.UnitConfig locationConfig) throws CouldNotPerformException {
        this.validateData();
        return this.locationUnitConfigRemoteRegistry.contains((GeneratedMessage)locationConfig);
    }

    public Boolean containsLocationConfigById(String locationId) throws CouldNotPerformException {
        this.validateData();
        return this.locationUnitConfigRemoteRegistry.contains((Object)locationId);
    }

    public Future<UnitConfigType.UnitConfig> updateLocationConfig(UnitConfigType.UnitConfig locationConfig) throws CouldNotPerformException {
        try {
            return RPCHelper.callRemoteMethod((Object)locationConfig, (Remote)this, UnitConfigType.UnitConfig.class);
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not update location[" + locationConfig + "]!", (Throwable)ex);
        }
    }

    public Future<UnitConfigType.UnitConfig> removeLocationConfig(UnitConfigType.UnitConfig locationConfig) throws CouldNotPerformException {
        try {
            return RPCHelper.callRemoteMethod((Object)locationConfig, (Remote)this, UnitConfigType.UnitConfig.class);
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not remove location[" + locationConfig + "]!", (Throwable)ex);
        }
    }

    public List<UnitConfigType.UnitConfig> getLocationConfigs() throws CouldNotPerformException, NotAvailableException {
        this.validateData();
        List messages = this.locationUnitConfigRemoteRegistry.getMessages();
        return messages;
    }

    public List<UnitConfigType.UnitConfig> getUnitConfigsByLocation(String locationId) throws CouldNotPerformException, NotAvailableException {
        ArrayList<UnitConfigType.UnitConfig> unitConfigList = new ArrayList<UnitConfigType.UnitConfig>();
        for (String unitConfigId : this.getLocationConfigById(locationId).getLocationConfig().getUnitIdList()) {
            unitConfigList.add(this.unitRegistry.getUnitConfigById(unitConfigId));
        }
        return unitConfigList;
    }

    public List<UnitConfigType.UnitConfig> getUnitConfigsByLocationLabel(String locationLabel) throws CouldNotPerformException {
        HashMap<String, UnitConfigType.UnitConfig> unitConfigMap = new HashMap<String, UnitConfigType.UnitConfig>();
        for (UnitConfigType.UnitConfig location : this.getLocationConfigsByLabel(locationLabel)) {
            for (UnitConfigType.UnitConfig unitConfig : this.getUnitConfigsByLocation(location.getId())) {
                unitConfigMap.put(unitConfig.getId(), unitConfig);
            }
        }
        return new ArrayList<UnitConfigType.UnitConfig>(unitConfigMap.values());
    }

    public List<UnitConfigType.UnitConfig> getUnitConfigsByLocation(UnitTemplateType.UnitTemplate.UnitType type, String locationConfigId) throws CouldNotPerformException, NotAvailableException {
        ArrayList<UnitConfigType.UnitConfig> unitConfigList = new ArrayList<UnitConfigType.UnitConfig>();
        for (String unitConfigId : this.getLocationConfigById(locationConfigId).getLocationConfig().getUnitIdList()) {
            try {
                UnitConfigType.UnitConfig unitConfig = this.unitRegistry.getUnitConfigById(unitConfigId);
                if (!unitConfig.getType().equals((Object)type) && !this.unitRegistry.getSubUnitTypesOfUnitType(type).contains(unitConfig.getType())) continue;
                unitConfigList.add(unitConfig);
            }
            catch (CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not resolve UnitConfigId[" + unitConfigId + "] by device registry!", (Throwable)ex), (Logger)this.logger);
            }
        }
        return unitConfigList;
    }

    public List<UnitConfigType.UnitConfig> getUnitConfigsByLocationLabel(UnitTemplateType.UnitTemplate.UnitType unitType, String locationLabel) throws CouldNotPerformException {
        HashMap<String, UnitConfigType.UnitConfig> unitConfigMap = new HashMap<String, UnitConfigType.UnitConfig>();
        for (UnitConfigType.UnitConfig location : this.getLocationConfigsByLabel(locationLabel)) {
            for (UnitConfigType.UnitConfig unitConfig : this.getUnitConfigsByLocation(unitType, location.getId())) {
                unitConfigMap.put(unitConfig.getId(), unitConfig);
            }
        }
        return new ArrayList<UnitConfigType.UnitConfig>(unitConfigMap.values());
    }

    public List<UnitConfigType.UnitConfig> getUnitConfigsByLocation(ServiceTemplateType.ServiceTemplate.ServiceType type, String locationConfigId) throws CouldNotPerformException, NotAvailableException {
        ArrayList<UnitConfigType.UnitConfig> unitConfigList = new ArrayList<UnitConfigType.UnitConfig>();
        for (String unitConfigId : this.getLocationConfigById(locationConfigId).getLocationConfig().getUnitIdList()) {
            try {
                UnitConfigType.UnitConfig unitConfig = this.unitRegistry.getUnitConfigById(unitConfigId);
                for (ServiceConfigType.ServiceConfig serviceConfig : unitConfig.getServiceConfigList()) {
                    if (!serviceConfig.getServiceTemplate().getType().equals((Object)type)) continue;
                    unitConfigList.add(unitConfig);
                }
            }
            catch (CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not resolve UnitConfigId[" + unitConfigId + "] by device registry!", (Throwable)ex), (Logger)this.logger);
            }
        }
        return unitConfigList;
    }

    public List<ServiceConfigType.ServiceConfig> getServiceConfigsByLocation(String locationId) throws CouldNotPerformException, NotAvailableException {
        ArrayList<ServiceConfigType.ServiceConfig> serviceConfigList = new ArrayList<ServiceConfigType.ServiceConfig>();
        for (UnitConfigType.UnitConfig unitConfig : this.getUnitConfigsByLocation(locationId)) {
            serviceConfigList.addAll(unitConfig.getServiceConfigList());
        }
        return serviceConfigList;
    }

    public UnitConfigType.UnitConfig getRootLocationConfig() throws CouldNotPerformException, NotAvailableException {
        this.validateData();
        for (UnitConfigType.UnitConfig locationConfig : this.locationUnitConfigRemoteRegistry.getMessages()) {
            if (!locationConfig.getLocationConfig().hasRoot() || !locationConfig.getLocationConfig().getRoot()) continue;
            return locationConfig;
        }
        throw new NotAvailableException("rootlocation");
    }

    public Boolean isLocationConfigRegistryReadOnly() throws CouldNotPerformException {
        this.validateData();
        try {
            if (((Boolean)((JPReadOnly)JPService.getProperty(JPReadOnly.class)).getValue()).booleanValue() || !this.isConnected()) {
                return true;
            }
        }
        catch (JPServiceException ex) {
            ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not access java property!", (Throwable)ex), (Logger)this.logger);
        }
        return ((LocationRegistryDataType.LocationRegistryData)this.getData()).getLocationUnitConfigRegistryReadOnly();
    }

    public Future<UnitConfigType.UnitConfig> registerConnectionConfig(UnitConfigType.UnitConfig connectionConfig) throws CouldNotPerformException {
        try {
            return RPCHelper.callRemoteMethod((Object)connectionConfig, (Remote)this, UnitConfigType.UnitConfig.class);
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not register connection config!", (Throwable)ex);
        }
    }

    public UnitConfigType.UnitConfig getConnectionConfigById(String connectionId) throws CouldNotPerformException {
        this.validateData();
        return (UnitConfigType.UnitConfig)this.connectionUnitConfigRemoteRegistry.getMessage((Object)connectionId);
    }

    public List<UnitConfigType.UnitConfig> getConnectionConfigsByLabel(String connectionLabel) throws CouldNotPerformException {
        this.validateData();
        return this.connectionUnitConfigRemoteRegistry.getMessages().stream().filter(m -> m.getLabel().equals(connectionLabel)).collect(Collectors.toCollection(ArrayList::new));
    }

    public Boolean containsConnectionConfig(UnitConfigType.UnitConfig connectionConfig) throws CouldNotPerformException {
        this.validateData();
        return this.connectionUnitConfigRemoteRegistry.contains((GeneratedMessage)connectionConfig);
    }

    public Boolean containsConnectionConfigById(String connectionId) throws CouldNotPerformException {
        this.validateData();
        return this.connectionUnitConfigRemoteRegistry.contains((Object)connectionId);
    }

    public Future<UnitConfigType.UnitConfig> updateConnectionConfig(UnitConfigType.UnitConfig connectionConfig) throws CouldNotPerformException {
        try {
            return RPCHelper.callRemoteMethod((Object)connectionConfig, (Remote)this, UnitConfigType.UnitConfig.class);
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not update connection[" + connectionConfig + "]!", (Throwable)ex);
        }
    }

    public Future<UnitConfigType.UnitConfig> removeConnectionConfig(UnitConfigType.UnitConfig connectionConfig) throws CouldNotPerformException {
        try {
            return RPCHelper.callRemoteMethod((Object)connectionConfig, (Remote)this, UnitConfigType.UnitConfig.class);
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not remove connection[" + connectionConfig + "]!", (Throwable)ex);
        }
    }

    public List<UnitConfigType.UnitConfig> getConnectionConfigs() throws CouldNotPerformException {
        this.validateData();
        List messages = this.connectionUnitConfigRemoteRegistry.getMessages();
        return messages;
    }

    public List<UnitConfigType.UnitConfig> getUnitConfigsByConnection(String connectionConfigId) throws CouldNotPerformException {
        ArrayList<UnitConfigType.UnitConfig> unitConfigList = new ArrayList<UnitConfigType.UnitConfig>();
        for (String unitConfigId : this.getConnectionConfigById(connectionConfigId).getConnectionConfig().getUnitIdList()) {
            unitConfigList.add(this.unitRegistry.getUnitConfigById(unitConfigId));
        }
        return unitConfigList;
    }

    public List<UnitConfigType.UnitConfig> getUnitConfigsByConnection(UnitTemplateType.UnitTemplate.UnitType type, String connectionConfigId) throws CouldNotPerformException, NotAvailableException {
        ArrayList<UnitConfigType.UnitConfig> unitConfigList = new ArrayList<UnitConfigType.UnitConfig>();
        for (String unitConfigId : this.getConnectionConfigById(connectionConfigId).getConnectionConfig().getUnitIdList()) {
            try {
                UnitConfigType.UnitConfig unitConfig = this.unitRegistry.getUnitConfigById(unitConfigId);
                if (!unitConfig.getType().equals((Object)type) && !this.unitRegistry.getSubUnitTypesOfUnitType(type).contains(unitConfig.getType())) continue;
                unitConfigList.add(unitConfig);
            }
            catch (CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not resolve UnitConfigId[" + unitConfigId + "] by device registry!", (Throwable)ex), (Logger)this.logger);
            }
        }
        return unitConfigList;
    }

    public List<UnitConfigType.UnitConfig> getUnitConfigsByConnection(ServiceTemplateType.ServiceTemplate.ServiceType type, String connectionConfigId) throws CouldNotPerformException, NotAvailableException {
        ArrayList<UnitConfigType.UnitConfig> unitConfigList = new ArrayList<UnitConfigType.UnitConfig>();
        for (String unitConfigId : this.getConnectionConfigById(connectionConfigId).getConnectionConfig().getUnitIdList()) {
            try {
                UnitConfigType.UnitConfig unitConfig = this.unitRegistry.getUnitConfigById(unitConfigId);
                for (ServiceConfigType.ServiceConfig serviceConfig : unitConfig.getServiceConfigList()) {
                    if (!serviceConfig.getServiceTemplate().getType().equals((Object)type)) continue;
                    unitConfigList.add(unitConfig);
                }
            }
            catch (CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not resolve UnitConfigId[" + unitConfigId + "] by device registry!", (Throwable)ex), (Logger)this.logger);
            }
        }
        return unitConfigList;
    }

    public List<ServiceConfigType.ServiceConfig> getServiceConfigsByConnection(String connectionConfigId) throws CouldNotPerformException {
        ArrayList<ServiceConfigType.ServiceConfig> serviceConfigList = new ArrayList<ServiceConfigType.ServiceConfig>();
        for (UnitConfigType.UnitConfig unitConfig : this.getUnitConfigsByConnection(connectionConfigId)) {
            serviceConfigList.addAll(unitConfig.getServiceConfigList());
        }
        return serviceConfigList;
    }

    public Boolean isConnectionConfigRegistryReadOnly() throws CouldNotPerformException {
        this.validateData();
        try {
            if (((Boolean)((JPReadOnly)JPService.getProperty(JPReadOnly.class)).getValue()).booleanValue() || !this.isConnected()) {
                return true;
            }
        }
        catch (JPServiceException ex) {
            ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not access java property!", (Throwable)ex), (Logger)this.logger);
        }
        return ((LocationRegistryDataType.LocationRegistryData)this.getData()).getConnectionUnitConfigRegistryReadOnly();
    }

    public List<UnitConfigType.UnitConfig> getNeighborLocations(String locationId) throws CouldNotPerformException {
        UnitConfigType.UnitConfig locationConfig = this.getLocationConfigById(locationId);
        if (locationConfig.getLocationConfig().getType() != LocationConfigType.LocationConfig.LocationType.TILE) {
            throw new CouldNotPerformException("Id[" + locationId + "] does not belong to a tile and therefore its neighbors aren't defined!");
        }
        HashMap<String, UnitConfigType.UnitConfig> neighborMap = new HashMap<String, UnitConfigType.UnitConfig>();
        for (UnitConfigType.UnitConfig connectionConfig : this.getConnectionConfigs()) {
            if (!connectionConfig.getConnectionConfig().getTileIdList().contains(locationId)) continue;
            for (String id : connectionConfig.getConnectionConfig().getTileIdList()) {
                if (id.equals(locationId)) continue;
                neighborMap.put(id, this.getLocationConfigById(id));
            }
        }
        return new ArrayList<UnitConfigType.UnitConfig>(neighborMap.values());
    }

    public Boolean isLocationConfigRegistryConsistent() throws CouldNotPerformException {
        try {
            this.validateData();
            return ((LocationRegistryDataType.LocationRegistryData)this.getData()).getLocationUnitConfigRegistryConsistent();
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not check consistency!", (Throwable)ex);
        }
    }

    public Boolean isConnectionConfigRegistryConsistent() throws CouldNotPerformException {
        try {
            this.validateData();
            return ((LocationRegistryDataType.LocationRegistryData)this.getData()).getConnectionUnitConfigRegistryConsistent();
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not check consistency!", (Throwable)ex);
        }
    }

    static {
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)LocationRegistryDataType.LocationRegistryData.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)LocationConfigType.LocationConfig.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)ConnectionConfigType.ConnectionConfig.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)UnitConfigType.UnitConfig.getDefaultInstance()));
    }
}

