/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.registry.location.remote;

import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.twod.PolygonsSet;
import org.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import org.apache.commons.math3.geometry.partitioning.Region;
import org.openbase.bco.registry.lib.com.AbstractVirtualRegistryRemote;
import org.openbase.bco.registry.lib.com.SynchronizedRemoteRegistry;
import org.openbase.bco.registry.location.lib.LocationRegistry;
import org.openbase.bco.registry.location.lib.jp.JPLocationRegistryScope;
import org.openbase.bco.registry.location.remote.CachedLocationRegistryRemote;
import org.openbase.bco.registry.unit.remote.CachedUnitRegistryRemote;
import org.openbase.bco.registry.unit.remote.UnitRegistryRemote;
import org.openbase.jps.core.JPService;
import org.openbase.jps.exception.JPServiceException;
import org.openbase.jps.preset.JPReadOnly;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.FatalImplementationErrorException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.extension.rsb.com.RPCHelper;
import org.openbase.jul.extension.rsb.com.RSBRemote;
import org.openbase.jul.extension.rsb.com.RSBRemoteService;
import org.openbase.jul.storage.registry.RegistryRemote;
import org.openbase.jul.storage.registry.RemoteRegistry;
import org.slf4j.Logger;
import rct.Transform;
import rsb.converter.Converter;
import rsb.converter.DefaultConverterRepository;
import rsb.converter.ProtocolBufferConverter;
import rst.domotic.registry.LocationRegistryDataType;
import rst.domotic.service.ServiceConfigType;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.UnitProbabilityCollectionType;
import rst.domotic.unit.UnitTemplateType;
import rst.domotic.unit.connection.ConnectionConfigType;
import rst.domotic.unit.location.LocationConfigType;
import rst.math.Vec3DDoubleType;
import rst.tracking.PointingRay3DFloatCollectionType;
import rst.tracking.PointingRay3DFloatType;

public class LocationRegistryRemote
extends AbstractVirtualRegistryRemote<LocationRegistryDataType.LocationRegistryData>
implements LocationRegistry,
RegistryRemote<LocationRegistryDataType.LocationRegistryData> {
    private final SynchronizedRemoteRegistry<String, UnitConfigType.UnitConfig, UnitConfigType.UnitConfig.Builder> locationUnitConfigRemoteRegistry;
    private final SynchronizedRemoteRegistry<String, UnitConfigType.UnitConfig, UnitConfigType.UnitConfig.Builder> connectionUnitConfigRemoteRegistry;
    private UnitRegistryRemote unitRegistry;

    public LocationRegistryRemote() throws InstantiationException {
        super(JPLocationRegistryScope.class, LocationRegistryDataType.LocationRegistryData.class);
        try {
            this.locationUnitConfigRemoteRegistry = new SynchronizedRemoteRegistry((RSBRemoteService)this, new int[]{200});
            this.connectionUnitConfigRemoteRegistry = new SynchronizedRemoteRegistry((RSBRemoteService)this, new int[]{250});
        }
        catch (CouldNotPerformException ex) {
            throw new InstantiationException((Object)this, (Throwable)ex);
        }
    }

    public void activate() throws InterruptedException, CouldNotPerformException {
        if (!((Object)((Object)CachedLocationRegistryRemote.getRegistry())).equals((Object)this)) {
            this.logger.warn("You are using a " + ((Object)((Object)this)).getClass().getSimpleName() + " which is not maintained by the global registry singelton! This is extremely inefficient! Please use \"Registries.get" + ((Object)((Object)this)).getClass().getSimpleName().replace("Remote", "") + "()\" instead creating your own instances!");
        }
        super.activate();
    }

    protected void registerRemoteRegistries() throws CouldNotPerformException {
        this.registerRemoteRegistry((RemoteRegistry)this.locationUnitConfigRemoteRegistry);
        this.registerRemoteRegistry((RemoteRegistry)this.connectionUnitConfigRemoteRegistry);
    }

    protected void registerRegistryRemotes() throws InitializationException, InterruptedException {
        try {
            this.unitRegistry = CachedUnitRegistryRemote.getRegistry();
            this.registerRegistryRemote((RegistryRemote)this.unitRegistry);
        }
        catch (NotAvailableException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    protected void bindRegistryRemoteToRemoteRegistries() {
        try {
            this.bindRegistryRemoteToRemoteRegistry((RemoteRegistry)this.locationUnitConfigRemoteRegistry, (RegistryRemote)this.unitRegistry, 1100);
            this.bindRegistryRemoteToRemoteRegistry((RemoteRegistry)this.connectionUnitConfigRemoteRegistry, (RegistryRemote)this.unitRegistry, 1200);
        }
        catch (CouldNotPerformException ex) {
            new FatalImplementationErrorException("Could not bind registries", (Object)this, (Throwable)ex);
        }
    }

    public SynchronizedRemoteRegistry<String, UnitConfigType.UnitConfig, UnitConfigType.UnitConfig.Builder> getLocationConfigRemoteRegistry() {
        return this.locationUnitConfigRemoteRegistry;
    }

    public SynchronizedRemoteRegistry<String, UnitConfigType.UnitConfig, UnitConfigType.UnitConfig.Builder> getConnectionConfigRemoteRegistry() {
        return this.connectionUnitConfigRemoteRegistry;
    }

    public Future<UnitConfigType.UnitConfig> registerLocationConfig(UnitConfigType.UnitConfig locationConfig) throws CouldNotPerformException {
        try {
            return RPCHelper.callRemoteMethod((Object)locationConfig, (RSBRemote)this, UnitConfigType.UnitConfig.class);
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not register location config!", (Throwable)ex);
        }
    }

    public UnitConfigType.UnitConfig getLocationConfigById(String locationId) throws CouldNotPerformException {
        this.validateData();
        return (UnitConfigType.UnitConfig)this.locationUnitConfigRemoteRegistry.getMessage((Object)locationId);
    }

    public List<UnitConfigType.UnitConfig> getLocationConfigsByLabel(String locationLabel) throws CouldNotPerformException {
        this.validateData();
        return this.locationUnitConfigRemoteRegistry.getMessages().stream().filter(m -> m.getLabel().equalsIgnoreCase(locationLabel)).collect(Collectors.toCollection(ArrayList::new));
    }

    public List<UnitConfigType.UnitConfig> getLocationConfigsByCoordinate(Vec3DDoubleType.Vec3DDouble coordinate, LocationConfigType.LocationConfig.LocationType locationType) throws CouldNotPerformException, InterruptedException, ExecutionException {
        this.validateData();
        ArrayList<UnitConfigType.UnitConfig> result = new ArrayList<UnitConfigType.UnitConfig>();
        for (UnitConfigType.UnitConfig unitConfig : this.locationUnitConfigRemoteRegistry.getMessages()) {
            if (!locationType.equals((Object)LocationConfigType.LocationConfig.LocationType.UNKNOWN) && !locationType.equals((Object)unitConfig.getLocationConfig().getType())) continue;
            List floorList = unitConfig.getPlacementConfig().getShape().getFloorList();
            List<Vector2D> vertices = floorList.stream().map(vec3DDouble -> new Vector2D(vec3DDouble.getX(), vec3DDouble.getY())).collect(Collectors.toList());
            PolygonsSet polygonsSet = new PolygonsSet(0.1, vertices.toArray(new Vector2D[0]));
            Transform3D unitTransform = ((Transform)this.getUnitTransformation(unitConfig).get()).getTransform();
            Point3d transformedCoordinate = new Point3d(coordinate.getX(), coordinate.getY(), coordinate.getZ());
            unitTransform.transform(transformedCoordinate);
            if (polygonsSet.checkPoint((Vector)new Vector2D(transformedCoordinate.x, transformedCoordinate.y)) != Region.Location.OUTSIDE) continue;
            result.add(unitConfig);
        }
        return result;
    }

    public List<UnitConfigType.UnitConfig> getUnitConfigsByLabelAndLocation(String unitLabel, String locationId) throws CouldNotPerformException {
        return this.unitRegistry.getUnitConfigsByLabel(unitLabel).stream().filter(u -> u.getPlacementConfig().getLocationId().equals(locationId)).collect(Collectors.toCollection(ArrayList::new));
    }

    public Boolean containsLocationConfig(UnitConfigType.UnitConfig locationConfig) throws CouldNotPerformException {
        this.validateData();
        return this.locationUnitConfigRemoteRegistry.contains((GeneratedMessage)locationConfig);
    }

    public Boolean containsLocationConfigById(String locationId) throws CouldNotPerformException {
        this.validateData();
        return this.locationUnitConfigRemoteRegistry.contains((Object)locationId);
    }

    public Future<UnitConfigType.UnitConfig> updateLocationConfig(UnitConfigType.UnitConfig locationConfig) throws CouldNotPerformException {
        try {
            return RPCHelper.callRemoteMethod((Object)locationConfig, (RSBRemote)this, UnitConfigType.UnitConfig.class);
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not update location[" + locationConfig + "]!", (Throwable)ex);
        }
    }

    public Future<UnitConfigType.UnitConfig> removeLocationConfig(UnitConfigType.UnitConfig locationConfig) throws CouldNotPerformException {
        try {
            return RPCHelper.callRemoteMethod((Object)locationConfig, (RSBRemote)this, UnitConfigType.UnitConfig.class);
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not remove location[" + locationConfig + "]!", (Throwable)ex);
        }
    }

    public List<UnitConfigType.UnitConfig> getLocationConfigs() throws CouldNotPerformException, NotAvailableException {
        this.validateData();
        return this.locationUnitConfigRemoteRegistry.getMessages();
    }

    public List<UnitConfigType.UnitConfig> getUnitConfigsByLocation(String locationId) throws CouldNotPerformException {
        return this.getUnitConfigsByLocation(locationId, true);
    }

    public List<UnitConfigType.UnitConfig> getUnitConfigsByLocation(String locationId, boolean recursive) throws CouldNotPerformException {
        ArrayList<UnitConfigType.UnitConfig> unitConfigList = new ArrayList<UnitConfigType.UnitConfig>();
        for (String unitConfigId : this.getLocationConfigById(locationId).getLocationConfig().getUnitIdList()) {
            UnitConfigType.UnitConfig unitConfig = this.unitRegistry.getUnitConfigById(unitConfigId);
            if (!recursive && !unitConfig.getPlacementConfig().getLocationId().equals(locationId)) continue;
            unitConfigList.add(unitConfig);
        }
        return unitConfigList;
    }

    public List<UnitConfigType.UnitConfig> getUnitConfigsByLocationLabel(String locationLabel) throws CouldNotPerformException {
        HashMap<String, UnitConfigType.UnitConfig> unitConfigMap = new HashMap<String, UnitConfigType.UnitConfig>();
        for (UnitConfigType.UnitConfig location : this.getLocationConfigsByLabel(locationLabel)) {
            for (UnitConfigType.UnitConfig unitConfig : this.getUnitConfigsByLocation(location.getId())) {
                unitConfigMap.put(unitConfig.getId(), unitConfig);
            }
        }
        return new ArrayList<UnitConfigType.UnitConfig>(unitConfigMap.values());
    }

    public List<UnitConfigType.UnitConfig> getUnitConfigsByLocation(UnitTemplateType.UnitTemplate.UnitType type, String locationConfigId) throws CouldNotPerformException, NotAvailableException {
        ArrayList<UnitConfigType.UnitConfig> unitConfigList = new ArrayList<UnitConfigType.UnitConfig>();
        for (String unitConfigId : this.getLocationConfigById(locationConfigId).getLocationConfig().getUnitIdList()) {
            try {
                UnitConfigType.UnitConfig unitConfig = this.unitRegistry.getUnitConfigById(unitConfigId);
                if (!unitConfig.getType().equals((Object)type) && !this.unitRegistry.getSubUnitTypesOfUnitType(type).contains(unitConfig.getType())) continue;
                unitConfigList.add(unitConfig);
            }
            catch (CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not resolve UnitConfigId[" + unitConfigId + "] by UnitRegitryRemote!", (Throwable)ex), (Logger)this.logger);
            }
        }
        return unitConfigList;
    }

    public List<UnitConfigType.UnitConfig> getUnitConfigsByLocationLabel(UnitTemplateType.UnitTemplate.UnitType unitType, String locationLabel) throws CouldNotPerformException {
        HashMap<String, UnitConfigType.UnitConfig> unitConfigMap = new HashMap<String, UnitConfigType.UnitConfig>();
        for (UnitConfigType.UnitConfig location : this.getLocationConfigsByLabel(locationLabel)) {
            for (UnitConfigType.UnitConfig unitConfig : this.getUnitConfigsByLocation(unitType, location.getId())) {
                unitConfigMap.put(unitConfig.getId(), unitConfig);
            }
        }
        return new ArrayList<UnitConfigType.UnitConfig>(unitConfigMap.values());
    }

    public List<UnitConfigType.UnitConfig> getUnitConfigsByLocation(ServiceTemplateType.ServiceTemplate.ServiceType type, String locationConfigId) throws CouldNotPerformException, NotAvailableException {
        ArrayList<UnitConfigType.UnitConfig> unitConfigList = new ArrayList<UnitConfigType.UnitConfig>();
        for (String unitConfigId : this.getLocationConfigById(locationConfigId).getLocationConfig().getUnitIdList()) {
            try {
                UnitConfigType.UnitConfig unitConfig = this.unitRegistry.getUnitConfigById(unitConfigId);
                for (ServiceConfigType.ServiceConfig serviceConfig : unitConfig.getServiceConfigList()) {
                    if (!serviceConfig.getServiceDescription().getType().equals((Object)type)) continue;
                    unitConfigList.add(unitConfig);
                }
            }
            catch (CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not resolve UnitConfigId[" + unitConfigId + "] by device registry!", (Throwable)ex), (Logger)this.logger);
            }
        }
        return unitConfigList;
    }

    public List<ServiceConfigType.ServiceConfig> getServiceConfigsByLocation(String locationId) throws CouldNotPerformException, NotAvailableException {
        ArrayList<ServiceConfigType.ServiceConfig> serviceConfigList = new ArrayList<ServiceConfigType.ServiceConfig>();
        for (UnitConfigType.UnitConfig unitConfig : this.getUnitConfigsByLocation(locationId)) {
            serviceConfigList.addAll(unitConfig.getServiceConfigList());
        }
        return serviceConfigList;
    }

    public UnitConfigType.UnitConfig getRootLocationConfig() throws CouldNotPerformException, NotAvailableException {
        this.validateData();
        for (UnitConfigType.UnitConfig locationConfig : this.locationUnitConfigRemoteRegistry.getMessages()) {
            if (!locationConfig.getLocationConfig().hasRoot() || !locationConfig.getLocationConfig().getRoot()) continue;
            return locationConfig;
        }
        throw new NotAvailableException("rootlocation");
    }

    public Boolean isLocationConfigRegistryReadOnly() throws CouldNotPerformException {
        this.validateData();
        try {
            if (((Boolean)((JPReadOnly)JPService.getProperty(JPReadOnly.class)).getValue()).booleanValue() || !this.isConnected()) {
                return true;
            }
        }
        catch (JPServiceException ex) {
            ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not access java property!", (Throwable)ex), (Logger)this.logger);
        }
        return ((LocationRegistryDataType.LocationRegistryData)this.getData()).getLocationUnitConfigRegistryReadOnly();
    }

    public Future<UnitConfigType.UnitConfig> registerConnectionConfig(UnitConfigType.UnitConfig connectionConfig) throws CouldNotPerformException {
        try {
            return RPCHelper.callRemoteMethod((Object)connectionConfig, (RSBRemote)this, UnitConfigType.UnitConfig.class);
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not register connection config!", (Throwable)ex);
        }
    }

    public UnitConfigType.UnitConfig getConnectionConfigById(String connectionId) throws CouldNotPerformException {
        this.validateData();
        return (UnitConfigType.UnitConfig)this.connectionUnitConfigRemoteRegistry.getMessage((Object)connectionId);
    }

    public List<UnitConfigType.UnitConfig> getConnectionConfigsByLabel(String connectionLabel) throws CouldNotPerformException {
        this.validateData();
        return this.connectionUnitConfigRemoteRegistry.getMessages().stream().filter(m -> m.getLabel().equals(connectionLabel)).collect(Collectors.toCollection(ArrayList::new));
    }

    public Boolean containsConnectionConfig(UnitConfigType.UnitConfig connectionConfig) throws CouldNotPerformException {
        this.validateData();
        return this.connectionUnitConfigRemoteRegistry.contains((GeneratedMessage)connectionConfig);
    }

    public Boolean containsConnectionConfigById(String connectionId) throws CouldNotPerformException {
        this.validateData();
        return this.connectionUnitConfigRemoteRegistry.contains((Object)connectionId);
    }

    public Future<UnitConfigType.UnitConfig> updateConnectionConfig(UnitConfigType.UnitConfig connectionConfig) throws CouldNotPerformException {
        try {
            return RPCHelper.callRemoteMethod((Object)connectionConfig, (RSBRemote)this, UnitConfigType.UnitConfig.class);
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not update connection[" + connectionConfig + "]!", (Throwable)ex);
        }
    }

    public Future<UnitConfigType.UnitConfig> removeConnectionConfig(UnitConfigType.UnitConfig connectionConfig) throws CouldNotPerformException {
        try {
            return RPCHelper.callRemoteMethod((Object)connectionConfig, (RSBRemote)this, UnitConfigType.UnitConfig.class);
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not remove connection[" + connectionConfig + "]!", (Throwable)ex);
        }
    }

    public List<UnitConfigType.UnitConfig> getConnectionConfigs() throws CouldNotPerformException {
        this.validateData();
        List messages = this.connectionUnitConfigRemoteRegistry.getMessages();
        return messages;
    }

    public List<UnitConfigType.UnitConfig> getUnitConfigsByConnection(String connectionConfigId) throws CouldNotPerformException {
        ArrayList<UnitConfigType.UnitConfig> unitConfigList = new ArrayList<UnitConfigType.UnitConfig>();
        for (String unitConfigId : this.getConnectionConfigById(connectionConfigId).getConnectionConfig().getUnitIdList()) {
            unitConfigList.add(this.unitRegistry.getUnitConfigById(unitConfigId));
        }
        return unitConfigList;
    }

    public List<UnitConfigType.UnitConfig> getUnitConfigsByConnection(UnitTemplateType.UnitTemplate.UnitType type, String connectionConfigId) throws CouldNotPerformException, NotAvailableException {
        ArrayList<UnitConfigType.UnitConfig> unitConfigList = new ArrayList<UnitConfigType.UnitConfig>();
        for (String unitConfigId : this.getConnectionConfigById(connectionConfigId).getConnectionConfig().getUnitIdList()) {
            try {
                UnitConfigType.UnitConfig unitConfig = this.unitRegistry.getUnitConfigById(unitConfigId);
                if (!unitConfig.getType().equals((Object)type) && !this.unitRegistry.getSubUnitTypesOfUnitType(type).contains(unitConfig.getType())) continue;
                unitConfigList.add(unitConfig);
            }
            catch (CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not resolve UnitConfigId[" + unitConfigId + "] by device registry!", (Throwable)ex), (Logger)this.logger);
            }
        }
        return unitConfigList;
    }

    public List<UnitConfigType.UnitConfig> getUnitConfigsByConnection(ServiceTemplateType.ServiceTemplate.ServiceType type, String connectionConfigId) throws CouldNotPerformException, NotAvailableException {
        ArrayList<UnitConfigType.UnitConfig> unitConfigList = new ArrayList<UnitConfigType.UnitConfig>();
        for (String unitConfigId : this.getConnectionConfigById(connectionConfigId).getConnectionConfig().getUnitIdList()) {
            try {
                UnitConfigType.UnitConfig unitConfig = this.unitRegistry.getUnitConfigById(unitConfigId);
                for (ServiceConfigType.ServiceConfig serviceConfig : unitConfig.getServiceConfigList()) {
                    if (!serviceConfig.getServiceDescription().getType().equals((Object)type)) continue;
                    unitConfigList.add(unitConfig);
                }
            }
            catch (CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not resolve UnitConfigId[" + unitConfigId + "] by device registry!", (Throwable)ex), (Logger)this.logger);
            }
        }
        return unitConfigList;
    }

    public List<ServiceConfigType.ServiceConfig> getServiceConfigsByConnection(String connectionConfigId) throws CouldNotPerformException {
        ArrayList<ServiceConfigType.ServiceConfig> serviceConfigList = new ArrayList<ServiceConfigType.ServiceConfig>();
        for (UnitConfigType.UnitConfig unitConfig : this.getUnitConfigsByConnection(connectionConfigId)) {
            serviceConfigList.addAll(unitConfig.getServiceConfigList());
        }
        return serviceConfigList;
    }

    public Boolean isConnectionConfigRegistryReadOnly() throws CouldNotPerformException {
        this.validateData();
        try {
            if (((Boolean)((JPReadOnly)JPService.getProperty(JPReadOnly.class)).getValue()).booleanValue() || !this.isConnected()) {
                return true;
            }
        }
        catch (JPServiceException ex) {
            ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not access java property!", (Throwable)ex), (Logger)this.logger);
        }
        return ((LocationRegistryDataType.LocationRegistryData)this.getData()).getConnectionUnitConfigRegistryReadOnly();
    }

    public List<UnitConfigType.UnitConfig> getNeighborLocations(String locationId) throws CouldNotPerformException {
        UnitConfigType.UnitConfig locationConfig = this.getLocationConfigById(locationId);
        if (locationConfig.getLocationConfig().getType() != LocationConfigType.LocationConfig.LocationType.TILE) {
            throw new CouldNotPerformException("Id[" + locationId + "] does not belong to a tile and therefore its neighbors aren't defined!");
        }
        HashMap<String, UnitConfigType.UnitConfig> neighborMap = new HashMap<String, UnitConfigType.UnitConfig>();
        for (UnitConfigType.UnitConfig connectionConfig : this.getConnectionConfigs()) {
            if (!connectionConfig.getConnectionConfig().getTileIdList().contains((Object)locationId)) continue;
            for (String id : connectionConfig.getConnectionConfig().getTileIdList()) {
                if (id.equals(locationId)) continue;
                neighborMap.put(id, this.getLocationConfigById(id));
            }
        }
        return new ArrayList<UnitConfigType.UnitConfig>(neighborMap.values());
    }

    public Boolean isLocationConfigRegistryConsistent() throws CouldNotPerformException {
        try {
            this.validateData();
            return ((LocationRegistryDataType.LocationRegistryData)this.getData()).getLocationUnitConfigRegistryConsistent();
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not check consistency!", (Throwable)ex);
        }
    }

    public Boolean isConnectionConfigRegistryConsistent() throws CouldNotPerformException {
        try {
            this.validateData();
            return ((LocationRegistryDataType.LocationRegistryData)this.getData()).getConnectionUnitConfigRegistryConsistent();
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not check consistency!", (Throwable)ex);
        }
    }

    public Future<UnitProbabilityCollectionType.UnitProbabilityCollection> computeUnitIntersection(PointingRay3DFloatType.PointingRay3DFloat pointingRay3DFloat) throws CouldNotPerformException {
        try {
            this.validateData();
            return RPCHelper.callRemoteMethod((Object)pointingRay3DFloat, (RSBRemote)this, UnitProbabilityCollectionType.UnitProbabilityCollection.class);
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not compute unit intersection!", (Throwable)ex);
        }
    }

    public Future<UnitProbabilityCollectionType.UnitProbabilityCollection> computeUnitIntersection(PointingRay3DFloatCollectionType.PointingRay3DFloatCollection pointingRay3DFloatCollection) throws CouldNotPerformException {
        try {
            this.validateData();
            return RPCHelper.callRemoteMethod((Object)pointingRay3DFloatCollection, (RSBRemote)this, UnitProbabilityCollectionType.UnitProbabilityCollection.class);
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not compute unit intersection!", (Throwable)ex);
        }
    }

    static {
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)LocationRegistryDataType.LocationRegistryData.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)LocationConfigType.LocationConfig.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)ConnectionConfigType.ConnectionConfig.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)UnitConfigType.UnitConfig.getDefaultInstance()));
    }
}

