/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.registry.location.remote;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.openbase.bco.registry.location.remote.LocationRegistryRemote;
import org.openbase.jps.core.JPService;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.FatalImplementationErrorException;
import org.openbase.jul.exception.InvalidStateException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.schedule.SyncObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedLocationRegistryRemote {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachedLocationRegistryRemote.class);
    private static final SyncObject REMOTE_LOCK = new SyncObject("CachedLocationRegistryRemoteLock");
    private static LocationRegistryRemote registryRemote;
    private static boolean shutdown;

    public static synchronized void reinitialize() throws InterruptedException, CouldNotPerformException {
        try {
            if (shutdown) {
                throw new InvalidStateException("Remote service is shutting down!");
            }
            CachedLocationRegistryRemote.getRegistry().unlock(REMOTE_LOCK);
            CachedLocationRegistryRemote.getRegistry().init();
            CachedLocationRegistryRemote.getRegistry().lock(REMOTE_LOCK);
            CachedLocationRegistryRemote.getRegistry().requestData().get(10L, TimeUnit.SECONDS);
        }
        catch (CancellationException | ExecutionException | TimeoutException | CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not reinitialize " + CachedLocationRegistryRemote.class.getSimpleName() + "!", ex);
        }
    }

    public static synchronized LocationRegistryRemote getRegistry() throws InterruptedException, NotAvailableException {
        try {
            if (shutdown) {
                throw new InvalidStateException("Remote service is shutting down!");
            }
            if (registryRemote == null) {
                try {
                    registryRemote = new LocationRegistryRemote();
                    registryRemote.init();
                    registryRemote.activate();
                    registryRemote.lock(REMOTE_LOCK);
                }
                catch (Exception ex) {
                    if (registryRemote != null) {
                        registryRemote.unlock(REMOTE_LOCK);
                        registryRemote.shutdown();
                        registryRemote = null;
                    }
                    throw (CouldNotPerformException)ExceptionPrinter.printHistoryAndReturnThrowable((Throwable)new CouldNotPerformException("Could not start cached location registry remote!", (Throwable)ex), (Logger)LOGGER);
                }
            }
            return registryRemote;
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("cached location registry", (Throwable)ex);
        }
    }

    public static void waitForData() throws InterruptedException, CouldNotPerformException {
        if (registryRemote == null) {
            CachedLocationRegistryRemote.getRegistry();
        }
        registryRemote.waitForData();
    }

    public static void waitForData(long timeout, TimeUnit timeUnit) throws CouldNotPerformException, InterruptedException {
        if (registryRemote == null) {
            CachedLocationRegistryRemote.getRegistry();
        }
        registryRemote.waitForData(timeout, timeUnit);
    }

    public static void waitUntilReady() throws InterruptedException, CouldNotPerformException {
        CachedLocationRegistryRemote.getRegistry().waitUntilReady();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        if (!shutdown && !JPService.testMode()) {
            LOGGER.warn("This manual registry shutdown is only available during unit tests and not allowed during normal operation!");
            return;
        }
        SyncObject syncObject = REMOTE_LOCK;
        synchronized (syncObject) {
            if (registryRemote != null) {
                try {
                    registryRemote.unlock(REMOTE_LOCK);
                }
                catch (CouldNotPerformException ex) {
                    ExceptionPrinter.printHistory((Throwable)new FatalImplementationErrorException("Internal remote was locked by an external instance!", CachedLocationRegistryRemote.class, (Throwable)ex), (Logger)LOGGER);
                }
                registryRemote.shutdown();
                registryRemote = null;
            }
        }
    }

    static {
        shutdown = false;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                shutdown = true;
                CachedLocationRegistryRemote.shutdown();
            }
        });
    }
}

