/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.registry.scene.remote;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.openbase.bco.registry.scene.lib.SceneRegistry;
import org.openbase.bco.registry.scene.remote.SceneRegistryRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InvalidStateException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedSceneRegistryRemote {
    private static final Logger logger = LoggerFactory.getLogger(CachedSceneRegistryRemote.class);
    private static SceneRegistryRemote sceneRegistryRemote;
    private static boolean shutdown;

    public static void reinitialize() throws InterruptedException, CouldNotPerformException {
        try {
            CachedSceneRegistryRemote.getRegistry();
            sceneRegistryRemote.requestData().get(10L, TimeUnit.SECONDS);
        }
        catch (ExecutionException | TimeoutException | CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not reinitialize " + CachedSceneRegistryRemote.class.getSimpleName() + "!", ex);
        }
    }

    public static synchronized SceneRegistry getRegistry() throws InterruptedException, NotAvailableException {
        try {
            if (shutdown) {
                throw new InvalidStateException("Remote service is shutting down!");
            }
            if (sceneRegistryRemote == null) {
                try {
                    sceneRegistryRemote = new SceneRegistryRemote();
                    sceneRegistryRemote.init();
                    sceneRegistryRemote.activate();
                }
                catch (CouldNotPerformException ex) {
                    if (sceneRegistryRemote != null) {
                        sceneRegistryRemote.shutdown();
                        sceneRegistryRemote = null;
                    }
                    throw (CouldNotPerformException)ExceptionPrinter.printHistoryAndReturnThrowable((Throwable)new CouldNotPerformException("Could not start cached scene registry remote!", (Throwable)ex), (Logger)logger);
                }
            }
            return sceneRegistryRemote;
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("cached scene registry", (Throwable)ex);
        }
    }

    public static void waitForData() throws InterruptedException, CouldNotPerformException {
        if (sceneRegistryRemote == null) {
            CachedSceneRegistryRemote.getRegistry();
        }
        sceneRegistryRemote.waitForData();
    }

    public static void waitForData(long timeout, TimeUnit timeUnit) throws CouldNotPerformException, InterruptedException {
        if (sceneRegistryRemote == null) {
            CachedSceneRegistryRemote.getRegistry();
        }
        sceneRegistryRemote.waitForData(timeout, timeUnit);
    }

    public static void shutdown() {
        if (sceneRegistryRemote != null) {
            sceneRegistryRemote.shutdown();
            sceneRegistryRemote = null;
        }
    }

    static {
        shutdown = false;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                shutdown = true;
                CachedSceneRegistryRemote.shutdown();
            }
        });
    }
}

