/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.registry.scene.remote;

import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.Message;
import java.util.List;
import java.util.concurrent.Future;
import org.openbase.bco.registry.lib.com.AbstractRegistryRemote;
import org.openbase.bco.registry.lib.com.SynchronizedRemoteRegistry;
import org.openbase.bco.registry.scene.lib.SceneRegistry;
import org.openbase.bco.registry.scene.lib.jp.JPSceneRegistryScope;
import org.openbase.jps.core.JPService;
import org.openbase.jps.exception.JPServiceException;
import org.openbase.jps.preset.JPReadOnly;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.extension.rsb.com.RPCHelper;
import org.openbase.jul.extension.rsb.com.RSBRemoteService;
import org.openbase.jul.pattern.Remote;
import org.openbase.jul.storage.registry.RemoteRegistry;
import org.slf4j.Logger;
import rsb.converter.Converter;
import rsb.converter.DefaultConverterRepository;
import rsb.converter.ProtocolBufferConverter;
import rst.domotic.registry.SceneRegistryDataType;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.scene.SceneConfigType;

public class SceneRegistryRemote
extends AbstractRegistryRemote<SceneRegistryDataType.SceneRegistryData>
implements SceneRegistry,
Remote<SceneRegistryDataType.SceneRegistryData> {
    private final SynchronizedRemoteRegistry<String, UnitConfigType.UnitConfig, UnitConfigType.UnitConfig.Builder> sceneConfigRemoteRegistry;

    public SceneRegistryRemote() throws InstantiationException, InterruptedException {
        super(JPSceneRegistryScope.class, SceneRegistryDataType.SceneRegistryData.class);
        try {
            this.sceneConfigRemoteRegistry = new SynchronizedRemoteRegistry((RSBRemoteService)this, new int[]{200});
        }
        catch (CouldNotPerformException ex) {
            throw new InstantiationException((Object)this, (Throwable)ex);
        }
    }

    protected void registerRemoteRegistries() throws CouldNotPerformException {
        this.registerRemoteRegistry((RemoteRegistry)this.sceneConfigRemoteRegistry);
    }

    public SynchronizedRemoteRegistry<String, UnitConfigType.UnitConfig, UnitConfigType.UnitConfig.Builder> getSceneConfigRemoteRegistry() {
        return this.sceneConfigRemoteRegistry;
    }

    public Future<UnitConfigType.UnitConfig> registerSceneConfig(UnitConfigType.UnitConfig sceneUnitConfig) throws CouldNotPerformException {
        try {
            return RPCHelper.callRemoteMethod((Object)sceneUnitConfig, (Remote)this, UnitConfigType.UnitConfig.class);
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not register scene config!", (Throwable)ex);
        }
    }

    public UnitConfigType.UnitConfig getSceneConfigById(String sceneUnitConfigId) throws CouldNotPerformException, NotAvailableException {
        this.validateData();
        return (UnitConfigType.UnitConfig)this.sceneConfigRemoteRegistry.getMessage((Object)sceneUnitConfigId);
    }

    public Boolean containsSceneConfig(UnitConfigType.UnitConfig sceneUnitConfig) throws CouldNotPerformException {
        this.validateData();
        return this.sceneConfigRemoteRegistry.contains((GeneratedMessage)sceneUnitConfig);
    }

    public Boolean containsSceneConfigById(String sceneUnitConfigId) throws CouldNotPerformException {
        this.validateData();
        return this.sceneConfigRemoteRegistry.contains((Object)sceneUnitConfigId);
    }

    public Future<UnitConfigType.UnitConfig> updateSceneConfig(UnitConfigType.UnitConfig sceneUnitConfig) throws CouldNotPerformException {
        try {
            return RPCHelper.callRemoteMethod((Object)sceneUnitConfig, (Remote)this, UnitConfigType.UnitConfig.class);
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not update scene config!", (Throwable)ex);
        }
    }

    public Future<UnitConfigType.UnitConfig> removeSceneConfig(UnitConfigType.UnitConfig sceneUnitConfig) throws CouldNotPerformException {
        try {
            return RPCHelper.callRemoteMethod((Object)sceneUnitConfig, (Remote)this, UnitConfigType.UnitConfig.class);
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not remove scene config!", (Throwable)ex);
        }
    }

    public List<UnitConfigType.UnitConfig> getSceneConfigs() throws CouldNotPerformException, NotAvailableException {
        this.validateData();
        List messages = this.sceneConfigRemoteRegistry.getMessages();
        return messages;
    }

    public Boolean isSceneConfigRegistryReadOnly() throws CouldNotPerformException {
        this.validateData();
        try {
            if (((Boolean)((JPReadOnly)JPService.getProperty(JPReadOnly.class)).getValue()).booleanValue() || !this.isConnected()) {
                return true;
            }
        }
        catch (JPServiceException ex) {
            ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not access java property!", (Throwable)ex), (Logger)this.logger);
        }
        return ((SceneRegistryDataType.SceneRegistryData)this.getData()).getSceneUnitConfigRegistryReadOnly();
    }

    public Boolean isSceneConfigRegistryConsistent() throws CouldNotPerformException {
        try {
            this.validateData();
            return ((SceneRegistryDataType.SceneRegistryData)this.getData()).getSceneUnitConfigRegistryReadOnly();
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not check consistency!", (Throwable)ex);
        }
    }

    static {
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)SceneRegistryDataType.SceneRegistryData.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)UnitConfigType.UnitConfig.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)SceneConfigType.SceneConfig.getDefaultInstance()));
    }
}

