/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.registry.scene.remote;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.openbase.bco.registry.scene.remote.SceneRegistryRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InvalidStateException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedSceneRegistryRemote {
    private static final Logger logger = LoggerFactory.getLogger(CachedSceneRegistryRemote.class);
    private static SceneRegistryRemote registryRemote;
    private static boolean shutdown;

    public static void reinitialize() throws InterruptedException, CouldNotPerformException {
        try {
            CachedSceneRegistryRemote.getRegistry();
            registryRemote.requestData().get(10L, TimeUnit.SECONDS);
        }
        catch (ExecutionException | TimeoutException | CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not reinitialize " + CachedSceneRegistryRemote.class.getSimpleName() + "!", ex);
        }
    }

    public static synchronized SceneRegistryRemote getRegistry() throws InterruptedException, NotAvailableException {
        try {
            if (shutdown) {
                throw new InvalidStateException("Remote service is shutting down!");
            }
            if (registryRemote == null) {
                try {
                    registryRemote = new SceneRegistryRemote();
                    registryRemote.init();
                    registryRemote.activate();
                }
                catch (CouldNotPerformException ex) {
                    if (registryRemote != null) {
                        registryRemote.shutdown();
                        registryRemote = null;
                    }
                    throw (CouldNotPerformException)ExceptionPrinter.printHistoryAndReturnThrowable((Throwable)new CouldNotPerformException("Could not start cached scene registry remote!", (Throwable)ex), (Logger)logger);
                }
            }
            return registryRemote;
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("cached scene registry", (Throwable)ex);
        }
    }

    public static void waitForData() throws InterruptedException, CouldNotPerformException {
        if (registryRemote == null) {
            CachedSceneRegistryRemote.getRegistry();
        }
        registryRemote.waitForData();
    }

    public static void waitForData(long timeout, TimeUnit timeUnit) throws CouldNotPerformException, InterruptedException {
        if (registryRemote == null) {
            CachedSceneRegistryRemote.getRegistry();
        }
        registryRemote.waitForData(timeout, timeUnit);
    }

    public static void waitUntilReady() throws InterruptedException, CouldNotPerformException {
        if (registryRemote == null) {
            CachedSceneRegistryRemote.getRegistry();
        }
        registryRemote.waitUntilReady();
    }

    public static void shutdown() {
        if (registryRemote != null) {
            registryRemote.shutdown();
            registryRemote = null;
        }
    }

    static {
        shutdown = false;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                shutdown = true;
                CachedSceneRegistryRemote.shutdown();
            }
        });
    }
}

