/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.registry.unit.lib;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.Future;
import javax.vecmath.Point3d;
import org.openbase.bco.registry.lib.provider.UnitConfigCollectionProvider;
import org.openbase.bco.registry.lib.util.UnitConfigProcessor;
import org.openbase.bco.registry.unit.lib.provider.UnitTransformationProviderRegistry;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InvalidStateException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.VerificationFailedException;
import org.openbase.jul.extension.rsb.scope.ScopeGenerator;
import org.openbase.jul.iface.Shutdownable;
import org.openbase.jul.iface.annotations.RPCMethod;
import org.openbase.jul.pattern.provider.DataProvider;
import rst.domotic.authentication.AuthenticatedValueType;
import rst.domotic.registry.UnitRegistryDataType;
import rst.domotic.service.ServiceConfigType;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.UnitTemplateType;
import rst.math.Vec3DDoubleType;
import rst.rsb.ScopeType;

public interface UnitRegistry
extends DataProvider<UnitRegistryDataType.UnitRegistryData>,
UnitTransformationProviderRegistry<UnitRegistryDataType.UnitRegistryData>,
UnitConfigCollectionProvider,
Shutdownable {
    public static final double DEFAULT_RADIUS = 1.0;

    @RPCMethod
    public Future<UnitConfigType.UnitConfig> registerUnitConfig(UnitConfigType.UnitConfig var1) throws CouldNotPerformException;

    @RPCMethod
    public Future<AuthenticatedValueType.AuthenticatedValue> registerUnitConfigAuthenticated(AuthenticatedValueType.AuthenticatedValue var1) throws CouldNotPerformException;

    @RPCMethod
    public Future<UnitConfigType.UnitConfig> updateUnitConfig(UnitConfigType.UnitConfig var1) throws CouldNotPerformException;

    @RPCMethod
    public Future<AuthenticatedValueType.AuthenticatedValue> updateUnitConfigAuthenticated(AuthenticatedValueType.AuthenticatedValue var1) throws CouldNotPerformException;

    @RPCMethod
    public Future<UnitConfigType.UnitConfig> removeUnitConfig(UnitConfigType.UnitConfig var1) throws CouldNotPerformException;

    @RPCMethod
    public Future<AuthenticatedValueType.AuthenticatedValue> removeUnitConfigAuthenticated(AuthenticatedValueType.AuthenticatedValue var1) throws CouldNotPerformException;

    @RPCMethod
    public Boolean containsUnitConfig(UnitConfigType.UnitConfig var1) throws CouldNotPerformException;

    @RPCMethod
    default public Boolean containsUnitConfigByAlias(String alias) throws CouldNotPerformException {
        try {
            this.getUnitConfigByAlias(alias);
        }
        catch (NotAvailableException ex) {
            return false;
        }
        return true;
    }

    default public List<UnitConfigType.UnitConfig> getUnitConfigsByServices(ServiceTemplateType.ServiceTemplate.ServiceType ... serviceTypes) throws CouldNotPerformException {
        return this.getUnitConfigsByService(Arrays.asList(serviceTypes));
    }

    default public List<UnitConfigType.UnitConfig> getUnitConfigsByService(List<ServiceTemplateType.ServiceTemplate.ServiceType> serviceTypes) throws CouldNotPerformException {
        this.validateData();
        List unitConfigs = this.getUnitConfigs();
        for (UnitConfigType.UnitConfig unitConfig : new ArrayList(unitConfigs)) {
            boolean foundServiceType = false;
            for (ServiceTemplateType.ServiceTemplate.ServiceType serviceType : serviceTypes) {
                for (ServiceConfigType.ServiceConfig serviceConfig : unitConfig.getServiceConfigList()) {
                    if (serviceConfig.getServiceDescription().getType() != serviceType) continue;
                    foundServiceType = true;
                }
                if (foundServiceType) continue;
                unitConfigs.remove(unitConfig);
            }
        }
        return unitConfigs;
    }

    @RPCMethod
    default public String getUnitScopeById(String id) throws CouldNotPerformException {
        return ScopeGenerator.generateStringRep((ScopeType.Scope)this.getUnitConfigById(id).getScope());
    }

    @RPCMethod
    default public String getUnitScopeByAlias(String alias) throws CouldNotPerformException {
        return ScopeGenerator.generateStringRep((ScopeType.Scope)this.getUnitConfigByAlias(alias).getScope());
    }

    @RPCMethod
    public Boolean isUnitConfigRegistryReadOnly() throws CouldNotPerformException;

    @RPCMethod
    public Boolean isUnitConfigRegistryConsistent() throws CouldNotPerformException;

    @RPCMethod
    public Future<UnitTemplateType.UnitTemplate> updateUnitTemplate(UnitTemplateType.UnitTemplate var1) throws CouldNotPerformException;

    @RPCMethod
    public Boolean containsUnitTemplate(UnitTemplateType.UnitTemplate var1) throws CouldNotPerformException;

    @RPCMethod
    public Boolean containsUnitTemplateById(String var1) throws CouldNotPerformException;

    @RPCMethod
    public UnitTemplateType.UnitTemplate getUnitTemplateById(String var1) throws CouldNotPerformException;

    public List<UnitTemplateType.UnitTemplate> getUnitTemplates() throws CouldNotPerformException;

    @RPCMethod
    public UnitTemplateType.UnitTemplate getUnitTemplateByType(UnitTemplateType.UnitTemplate.UnitType var1) throws CouldNotPerformException;

    @RPCMethod
    public Boolean isUnitTemplateRegistryReadOnly() throws CouldNotPerformException;

    @RPCMethod
    public Boolean isUnitTemplateRegistryConsistent() throws CouldNotPerformException;

    @RPCMethod
    public Future<UnitConfigType.UnitConfig> registerUnitGroupConfig(UnitConfigType.UnitConfig var1) throws CouldNotPerformException;

    @RPCMethod
    public Future<UnitConfigType.UnitConfig> updateUnitGroupConfig(UnitConfigType.UnitConfig var1) throws CouldNotPerformException;

    @RPCMethod
    public Future<UnitConfigType.UnitConfig> removeUnitGroupConfig(UnitConfigType.UnitConfig var1) throws CouldNotPerformException;

    @RPCMethod
    public Boolean containsUnitGroupConfig(UnitConfigType.UnitConfig var1) throws CouldNotPerformException;

    @RPCMethod
    public Boolean containsUnitGroupConfigById(String var1) throws CouldNotPerformException;

    @RPCMethod
    default public UnitConfigType.UnitConfig getUnitConfigByAlias(String unitAlias) throws CouldNotPerformException {
        this.validateData();
        for (UnitConfigType.UnitConfig unitConfig : this.getUnitConfigs()) {
            for (String alias : unitConfig.getAliasList()) {
                if (!alias.equalsIgnoreCase(unitAlias)) continue;
                return unitConfig;
            }
        }
        throw new NotAvailableException("UnitConfig", "alias:" + unitAlias);
    }

    public List<UnitConfigType.UnitConfig> getUnitConfigsByLabel(String var1) throws CouldNotPerformException;

    default public List<UnitConfigType.UnitConfig> getUnitConfigsByLabelAndUnitType(String unitConfigLabel, UnitTemplateType.UnitTemplate.UnitType unitType) throws CouldNotPerformException {
        this.validateData();
        List<UnitConfigType.UnitConfig> unitConfigs = Collections.synchronizedList(new ArrayList());
        this.getUnitConfigs().parallelStream().filter(unitConfig -> unitConfig.getType().equals((Object)unitType) && unitConfig.getLabel().equalsIgnoreCase(unitConfigLabel)).forEach(unitConfig -> unitConfigs.add((UnitConfigType.UnitConfig)unitConfig));
        return unitConfigs;
    }

    default public List<UnitConfigType.UnitConfig> getUnitConfigs(UnitTemplateType.UnitTemplate.UnitType type) throws CouldNotPerformException {
        this.validateData();
        ArrayList<UnitConfigType.UnitConfig> unitConfigs = new ArrayList<UnitConfigType.UnitConfig>();
        for (UnitConfigType.UnitConfig unitConfig : this.getUnitConfigs()) {
            if (type != UnitTemplateType.UnitTemplate.UnitType.UNKNOWN && unitConfig.getType() != type && !this.getSubUnitTypes(type).contains(unitConfig.getType())) continue;
            unitConfigs.add(unitConfig);
        }
        return unitConfigs;
    }

    public List<UnitConfigType.UnitConfig> getDalUnitConfigs() throws CouldNotPerformException;

    public List<UnitConfigType.UnitConfig> getBaseUnitConfigs() throws CouldNotPerformException;

    public List<ServiceConfigType.ServiceConfig> getServiceConfigs() throws CouldNotPerformException;

    public List<ServiceConfigType.ServiceConfig> getServiceConfigs(ServiceTemplateType.ServiceTemplate.ServiceType var1) throws CouldNotPerformException;

    @RPCMethod
    public Boolean isUnitGroupConfigRegistryReadOnly() throws CouldNotPerformException;

    @RPCMethod
    public Boolean isUnitGroupConfigRegistryConsistent() throws CouldNotPerformException;

    @RPCMethod
    public UnitConfigType.UnitConfig getUnitGroupConfigById(String var1) throws CouldNotPerformException;

    public List<UnitConfigType.UnitConfig> getUnitGroupConfigs() throws CouldNotPerformException;

    public List<UnitConfigType.UnitConfig> getUnitGroupConfigsByUnitConfig(UnitConfigType.UnitConfig var1) throws CouldNotPerformException;

    public List<UnitConfigType.UnitConfig> getUnitGroupConfigsByUnitType(UnitTemplateType.UnitTemplate.UnitType var1) throws CouldNotPerformException;

    public List<UnitConfigType.UnitConfig> getUnitGroupConfigsByServiceTypes(List<ServiceTemplateType.ServiceTemplate.ServiceType> var1) throws CouldNotPerformException;

    public List<UnitConfigType.UnitConfig> getUnitConfigsByUnitGroupConfig(UnitConfigType.UnitConfig var1) throws CouldNotPerformException;

    public List<UnitConfigType.UnitConfig> getUnitConfigsByUnitTypeAndServiceTypes(UnitTemplateType.UnitTemplate.UnitType var1, List<ServiceTemplateType.ServiceTemplate.ServiceType> var2) throws CouldNotPerformException;

    @RPCMethod
    public UnitConfigType.UnitConfig getUnitConfigByScope(ScopeType.Scope var1) throws CouldNotPerformException;

    @Deprecated
    default public List<UnitTemplateType.UnitTemplate.UnitType> getSubUnitTypesOfUnitType(UnitTemplateType.UnitTemplate.UnitType type) throws CouldNotPerformException {
        return this.getSubUnitTypes(type);
    }

    public List<UnitTemplateType.UnitTemplate.UnitType> getSubUnitTypes(UnitTemplateType.UnitTemplate.UnitType var1) throws CouldNotPerformException;

    public List<UnitTemplateType.UnitTemplate.UnitType> getSuperUnitTypes(UnitTemplateType.UnitTemplate.UnitType var1) throws CouldNotPerformException;

    default public void verifyUnitGroupUnitConfig(UnitConfigType.UnitConfig unitConfig) throws VerificationFailedException {
        UnitConfigProcessor.verifyUnitConfig((UnitConfigType.UnitConfigOrBuilder)unitConfig, (UnitTemplateType.UnitTemplate.UnitType)UnitTemplateType.UnitTemplate.UnitType.UNIT_GROUP);
    }

    @RPCMethod
    public Boolean isDalUnitConfigRegistryReadOnly() throws CouldNotPerformException;

    @RPCMethod
    public Boolean isUserUnitRegistryReadOnly() throws CouldNotPerformException;

    @RPCMethod
    public Boolean isAuthorizationGroupUnitRegistryReadOnly() throws CouldNotPerformException;

    @RPCMethod
    public Boolean isDeviceUnitRegistryReadOnly() throws CouldNotPerformException;

    @RPCMethod
    public Boolean isUnitGroupUnitRegistryReadOnly() throws CouldNotPerformException;

    @RPCMethod
    public Boolean isLocationUnitRegistryReadOnly() throws CouldNotPerformException;

    @RPCMethod
    public Boolean isConnectionUnitRegistryReadOnly() throws CouldNotPerformException;

    @RPCMethod
    public Boolean isAgentUnitRegistryReadOnly() throws CouldNotPerformException;

    @RPCMethod
    public Boolean isAppUnitRegistryReadOnly() throws CouldNotPerformException;

    @RPCMethod
    public Boolean isSceneUnitRegistryReadOnly() throws CouldNotPerformException;

    @RPCMethod
    public Boolean isDalUnitConfigRegistryConsistent() throws CouldNotPerformException;

    @RPCMethod
    public Boolean isUserUnitRegistryConsistent() throws CouldNotPerformException;

    @RPCMethod
    public Boolean isAuthorizationGroupUnitRegistryConsistent() throws CouldNotPerformException;

    @RPCMethod
    public Boolean isDeviceUnitRegistryConsistent() throws CouldNotPerformException;

    @RPCMethod
    public Boolean isUnitGroupUnitRegistryConsistent() throws CouldNotPerformException;

    @RPCMethod
    public Boolean isLocationUnitRegistryConsistent() throws CouldNotPerformException;

    @RPCMethod
    public Boolean isConnectionUnitRegistryConsistent() throws CouldNotPerformException;

    @RPCMethod
    public Boolean isAgentUnitRegistryConsistent() throws CouldNotPerformException;

    @RPCMethod
    public Boolean isAppUnitRegistryConsistent() throws CouldNotPerformException;

    @RPCMethod
    public Boolean isSceneUnitRegistryConsistent() throws CouldNotPerformException;

    public void validateData() throws InvalidStateException;

    @RPCMethod
    public Future<ServiceTemplateType.ServiceTemplate> updateServiceTemplate(ServiceTemplateType.ServiceTemplate var1) throws CouldNotPerformException;

    @RPCMethod
    public Boolean containsServiceTemplate(ServiceTemplateType.ServiceTemplate var1) throws CouldNotPerformException;

    @RPCMethod
    public Boolean containsServiceTemplateById(String var1) throws CouldNotPerformException;

    @RPCMethod
    public ServiceTemplateType.ServiceTemplate getServiceTemplateById(String var1) throws CouldNotPerformException;

    public List<ServiceTemplateType.ServiceTemplate> getServiceTemplates() throws CouldNotPerformException;

    @RPCMethod
    public ServiceTemplateType.ServiceTemplate getServiceTemplateByType(ServiceTemplateType.ServiceTemplate.ServiceType var1) throws CouldNotPerformException;

    @RPCMethod
    public Boolean isServiceTemplateRegistryReadOnly() throws CouldNotPerformException;

    @RPCMethod
    public Boolean isServiceTemplateRegistryConsistent() throws CouldNotPerformException;

    default public List<UnitConfigType.UnitConfig> getUnitConfigsByCoordinate(Vec3DDoubleType.Vec3DDouble coordinate) throws CouldNotPerformException {
        return this.getUnitConfigsByCoordinate(coordinate, 1.0, UnitTemplateType.UnitTemplate.UnitType.UNKNOWN);
    }

    default public List<UnitConfigType.UnitConfig> getUnitConfigsByCoordinate(Vec3DDoubleType.Vec3DDouble coordinate, double radius) throws CouldNotPerformException {
        return this.getUnitConfigsByCoordinate(coordinate, radius, UnitTemplateType.UnitTemplate.UnitType.UNKNOWN);
    }

    default public List<UnitConfigType.UnitConfig> getUnitConfigsByCoordinate(Vec3DDoubleType.Vec3DDouble coordinate, double radius, UnitTemplateType.UnitTemplate.UnitType unitType) throws CouldNotPerformException {
        TreeMap<Double, UnitConfigType.UnitConfig> result = new TreeMap<Double, UnitConfigType.UnitConfig>();
        Point3d unitPosition = new Point3d(coordinate.getX(), coordinate.getY(), coordinate.getZ());
        for (UnitConfigType.UnitConfig unitConfig : this.getUnitConfigs(unitType)) {
            double distance = unitPosition.distance(this.getUnitPositionGlobalPoint3d(unitConfig));
            if (!(distance <= radius)) continue;
            result.put(radius, unitConfig);
        }
        return new ArrayList<UnitConfigType.UnitConfig>(result.values());
    }
}

