/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.registry.unit.lib.generator;

import org.openbase.bco.registry.lib.provider.DeviceClassCollectionProvider;
import org.openbase.bco.registry.lib.provider.UnitConfigCollectionProvider;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.UnitTemplateType;
import rst.spatial.ShapeType;

public class UntShapeGenerator {
    public static ShapeType.Shape generateUnitShape(UnitConfigType.UnitConfig unitConfig, UnitConfigCollectionProvider unitConfigCollectionProvider, DeviceClassCollectionProvider deviceClassCollectionProvider) throws NotAvailableException {
        try {
            ShapeType.Shape shape;
            if (unitConfig.hasPlacementConfig() && unitConfig.getPlacementConfig().hasShape() && ((shape = unitConfig.getPlacementConfig().getShape()).hasBoundingBox() || shape.getCeilingCount() != 0 || shape.getFloorCount() != 0 || shape.getFloorCeilingEdgeCount() != 0)) {
                return unitConfig.getPlacementConfig().getShape();
            }
            if (unitConfig.hasUnitHostId()) {
                return UntShapeGenerator.generateUnitShape(unitConfig.getUnitHostId(), unitConfigCollectionProvider, deviceClassCollectionProvider);
            }
            if (unitConfig.getType().equals((Object)UnitTemplateType.UnitTemplate.UnitType.DEVICE)) {
                return deviceClassCollectionProvider.getDeviceClassById(unitConfig.getDeviceConfig().getDeviceClassId()).getShape();
            }
            throw new CouldNotPerformException("Shape could not be resolved by any source.");
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("Shape", "of Unit [" + unitConfig.getLabel() + "]", (Throwable)ex);
        }
    }

    public static ShapeType.Shape generateUnitShape(String unitId, UnitConfigCollectionProvider unitConfigCollectionProvider, DeviceClassCollectionProvider deviceClassCollectionProvider) throws NotAvailableException {
        try {
            return UntShapeGenerator.generateUnitShape(unitConfigCollectionProvider.getUnitConfigById(unitId), unitConfigCollectionProvider, deviceClassCollectionProvider);
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("Shape", "of unit " + unitId, (Throwable)ex);
        }
    }
}

