/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.registry.unit.lib.provider;

import java.util.concurrent.Future;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.openbase.bco.registry.lib.provider.RootLocationConfigProvider;
import org.openbase.bco.registry.lib.provider.UnitConfigCollectionProvider;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InvalidStateException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.extension.rct.GlobalTransformReceiver;
import org.openbase.jul.iface.annotations.RPCMethod;
import org.openbase.jul.pattern.provider.DataProvider;
import org.openbase.jul.schedule.FutureProcessor;
import org.openbase.jul.schedule.GlobalCachedExecutorService;
import rct.Transform;
import rct.TransformerException;
import rst.domotic.state.EnablingStateType;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.UnitTemplateType;
import rst.geometry.AxisAlignedBoundingBox3DFloatType;
import rst.geometry.RotationType;
import rst.geometry.TranslationType;
import rst.math.Vec3DDoubleType;
import rst.spatial.ShapeType;

public interface UnitTransformationProviderRegistry<D>
extends RootLocationConfigProvider,
DataProvider<D>,
UnitConfigCollectionProvider {
    default public UnitConfigType.UnitConfig getRootLocationConfig() throws CouldNotPerformException, NotAvailableException {
        for (UnitConfigType.UnitConfig locationConfig : this.getUnitConfigs(UnitTemplateType.UnitTemplate.UnitType.LOCATION)) {
            if (!locationConfig.getLocationConfig().hasRoot() || !locationConfig.getLocationConfig().getRoot()) continue;
            return locationConfig;
        }
        throw new NotAvailableException("rootlocation");
    }

    default public Future<Transform> getRootToUnitTransformationFuture(UnitConfigType.UnitConfig unitConfigTarget) {
        try {
            return this.getUnitTransformationFuture(this.getRootLocationConfig(), unitConfigTarget);
        }
        catch (CouldNotPerformException ex) {
            return FutureProcessor.canceledFuture((Exception)new NotAvailableException("UnitTransformation", (Throwable)ex));
        }
    }

    default public Future<Transform> getUnitToRootTransformationFuture(UnitConfigType.UnitConfig unitConfigTarget) {
        try {
            return this.getUnitTransformationFuture(unitConfigTarget, this.getRootLocationConfig());
        }
        catch (CouldNotPerformException ex) {
            return FutureProcessor.canceledFuture((Exception)new NotAvailableException("UnitTransformation", (Throwable)ex));
        }
    }

    @Deprecated
    default public Future<Transform> getUnitTransformation(UnitConfigType.UnitConfig unitConfigSource, UnitConfigType.UnitConfig unitConfigTarget) {
        return this.getUnitTransformationFuture(unitConfigSource, unitConfigTarget);
    }

    default public Future<Transform> getUnitTransformationFuture(UnitConfigType.UnitConfig unitConfigSource, UnitConfigType.UnitConfig unitConfigTarget) {
        if (unitConfigSource.getEnablingState().getValue() != EnablingStateType.EnablingState.State.ENABLED) {
            return FutureProcessor.canceledFuture((Exception)new InvalidStateException("Source Unit[" + unitConfigSource.getLabel() + ":" + unitConfigSource.getId() + "] is disbled and does not provide any transformation!"));
        }
        if (unitConfigTarget.getEnablingState().getValue() != EnablingStateType.EnablingState.State.ENABLED) {
            return FutureProcessor.canceledFuture((Exception)new InvalidStateException("Target Unit[" + unitConfigTarget.getLabel() + ":" + unitConfigTarget.getId() + "] is disbled and does not provide any transformation!"));
        }
        if (!unitConfigSource.hasPlacementConfig() || !unitConfigSource.getPlacementConfig().hasPosition()) {
            return FutureProcessor.canceledFuture((Exception)new InvalidStateException("Source Unit[" + unitConfigSource.getLabel() + ":" + unitConfigSource.getId() + "] does not provide any position!"));
        }
        if (!unitConfigTarget.hasPlacementConfig() || !unitConfigTarget.getPlacementConfig().hasPosition()) {
            return FutureProcessor.canceledFuture((Exception)new InvalidStateException("Target Unit[" + unitConfigTarget.getLabel() + ":" + unitConfigTarget.getId() + "] does not provide any position!"));
        }
        if (!unitConfigSource.getPlacementConfig().hasTransformationFrameId() || unitConfigSource.getPlacementConfig().getTransformationFrameId().isEmpty()) {
            return FutureProcessor.canceledFuture((Exception)new InvalidStateException("Source Unit[" + unitConfigSource.getLabel() + ":" + unitConfigSource.getId() + "] does not provide yet a transformation frame id!"));
        }
        if (!unitConfigTarget.getPlacementConfig().hasTransformationFrameId() || unitConfigTarget.getPlacementConfig().getTransformationFrameId().isEmpty()) {
            return FutureProcessor.canceledFuture((Exception)new InvalidStateException("Target Unit[" + unitConfigTarget.getLabel() + ":" + unitConfigTarget.getId() + "] does not provide yet a transformation frame id!"));
        }
        Future transformationFuture = GlobalTransformReceiver.getInstance().requestTransform(unitConfigTarget.getPlacementConfig().getTransformationFrameId(), unitConfigSource.getPlacementConfig().getTransformationFrameId(), System.currentTimeMillis());
        return GlobalCachedExecutorService.allOfInclusiveResultFuture((Future)transformationFuture, (Future[])new Future[]{this.getDataFuture()});
    }

    default public Transform getRootToUnitTransformation(UnitConfigType.UnitConfig unitConfigTarget) throws NotAvailableException {
        try {
            return this.lookupUnitTransformation(this.getRootLocationConfig(), unitConfigTarget);
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("UnitTransformation", (Throwable)ex);
        }
    }

    default public Transform getUnitToRootTransformation(UnitConfigType.UnitConfig unitConfigTarget) throws NotAvailableException {
        try {
            return this.lookupUnitTransformation(unitConfigTarget, this.getRootLocationConfig());
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("UnitTransformation", (Throwable)ex);
        }
    }

    @Deprecated
    default public Transform lookupUnitTransformation(UnitConfigType.UnitConfig unitConfigSource, UnitConfigType.UnitConfig unitConfigTarget) throws NotAvailableException {
        try {
            if (unitConfigSource.getEnablingState().getValue() != EnablingStateType.EnablingState.State.ENABLED) {
                throw new InvalidStateException("Source Unit[" + unitConfigSource.getLabel() + ":" + unitConfigSource.getId() + "] is disbled and does not provide any transformation!");
            }
            if (unitConfigTarget.getEnablingState().getValue() != EnablingStateType.EnablingState.State.ENABLED) {
                throw new InvalidStateException("Target Unit[" + unitConfigTarget.getLabel() + ":" + unitConfigTarget.getId() + "] is disbled and does not provide any transformation!");
            }
            if (!unitConfigSource.hasPlacementConfig() || !unitConfigSource.getPlacementConfig().hasPosition()) {
                throw new InvalidStateException("Source Unit[" + unitConfigSource.getLabel() + ":" + unitConfigSource.getId() + "] does not provide any position!");
            }
            if (!unitConfigTarget.hasPlacementConfig() || !unitConfigTarget.getPlacementConfig().hasPosition()) {
                throw new InvalidStateException("Target Unit[" + unitConfigTarget.getLabel() + ":" + unitConfigTarget.getId() + "] does not provide any position!");
            }
            if (!unitConfigSource.getPlacementConfig().hasTransformationFrameId() || unitConfigSource.getPlacementConfig().getTransformationFrameId().isEmpty()) {
                throw new InvalidStateException("Source Unit[" + unitConfigSource.getLabel() + ":" + unitConfigSource.getId() + "] does not provide yet a transformation frame id!");
            }
            if (!unitConfigTarget.getPlacementConfig().hasTransformationFrameId() || unitConfigTarget.getPlacementConfig().getTransformationFrameId().isEmpty()) {
                throw new InvalidStateException("Target Unit[" + unitConfigTarget.getLabel() + ":" + unitConfigTarget.getId() + "] does not provide yet a transformation frame id!");
            }
            return GlobalTransformReceiver.getInstance().lookupTransform(unitConfigTarget.getPlacementConfig().getTransformationFrameId(), unitConfigSource.getPlacementConfig().getTransformationFrameId(), System.currentTimeMillis());
        }
        catch (CouldNotPerformException | TransformerException ex) {
            throw new NotAvailableException("UnitTransformation", ex);
        }
    }

    default public Transform3D getRootToUnitTransform3D(UnitConfigType.UnitConfig unitConfig) throws NotAvailableException {
        try {
            return this.getRootToUnitTransformation(unitConfig).getTransform();
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("Transform3D", (Throwable)ex);
        }
    }

    default public Transform3D getUnitToRootTransform3D(UnitConfigType.UnitConfig unitConfig) throws NotAvailableException {
        try {
            return this.getUnitToRootTransformation(unitConfig).getTransform();
        }
        catch (NotAvailableException ex) {
            throw new NotAvailableException("Transform3Dinverse", (Throwable)ex);
        }
    }

    default public Point3d getUnitPositionGlobalPoint3d(UnitConfigType.UnitConfig unitConfig) throws NotAvailableException {
        try {
            return new Point3d((Tuple3d)this.getUnitPositionGlobalVector3d(unitConfig));
        }
        catch (NotAvailableException ex) {
            throw new NotAvailableException("GlobalPositionVector", (Throwable)ex);
        }
    }

    @RPCMethod
    default public Vec3DDoubleType.Vec3DDouble getUnitPositionGlobalVec3DDouble(UnitConfigType.UnitConfig unitConfig) throws NotAvailableException {
        try {
            Vector3d vec = this.getUnitPositionGlobalVector3d(unitConfig);
            return Vec3DDoubleType.Vec3DDouble.newBuilder().setX(vec.x).setY(vec.y).setZ(vec.z).build();
        }
        catch (NotAvailableException ex) {
            throw new NotAvailableException("GlobalPositionVector", (Throwable)ex);
        }
    }

    default public Vector3d getUnitPositionGlobalVector3d(UnitConfigType.UnitConfig unitConfig) throws NotAvailableException {
        try {
            Transform3D transformation = this.getUnitToRootTransform3D(unitConfig);
            Vector3d pos = new Vector3d();
            transformation.get(pos);
            return pos;
        }
        catch (NotAvailableException ex) {
            throw new NotAvailableException("GlobalPositionVector", (Throwable)ex);
        }
    }

    default public TranslationType.Translation getUnitPositionGlobal(UnitConfigType.UnitConfig unitConfig) throws NotAvailableException {
        try {
            Point3d pos = this.getUnitPositionGlobalPoint3d(unitConfig);
            return TranslationType.Translation.newBuilder().setX(pos.x).setY(pos.y).setZ(pos.z).build();
        }
        catch (NotAvailableException ex) {
            throw new NotAvailableException("GlobalPosition", (Throwable)ex);
        }
    }

    default public Quat4d getUnitRotationGlobalQuat4d(UnitConfigType.UnitConfig unitConfig) throws NotAvailableException {
        try {
            Transform3D transformation = this.getUnitToRootTransform3D(unitConfig);
            Quat4d quat = new Quat4d();
            transformation.get(quat);
            return quat;
        }
        catch (NotAvailableException ex) {
            throw new NotAvailableException("GlobalRotationQuat", (Throwable)ex);
        }
    }

    default public RotationType.Rotation getUnitRotationGlobal(UnitConfigType.UnitConfig unitConfig) throws NotAvailableException {
        try {
            Quat4d quat = this.getUnitRotationGlobalQuat4d(unitConfig);
            return RotationType.Rotation.newBuilder().setQw(quat.w).setQx(quat.x).setQy(quat.y).setQz(quat.z).build();
        }
        catch (NotAvailableException ex) {
            throw new NotAvailableException("GlobalRotation", (Throwable)ex);
        }
    }

    default public Point3d getUnitBoundingBoxCenterPoint3d(UnitConfigType.UnitConfig unitConfig) throws NotAvailableException {
        AxisAlignedBoundingBox3DFloatType.AxisAlignedBoundingBox3DFloat bb = this.getUnitShape(unitConfig).getBoundingBox();
        TranslationType.Translation lfc = bb.getLeftFrontBottom();
        Point3d center = new Point3d((double)bb.getWidth(), (double)bb.getDepth(), (double)bb.getHeight());
        center.scale(0.5);
        center.add((Tuple3d)new Point3d(lfc.getX(), lfc.getY(), lfc.getZ()));
        return center;
    }

    default public Point3d getUnitBoundingBoxCenterGlobalPoint3d(UnitConfigType.UnitConfig unitConfig) throws NotAvailableException {
        try {
            Transform3D transformation = this.getUnitToRootTransform3D(unitConfig);
            Point3d center = this.getUnitBoundingBoxCenterPoint3d(unitConfig);
            transformation.transform(center);
            return center;
        }
        catch (NotAvailableException ex) {
            throw new NotAvailableException("GlobalBoundingBoxCenter", (Throwable)ex);
        }
    }

    default public ShapeType.Shape getUnitShape(String unitId) throws NotAvailableException {
        try {
            return this.getUnitShape(this.getUnitConfigById(unitId));
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("Shape", "of unit " + unitId, (Throwable)ex);
        }
    }

    public ShapeType.Shape getUnitShape(UnitConfigType.UnitConfig var1) throws NotAvailableException;
}

