/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jps.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openbase.jps.core.AbstractJavaProperty;
import org.openbase.jps.exception.JPBadArgumentException;
import org.openbase.jps.exception.JPInitializationException;
import org.openbase.jps.exception.JPNotAvailableException;
import org.openbase.jps.exception.JPParsingException;
import org.openbase.jps.exception.JPServiceException;
import org.openbase.jps.exception.JPValidationException;
import org.openbase.jps.preset.JPHelp;
import org.openbase.jps.preset.JPTestMode;
import org.openbase.jps.preset.JPVerbose;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPService {
    private static final Logger logger = LoggerFactory.getLogger(JPService.class);
    private static final Set<Class<? extends AbstractJavaProperty>> registeredPropertyClasses = new HashSet<Class<? extends AbstractJavaProperty>>();
    private static final HashMap<Class<? extends AbstractJavaProperty>, AbstractJavaProperty> initializedProperties = new HashMap();
    private static final HashMap<Class<? extends AbstractJavaProperty>, AbstractJavaProperty> loadedProperties = new HashMap();
    private static final HashMap<Class<? extends AbstractJavaProperty>, Object> overwrittenDefaultValueMap = new HashMap();
    private static String applicationName = "";
    private static boolean argumentsAnalyzed = false;

    private static void initJPSDefaultProperties() {
        JPService.registerProperty(JPHelp.class);
        JPService.registerProperty(JPVerbose.class);
    }

    public static void setApplicationName(String name) {
        applicationName = name;
    }

    public static void setApplicationName(Class mainclass) {
        JPService.setApplicationName(mainclass.getSimpleName().toLowerCase());
    }

    public static String getApplicationName() {
        return applicationName;
    }

    public static synchronized <V, C extends AbstractJavaProperty<V>> void registerProperty(Class<C> propertyClass, V defaultValue) {
        if (argumentsAnalyzed) {
            logger.warn("Property modification after argumend analysis detected! Read JPService doc for more information.");
        }
        registeredPropertyClasses.add(propertyClass);
        overwrittenDefaultValueMap.put(propertyClass, defaultValue);
    }

    public static synchronized <V, C extends AbstractJavaProperty<V>> void overwriteDefaultValue(Class<C> propertyClass, V defaultValue) {
        if (argumentsAnalyzed) {
            logger.warn("Property modification after argumend analysis detected! Read JPService doc for more information.");
        }
        overwrittenDefaultValueMap.put(propertyClass, defaultValue);
    }

    public static void registerProperty(Class<? extends AbstractJavaProperty> propertyClass) {
        if (argumentsAnalyzed) {
            logger.warn("Property modification after argumend analysis detected! Read JPService doc for more information.");
        }
        registeredPropertyClasses.add(propertyClass);
    }

    public static void parseAndExitOnError(String[] args) {
        block4: {
            try {
                JPService.parse(args);
            }
            catch (JPServiceException ex) {
                try {
                    JPService.printHelp();
                }
                catch (JPServiceException ex1) {
                    logger.error("Could not print help text!");
                    JPService.printError(ex1);
                }
                JPService.printError(ex);
                logger.info("Exit " + applicationName);
                if (JPService.testMode()) break block4;
                System.exit(255);
            }
        }
    }

    public static void printError(String message, Throwable cause) {
        JPService.printError(new JPServiceException(message, cause));
    }

    public static void printError(Throwable cause) {
        logger.error("=========================================================================");
        JPService.printError(cause, "=");
        try {
            if (((Boolean)JPService.getProperty(JPVerbose.class).getValue()).booleanValue()) {
                cause.printStackTrace(System.err);
            }
        }
        catch (JPNotAvailableException ex) {
            logger.error("Could not load exception stack: " + ex.getMessage());
        }
        logger.error("=========================================================================");
    }

    protected static void printError(Throwable cause, String prefix) {
        logger.error(prefix + " " + cause.getMessage());
        Throwable innerCause = cause.getCause();
        if (innerCause != null) {
            JPService.printError(innerCause, prefix + "==");
        }
    }

    private static void printValueModification(String[] args) {
        if (args == null) {
            return;
        }
        String argsString = "";
        for (String arg : args) {
            argsString = arg.startsWith("--") ? argsString + "\n\t" : (arg.startsWith("-") ? argsString + "\n\t " : argsString + " ");
            argsString = argsString + arg;
        }
        argsString = argsString + "\n";
        logger.info("[command line value modification]" + argsString);
    }

    private static void initRegisteredProperties() throws JPServiceException {
        JPService.initRegisteredProperties(null);
    }

    private static void initRegisteredProperties(String[] args) throws JPServiceException {
        loadedProperties.clear();
        try {
            boolean modification = true;
            while (modification) {
                modification = false;
                for (Class<? extends AbstractJavaProperty> propertyClass : new HashSet<Class<? extends AbstractJavaProperty>>(registeredPropertyClasses)) {
                    if (initializedProperties.containsKey(propertyClass)) continue;
                    JPService.initProperty(propertyClass);
                    modification = true;
                }
            }
            if (args != null) {
                JPService.parseArguments(args);
                loadedProperties.clear();
            }
            JPService.loadAllProperties();
        }
        catch (JPServiceException ex) {
            throw new JPServiceException("Could not init registered properties!", ex);
        }
        JPService.getProperty(JPHelp.class);
    }

    private static synchronized AbstractJavaProperty initProperty(Class<? extends AbstractJavaProperty> propertyClass) throws JPServiceException {
        try {
            if (initializedProperties.containsKey(propertyClass)) {
                throw new JPServiceException("Already initialized!");
            }
            if (!registeredPropertyClasses.contains(propertyClass)) {
                registeredPropertyClasses.add(propertyClass);
            }
            AbstractJavaProperty newInstance = propertyClass.newInstance();
            initializedProperties.put(propertyClass, newInstance);
            return newInstance;
        }
        catch (IllegalAccessException | InstantiationException | JPServiceException ex) {
            throw new JPInitializationException("Could not init " + propertyClass.getSimpleName(), ex);
        }
    }

    public static void parse(String[] args) throws JPServiceException {
        argumentsAnalyzed = true;
        try {
            JPService.printValueModification(args);
            JPService.initRegisteredProperties(args);
        }
        catch (Exception ex) {
            throw new JPServiceException("Could not analyse arguments: " + ex.getMessage(), ex);
        }
    }

    public static void setupJUnitTestMode() throws JPServiceException {
        try {
            JPService.registerProperty(JPVerbose.class, true);
            JPService.registerProperty(JPTestMode.class, true);
            JPService.initRegisteredProperties();
        }
        catch (JPValidationException ex) {
            throw new JPServiceException("Could not setup JPService for UnitTestMode!", ex);
        }
    }

    private static void loadProperty(AbstractJavaProperty property) throws JPServiceException {
        try {
            if (loadedProperties.containsKey(property.getClass()) && !loadedProperties.get(property.getClass()).neetToBeParsed()) {
                return;
            }
            JPService.parseProperty(property);
            if (overwrittenDefaultValueMap.containsKey(property.getClass())) {
                property.overwriteDefaultValue(overwrittenDefaultValueMap.get(property.getClass()));
            }
            property.updateValue();
            property.validate();
        }
        catch (JPBadArgumentException | JPValidationException ex) {
            throw new JPServiceException("Could not load " + property + "!", ex);
        }
        loadedProperties.put(property.getClass(), property);
        try {
            property.loadAction();
        }
        catch (Throwable th) {
            JPService.printError(new JPServiceException("Could not load action for Property[" + property.getClass().getSimpleName() + "]", th));
        }
    }

    private static void parseArguments(String[] args) throws JPServiceException {
        AbstractJavaProperty lastProperty = null;
        for (String arg : args) {
            try {
                arg = arg.trim();
                if (arg.equals("--")) break;
                if (arg.startsWith("-") || arg.startsWith("--")) {
                    boolean unknownProperty = true;
                    for (AbstractJavaProperty property : initializedProperties.values()) {
                        if (!property.match(arg)) continue;
                        lastProperty = property;
                        lastProperty.reset();
                        unknownProperty = false;
                        break;
                    }
                    if (!unknownProperty) continue;
                    throw new JPParsingException("unknown property: " + arg);
                }
                if (lastProperty == null) {
                    throw new JPParsingException("= bad property: " + arg);
                }
                lastProperty.addArgument(arg);
            }
            catch (JPServiceException ex) {
                throw new JPServiceException("Could not parse Argument[" + arg + "]!", ex);
            }
        }
    }

    private static void parseProperty(AbstractJavaProperty property) throws JPBadArgumentException {
        if (property.neetToBeParsed()) {
            try {
                property.parseArguments();
            }
            catch (Exception ex) {
                throw new JPBadArgumentException("Could not parse " + property + "!", ex);
            }
        }
    }

    public static synchronized <C extends AbstractJavaProperty> C getProperty(Class<C> propertyClass) throws JPNotAvailableException {
        try {
            if (propertyClass == null) {
                throw new JPNotAvailableException(propertyClass, (Throwable)new JPServiceException("Given propertyClass is a Nullpointer!"));
            }
            if (!loadedProperties.containsKey(propertyClass) || loadedProperties.get(propertyClass).neetToBeParsed()) {
                if (!initializedProperties.containsKey(propertyClass)) {
                    JPService.initProperty(propertyClass);
                }
                JPService.loadProperty(initializedProperties.get(propertyClass));
            }
            return (C)loadedProperties.get(propertyClass);
        }
        catch (JPServiceException ex) {
            throw new JPNotAvailableException(propertyClass, (Throwable)ex);
        }
    }

    private static List<AbstractJavaProperty> loadAllProperties() throws JPServiceException {
        ArrayList<AbstractJavaProperty> properties = new ArrayList<AbstractJavaProperty>();
        HashSet<Class<? extends AbstractJavaProperty>> currentlyregisteredPropertyClasses = new HashSet<Class<? extends AbstractJavaProperty>>(registeredPropertyClasses);
        boolean modification = true;
        while (modification) {
            modification = false;
            currentlyregisteredPropertyClasses.stream().forEach(propertyClass -> {
                try {
                    properties.add((AbstractJavaProperty)JPService.getProperty(propertyClass));
                }
                catch (Exception ex) {
                    JPService.printError(new JPServiceException("Could not load Property[" + propertyClass.getSimpleName() + "]!", ex));
                }
            });
        }
        return properties;
    }

    public static void printHelp() throws JPServiceException {
        String help = "\n\nusage: " + applicationName;
        String header = "";
        ArrayList<AbstractJavaProperty> propertyList = new ArrayList<AbstractJavaProperty>(initializedProperties.values());
        Collections.sort(propertyList);
        header = propertyList.stream().map(property -> " [" + property.getSyntax() + "]").reduce(header, String::concat);
        help = help + JPService.newLineFormatter(header, "\n\t", 100);
        help = help + "\nwhere:\n";
        List<AbstractJavaProperty> properties = JPService.loadAllProperties();
        Collections.sort(properties, (o1, o2) -> {
            try {
                return o1.getDefaultExample().compareTo(o2.getDefaultExample());
            }
            catch (Exception ex) {
                logger.warn("Could not compare properties!");
                return -1;
            }
        });
        for (AbstractJavaProperty property2 : properties) {
            help = help + "\t" + property2.getSyntax() + " " + JPService.getDefault(property2);
            help = help + "\n ";
            help = help + "\t\t" + JPService.newLineFormatter(property2.getDescription(), "\n\t\t", 100);
            help = help + "\n";
        }
        logger.info(help);
    }

    private static String getDefault(AbstractJavaProperty property) {
        return "[Default: " + property.getDefaultExample() + "]";
    }

    public static String newLineFormatter(String text, String newLineOperator, int maxChars) {
        String[] textArray = text.split(" ");
        text = "";
        int charCounter = 0;
        for (int i = 0; i < textArray.length; ++i) {
            if (charCounter + textArray[i].length() >= maxChars) {
                text = text + newLineOperator + textArray[i];
                charCounter = textArray[i].length();
            } else {
                text = text + textArray[i];
                charCounter = textArray[i].contains("\n") ? textArray[i].indexOf("\n") : (charCounter += textArray[i].length());
            }
            if (i == textArray.length - 1) continue;
            text = text + " ";
        }
        return text;
    }

    public static void reset() {
        registeredPropertyClasses.clear();
        initializedProperties.clear();
        loadedProperties.clear();
        overwrittenDefaultValueMap.clear();
        argumentsAnalyzed = false;
        JPService.initJPSDefaultProperties();
    }

    public static boolean testMode() {
        try {
            return (Boolean)JPService.getProperty(JPTestMode.class).getValue();
        }
        catch (JPServiceException ex) {
            JPService.printError("Could not detect TestMode!", ex);
            return false;
        }
    }

    static {
        JPService.initJPSDefaultProperties();
    }
}

