/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jps.preset;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import java.util.List;
import org.openbase.jps.exception.JPNotAvailableException;
import org.openbase.jps.exception.JPServiceException;
import org.openbase.jps.preset.AbstractJPEnum;
import org.slf4j.LoggerFactory;

public class JPLogLevel
extends AbstractJPEnum<LogLevel> {
    public static final String[] COMMAND_IDENTIFIERS = new String[]{"--log-level"};

    public JPLogLevel() {
        super(COMMAND_IDENTIFIERS);
    }

    @Override
    protected LogLevel getPropertyDefaultValue() throws JPNotAvailableException {
        try {
            return LogLevel.valueOf(this.getRootLogger().getLevel().toString());
        }
        catch (Exception ex) {
            throw new JPNotAvailableException(this.getClass(), (Throwable)ex);
        }
    }

    @Override
    public String getDescription() {
        return "Changes the log level to the given one. Valid values are [].";
    }

    private Logger getRootLogger() throws JPServiceException {
        try {
            return (Logger)LoggerFactory.getLogger((String)"ROOT");
        }
        catch (Exception ex) {
            throw new JPServiceException("RootLogger is not available!", ex);
        }
    }

    @Override
    protected LogLevel parse(List<String> arguments) throws JPServiceException {
        LogLevel logLevel = (LogLevel)((Object)super.parse((List)arguments));
        this.getRootLogger().setLevel(Level.valueOf((String)logLevel.name()));
        return logLevel;
    }

    public static enum LogLevel {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR,
        OFF;

    }
}

