/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jps.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.openbase.jps.exception.JPBadArgumentException;
import org.openbase.jps.exception.JPNotAvailableException;
import org.openbase.jps.exception.JPParsingException;
import org.openbase.jps.exception.JPServiceException;
import org.openbase.jps.exception.JPValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJavaProperty<V>
implements Comparable<AbstractJavaProperty> {
    private static final String NOT_IDENTIFIERED = "";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final String[] propertyIdentifiers;
    protected final String[] argumentIdentifiers;
    protected final List<String> arguments;
    private final TreeMap<ValueType, Exception> errorReportMap;
    private final List<Class<? extends AbstractJavaProperty>> dependencyList;
    protected String identifier;
    private V value;
    private V parsedValue;
    private V applicationDefaultValue;
    private ValueType valueType;
    private ValueType defaultValueType;
    private boolean parsed;

    public AbstractJavaProperty(String[] propertyIdentifier) {
        this.propertyIdentifiers = propertyIdentifier;
        this.argumentIdentifiers = this.generateArgumentIdentifiers();
        this.arguments = new ArrayList<String>(this.argumentIdentifiers.length);
        this.dependencyList = new ArrayList<Class<? extends AbstractJavaProperty>>();
        this.identifier = NOT_IDENTIFIERED;
        this.applicationDefaultValue = null;
        this.defaultValueType = ValueType.PropertyDefault;
        this.valueType = ValueType.PropertyDefault;
        this.errorReportMap = new TreeMap(Comparator.comparingInt(Enum::ordinal));
        this.reset();
    }

    protected boolean match(String commandIdentifier) {
        for (String command : this.propertyIdentifiers) {
            if (!command.equals(commandIdentifier)) continue;
            this.identifier = commandIdentifier;
            return true;
        }
        return false;
    }

    protected boolean neetToBeParsed() {
        return this.isIdentified() && !this.isParsed();
    }

    protected final void reset() {
        this.arguments.clear();
        this.parsed = false;
    }

    protected void addArgument(String arg) {
        this.arguments.add(arg);
    }

    protected void parseArguments() throws JPParsingException {
        try {
            this.valueType = ValueType.CommandLine;
            this.parsedValue = this.parse(Collections.unmodifiableList(this.arguments));
        }
        catch (Exception ex) {
            this.logger.error("Could not parse argument[" + this.identifier + "]!");
            this.logger.info("The valid syntax would be: " + this.getSyntax() + "\n");
            throw new JPParsingException("Could not parse argument[" + this.identifier + "]!", ex);
        }
        this.parsed = true;
    }

    public V getValue() {
        return this.value;
    }

    protected void setValue(V value, ValueType valueType) {
        this.value = value;
        this.valueType = valueType;
    }

    public void update(V value) {
        this.value = value;
        this.valueType = ValueType.Runtime;
    }

    protected void updateValue() throws JPServiceException {
        V newValue;
        switch (this.valueType) {
            case PropertyDefault: {
                newValue = this.getPropertyDefaultValue();
                break;
            }
            case ApplicationDefault: {
                newValue = this.applicationDefaultValue;
                break;
            }
            case CommandLine: {
                newValue = this.parsedValue;
                break;
            }
            case Runtime: {
                return;
            }
            default: {
                throw new AssertionError((Object)((Object)((Object)this.valueType) + " is an unknown state!"));
            }
        }
        this.setValue(newValue, this.valueType);
    }

    protected void overwriteDefaultValue(V defaultValue) {
        this.applicationDefaultValue = defaultValue;
        this.defaultValueType = ValueType.ApplicationDefault;
        if (this.valueType.equals((Object)ValueType.PropertyDefault)) {
            this.setValue(this.applicationDefaultValue, ValueType.ApplicationDefault);
        }
    }

    public String toString() {
        String display = this.getClass().getSimpleName() + "[Identifier: " + this.identifier + " ";
        for (String arg : this.arguments) {
            display = display + "|" + arg;
        }
        display = display + "]";
        return display;
    }

    @Deprecated
    protected boolean isIdentifiered() {
        return this.isIdentified();
    }

    protected boolean isIdentified() {
        return !this.identifier.isEmpty();
    }

    public V getDefaultValue() throws JPNotAvailableException {
        switch (this.defaultValueType) {
            case ApplicationDefault: {
                return this.applicationDefaultValue;
            }
        }
        return this.getPropertyDefaultValue();
    }

    protected abstract String[] generateArgumentIdentifiers();

    protected String[] getPropertyIdentifiers() {
        return this.propertyIdentifiers;
    }

    protected String[] getArgumentIdentifiers() {
        return this.argumentIdentifiers;
    }

    public String getDefaultExample() {
        try {
            return this.propertyIdentifiers[0] + " " + this.getDefaultValue();
        }
        catch (JPNotAvailableException ex) {
            return this.propertyIdentifiers[0];
        }
    }

    public String getSyntax() {
        String syntax = NOT_IDENTIFIERED;
        for (int i = 0; i < this.propertyIdentifiers.length; ++i) {
            syntax = syntax + this.propertyIdentifiers[i];
            for (String argumentIdentifier : this.argumentIdentifiers) {
                syntax = syntax + " '" + argumentIdentifier + "'";
            }
            if (i >= this.propertyIdentifiers.length - 1) continue;
            syntax = syntax + " | ";
        }
        return syntax;
    }

    public boolean isParsed() {
        return this.parsed;
    }

    @Override
    public int compareTo(AbstractJavaProperty o) {
        return this.propertyIdentifiers[0].compareTo(o.propertyIdentifiers[0]);
    }

    protected String getOneArgumentResult() throws JPBadArgumentException {
        this.checkArgumentCount(1);
        return this.arguments.get(0);
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    protected void checkArgumentCount(int size) throws JPBadArgumentException {
        this.checkArgumentCount(size, size);
    }

    protected void checkArgumentCountMin(int min) throws JPBadArgumentException {
        if (this.arguments.size() < min) {
            throw new JPBadArgumentException("Missing property arguments!");
        }
    }

    protected void checkArgumentCountMax(int max) throws JPBadArgumentException {
        if (this.arguments.size() > max) {
            throw new JPBadArgumentException("To many property arguments!");
        }
    }

    protected void checkArgumentCount(int min, int max) throws JPBadArgumentException {
        int size = this.arguments.size();
        if (size < min) {
            throw new JPBadArgumentException("Missing property arguments!");
        }
        if (size > max) {
            throw new JPBadArgumentException("To many property arguments!");
        }
    }

    protected void addErrorReport(Exception exception, ValueType valueType) {
        this.errorReportMap.put(valueType, exception);
    }

    protected Exception getErrorReport() {
        return this.errorReportMap.lastEntry().getValue();
    }

    protected Map<ValueType, Exception> getErrorReportMap() {
        return this.errorReportMap;
    }

    protected void validate() throws JPValidationException {
    }

    protected void loadAction() {
    }

    protected abstract V getPropertyDefaultValue() throws JPNotAvailableException;

    protected abstract V parse(List<String> var1) throws Exception;

    public List<Class<? extends AbstractJavaProperty>> getDependencyList() {
        return this.dependencyList;
    }

    protected void registerDependingProperty(Class<? extends AbstractJavaProperty> dependency) {
        assert (dependency != null);
        this.dependencyList.add(dependency);
    }

    public abstract String getDescription();

    public static enum ValueType {
        PropertyDefault,
        ApplicationDefault,
        CommandLine,
        Runtime;

    }
}

