/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jps.preset;

import java.lang.reflect.ParameterizedType;
import java.util.List;
import org.openbase.jps.core.AbstractJavaProperty;
import org.openbase.jps.exception.JPBadArgumentException;

public abstract class AbstractJPClass<C>
extends AbstractJavaProperty<Class<C>> {
    public AbstractJPClass(String[] commandIdentifier) {
        super(commandIdentifier);
    }

    @Override
    protected String[] generateArgumentIdentifiers() {
        String[] args = new String[]{this.detectTypeClass().getSimpleName().toUpperCase()};
        return args;
    }

    @Override
    protected Class<C> parse(List<String> arguments) throws JPBadArgumentException {
        Class<?> clazz;
        String oneArgumentResult = this.getOneArgumentResult();
        try {
            clazz = this.getClass().getClassLoader().loadClass(oneArgumentResult);
        }
        catch (ClassNotFoundException ex) {
            throw new JPBadArgumentException("Could not load given Class!", ex);
        }
        try {
            return clazz;
        }
        catch (ClassCastException ex) {
            throw new JPBadArgumentException("Given Class[" + clazz.getName() + "] is not a instance of Class[" + this.detectTypeClass().getName() + "]!", ex);
        }
    }

    public Class<C> detectTypeClass() {
        return (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }
}

