/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jps.preset;

import java.io.File;
import org.openbase.jps.core.JPService;
import org.openbase.jps.exception.JPNotAvailableException;
import org.openbase.jps.preset.AbstractJPDirectory;
import org.openbase.jps.preset.JPTmpDirectory;
import org.openbase.jps.preset.JPUsrDirectory;
import org.openbase.jps.tools.FileHandler;

public class JPPrefix
extends AbstractJPDirectory {
    public static final String[] COMMAND_IDENTIFIERS = new String[]{"-p", "--prefix"};

    public JPPrefix() {
        super(COMMAND_IDENTIFIERS, FileHandler.ExistenceHandling.Must, FileHandler.AutoMode.Off);
        this.registerDependingProperty(JPUsrDirectory.class);
    }

    @Override
    protected File getPropertyDefaultValue() throws JPNotAvailableException {
        if (JPService.testMode()) {
            return (File)JPService.getProperty(JPTmpDirectory.class).getValue();
        }
        String globalPrefix = System.getenv("prefix");
        if (globalPrefix != null) {
            return new File(globalPrefix);
        }
        globalPrefix = System.getenv("PREFIX");
        if (globalPrefix != null) {
            return new File(globalPrefix);
        }
        return (File)JPService.getProperty(JPUsrDirectory.class).getValue();
    }

    @Override
    public String getDescription() {
        return "Set the application prefix, which is used for accessing binaries, shared data and templates.";
    }
}

