/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jps.preset;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.openbase.jps.core.JPService;
import org.openbase.jps.exception.JPValidationException;
import org.openbase.jps.preset.AbstractJPDirectory;
import org.openbase.jps.preset.AbstractJPFile;
import org.openbase.jps.tools.FileHandler;

public class JPTmpDirectory
extends AbstractJPDirectory {
    public static final String SYSTEM_TMP_DIRECTORY = System.getProperty("java.io.tmpdir", "/tmp");
    public static final String TEST_DIRECTORY = "test";
    public static final String[] COMMAND_IDENTIFIERS = new String[]{"--tmp"};
    private File tmpDefaultDirectory;

    public JPTmpDirectory() {
        super(COMMAND_IDENTIFIERS, FileHandler.ExistenceHandling.Must, FileHandler.AutoMode.Off);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    if (JPTmpDirectory.this.getValue() == null) {
                        return;
                    }
                    if (((File)JPTmpDirectory.this.getValue()).exists()) {
                        FileUtils.deleteQuietly((File)((File)JPTmpDirectory.this.getValue()));
                    }
                    if (((File)JPTmpDirectory.this.getValue()).getAbsolutePath().equals(JPTmpDirectory.this.tmpDefaultDirectory.getAbsolutePath())) {
                        if (JPService.testMode()) {
                            JPTmpDirectory.this.deleteDirectoryIfEmpty(new File(SYSTEM_TMP_DIRECTORY + File.separatorChar + JPTmpDirectory.TEST_DIRECTORY + File.separatorChar + AbstractJPFile.convertIntoValidFileName(JPService.getApplicationName())));
                            JPTmpDirectory.this.deleteDirectoryIfEmpty(new File(SYSTEM_TMP_DIRECTORY + File.separatorChar + JPTmpDirectory.TEST_DIRECTORY));
                        } else {
                            JPTmpDirectory.this.deleteDirectoryIfEmpty(new File(SYSTEM_TMP_DIRECTORY + File.separatorChar + AbstractJPFile.convertIntoValidFileName(JPService.getApplicationName())));
                        }
                    }
                }
                catch (IllegalArgumentException ex) {
                    JPService.printError("Could not delete tmp directory!", ex);
                }
            }
        });
    }

    private void deleteDirectoryIfEmpty(File file) {
        if (!file.isDirectory()) {
            return;
        }
        for (File child : file.listFiles()) {
            this.deleteDirectoryIfEmpty(child);
        }
        if (file.listFiles().length == 0) {
            FileUtils.deleteQuietly((File)file);
        }
    }

    @Override
    protected File getPropertyDefaultValue() {
        File tmpFolder = JPService.testMode() ? new File(SYSTEM_TMP_DIRECTORY + File.separatorChar + TEST_DIRECTORY + File.separatorChar + JPTmpDirectory.convertIntoValidFileName(JPService.getApplicationName()) + File.separatorChar + JPTmpDirectory.convertIntoValidFileName(System.getProperty("user.name", "mrpink"))) : new File(SYSTEM_TMP_DIRECTORY + File.separatorChar + JPTmpDirectory.convertIntoValidFileName(JPService.getApplicationName()) + File.separatorChar + JPTmpDirectory.convertIntoValidFileName(System.getProperty("user.name", "mrpink")));
        try {
            FileUtils.forceMkdir((File)tmpFolder);
            this.tmpDefaultDirectory = tmpFolder;
            return tmpFolder;
        }
        catch (IOException ex) {
            JPService.printError("Could not create tmp folder :(", ex);
            this.tmpDefaultDirectory = tmpFolder;
            return new File("/tmp");
        }
    }

    @Override
    public void validate() throws JPValidationException {
        if (JPService.testMode()) {
            this.setAutoCreateMode(FileHandler.AutoMode.On);
            this.setExistenceHandling(FileHandler.ExistenceHandling.Must);
        }
        super.validate();
    }

    @Override
    public String getDescription() {
        return "Specifies the application temporary directory which is used for lockfiles and application caches.";
    }
}

