/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jps.preset;

import java.lang.reflect.Method;
import java.util.List;
import org.openbase.jps.core.AbstractJavaProperty;
import org.openbase.jps.core.JPService;
import org.openbase.jps.exception.JPBadArgumentException;
import org.openbase.jps.exception.JPNotAvailableException;
import org.openbase.jps.preset.AbstractJPClass;

public abstract class AbstractJPMethod<C>
extends AbstractJavaProperty<Method> {
    public static final String[] ARGUMENT_IDENTIFIERS = new String[]{"METHOD"};
    private final Class<? extends AbstractJPClass<C>> jpClass;

    public AbstractJPMethod(String[] commandIdentifier, Class<? extends AbstractJPClass<C>> jpClass) {
        super(commandIdentifier);
        this.jpClass = jpClass;
    }

    @Override
    protected String[] generateArgumentIdentifiers() {
        return ARGUMENT_IDENTIFIERS;
    }

    @Override
    protected Method parse(List<String> arguments) throws JPBadArgumentException {
        String oneArgumentResult = this.getOneArgumentResult();
        try {
            Class relatedClass = (Class)JPService.getProperty(this.jpClass).getValue();
            for (Method method : relatedClass.getMethods()) {
                if (!method.getName().equalsIgnoreCase(oneArgumentResult)) continue;
                return method;
            }
            throw new JPBadArgumentException("Class[" + relatedClass.getClass().getName() + "] does not provide Method[" + oneArgumentResult + "]!");
        }
        catch (SecurityException | JPBadArgumentException | JPNotAvailableException ex) {
            throw new JPBadArgumentException("Could not load given Method[" + oneArgumentResult + "]!", ex);
        }
    }
}

