/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.extension.openhab.binding;

import com.google.protobuf.Message;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InvalidStateException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.NotSupportedException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.extension.openhab.binding.interfaces.OpenHABRemote;
import org.openbase.jul.extension.rsb.com.RPCHelper;
import org.openbase.jul.extension.rsb.com.RSBFactoryImpl;
import org.openbase.jul.extension.rsb.com.RSBRemote;
import org.openbase.jul.extension.rsb.com.RSBRemoteService;
import org.openbase.jul.extension.rsb.iface.RSBListener;
import org.slf4j.Logger;
import rsb.Event;
import rsb.Handler;
import rsb.Scope;
import rsb.converter.Converter;
import rsb.converter.DefaultConverterRepository;
import rsb.converter.ProtocolBufferConverter;
import rst.domotic.binding.openhab.OpenhabCommandType;
import rst.domotic.binding.openhab.OpenhabStateType;

public abstract class AbstractOpenHABRemote
extends RSBRemoteService<OpenhabStateType.OpenhabState>
implements OpenHABRemote {
    public static final String ITEM_SUBSEGMENT_DELIMITER = "_";
    public static final String ITEM_SEGMENT_DELIMITER = "__";
    public static final String RPC_METHODE_SEND_COMMAND = "sendCommand";
    public static final String RPC_METHODE_POST_COMMAND = "postCommand";
    public static final String RPC_METHODE_POST_UPDATE = "postUpdate";
    public static final Scope SCOPE_OPENHAB = new Scope("/openhab");
    public static final Scope SCOPE_OPENHAB_UPDATE = SCOPE_OPENHAB.concat(new Scope("/update"));
    public static final Scope SCOPE_OPENHAB_COMMAND = SCOPE_OPENHAB.concat(new Scope("/command"));
    private String itemFilter;
    private RSBListener openhabCommandListener;
    private RSBListener openhabUpdateListener;
    private final boolean hardwareSimulationMode;

    public AbstractOpenHABRemote(boolean hardwareSimulationMode) {
        super(OpenhabStateType.OpenhabState.class);
        this.hardwareSimulationMode = hardwareSimulationMode;
    }

    @Override
    public void init(String itemFilter) throws InitializationException, InterruptedException {
        this.init(SCOPE_OPENHAB);
        this.itemFilter = itemFilter;
    }

    protected void postInit() throws InitializationException, InterruptedException {
        try {
            this.openhabCommandListener = RSBFactoryImpl.getInstance().createSynchronizedListener(SCOPE_OPENHAB_COMMAND);
            this.openhabUpdateListener = RSBFactoryImpl.getInstance().createSynchronizedListener(SCOPE_OPENHAB_UPDATE);
            this.openhabCommandListener.addHandler(event -> {
                try {
                    OpenhabCommandType.OpenhabCommand openhabCommand = (OpenhabCommandType.OpenhabCommand)event.getData();
                    if (!openhabCommand.hasItemBindingConfig() || !openhabCommand.getItemBindingConfig().startsWith(this.itemFilter)) {
                        return;
                    }
                    this.internalReceiveCommand(openhabCommand);
                }
                catch (ClassCastException ex) {
                    ExceptionPrinter.printHistory((Throwable)new NotSupportedException((Object)event.getData().getClass().getSimpleName(), (Object)this), (Logger)this.logger, (LogLevel)LogLevel.DEBUG);
                }
                catch (CouldNotPerformException ex) {
                    ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not handle openhab command!", (Throwable)ex), (Logger)this.logger);
                }
            }, true);
            this.openhabUpdateListener.addHandler(new Handler(){

                public void internalNotify(Event event) {
                    try {
                        AbstractOpenHABRemote.this.internalReceiveUpdate((OpenhabCommandType.OpenhabCommand)event.getData());
                    }
                    catch (ClassCastException ex) {
                        ExceptionPrinter.printHistory((Throwable)new NotSupportedException((Object)event.getData().getClass().getSimpleName(), (Object)this), (Logger)AbstractOpenHABRemote.this.logger, (LogLevel)LogLevel.DEBUG);
                    }
                    catch (CouldNotPerformException ex) {
                        ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not handle openhab update!", (Throwable)ex), (Logger)AbstractOpenHABRemote.this.logger);
                    }
                }
            }, true);
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    public void activate() throws CouldNotPerformException, InterruptedException {
        if (this.hardwareSimulationMode) {
            return;
        }
        super.activate();
        this.openhabCommandListener.activate();
        this.openhabUpdateListener.activate();
    }

    public void deactivate() throws CouldNotPerformException, InterruptedException {
        try {
            super.deactivate();
        }
        catch (InterruptedException ex) {
            ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Unable to deactivate openhab remote!", (Throwable)ex), (Logger)this.logger, (LogLevel)LogLevel.WARN);
            Thread.currentThread().interrupt();
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Unable to deactivate openhab remote!", (Throwable)ex), (Logger)this.logger, (LogLevel)LogLevel.WARN);
        }
        try {
            if (this.openhabUpdateListener != null) {
                this.openhabUpdateListener.deactivate();
            }
        }
        catch (InterruptedException ex) {
            ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Unable to deactivate openhab update listener!", (Throwable)ex), (Logger)this.logger, (LogLevel)LogLevel.WARN);
            Thread.currentThread().interrupt();
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Unable to deactivate openhab update listener!", (Throwable)ex), (Logger)this.logger, (LogLevel)LogLevel.WARN);
        }
        try {
            if (this.openhabCommandListener != null) {
                this.openhabCommandListener.deactivate();
            }
        }
        catch (InterruptedException ex) {
            ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Unable to deactivate openhab command listener!", (Throwable)ex), (Logger)this.logger, (LogLevel)LogLevel.WARN);
            Thread.currentThread().interrupt();
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Unable to deactivate openhab command listener!", (Throwable)ex), (Logger)this.logger, (LogLevel)LogLevel.WARN);
        }
    }

    @Override
    public Future<Void> postCommand(OpenhabCommandType.OpenhabCommand command) throws CouldNotPerformException {
        try {
            this.validateCommand(command);
            if (this.hardwareSimulationMode) {
                this.internalReceiveUpdate(command);
                return CompletableFuture.completedFuture(null);
            }
            return RPCHelper.callRemoteMethod((Object)command, (RSBRemote)this);
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not post Command[" + command + "]!", (Throwable)ex);
        }
    }

    @Override
    public Future<Void> sendCommand(OpenhabCommandType.OpenhabCommand command) throws CouldNotPerformException {
        try {
            this.validateCommand(command);
            if (this.hardwareSimulationMode) {
                this.internalReceiveUpdate(command);
                return CompletableFuture.completedFuture(null);
            }
            return RPCHelper.callRemoteMethod((Object)command, (RSBRemote)this);
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not send Command[" + command + "]!", (Throwable)ex);
        }
    }

    @Override
    public Future<Void> postUpdate(OpenhabCommandType.OpenhabCommand command) throws CouldNotPerformException {
        try {
            this.validateCommand(command);
            if (this.hardwareSimulationMode) {
                return CompletableFuture.completedFuture(null);
            }
            return RPCHelper.callRemoteMethod((Object)command, (RSBRemote)this);
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not post Update[" + command + "]!", (Throwable)ex);
        }
    }

    private void validateCommand(OpenhabCommandType.OpenhabCommand command) throws InvalidStateException {
        try {
            if (!command.hasItem() || command.getItem().isEmpty()) {
                throw new NotAvailableException("command item");
            }
            if (!command.hasType()) {
                throw new NotAvailableException("command type");
            }
        }
        catch (CouldNotPerformException ex) {
            throw new InvalidStateException("Command invalid!", (Throwable)ex);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[version=" + this.getClass().getPackage().getImplementationVersion() + "]";
    }

    static {
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)OpenhabCommandType.OpenhabCommand.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)OpenhabStateType.OpenhabState.getDefaultInstance()));
    }
}

