/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.extension.openhab.binding.transform;

import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.CouldNotTransformException;
import org.openbase.jul.exception.InvalidStateException;
import org.openbase.jul.exception.TypeNotSupportedException;
import rst.domotic.state.AlarmStateType;

public class AlarmStateTransformer {
    public static AlarmStateType.AlarmState transform(Double decimalType) throws CouldNotTransformException {
        AlarmStateType.AlarmState.Builder alarmState = AlarmStateType.AlarmState.newBuilder();
        try {
            if (decimalType.intValue() == 0) {
                alarmState.setValue(AlarmStateType.AlarmState.State.NO_ALARM);
            } else if (decimalType.intValue() == 1) {
                alarmState.setValue(AlarmStateType.AlarmState.State.ALARM);
            }
            return alarmState.build();
        }
        catch (Exception ex) {
            throw new CouldNotTransformException("Could not transform " + Double.class.getName() + "! " + Double.class.getSimpleName() + "[" + decimalType + "] is unknown!", (Throwable)ex);
        }
    }

    public static Double transform(AlarmStateType.AlarmState alarmState) throws CouldNotTransformException {
        try {
            switch (alarmState.getValue()) {
                case NO_ALARM: {
                    return 0.0;
                }
                case ALARM: {
                    return 1.0;
                }
                case UNKNOWN: {
                    throw new InvalidStateException("Unknown state is invalid!");
                }
            }
            throw new TypeNotSupportedException(AlarmStateType.AlarmState.State.class, Double.class);
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotTransformException("Could not transform " + AlarmStateType.AlarmState.State.class.getName() + "!", (Throwable)ex);
        }
    }
}

