/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.extension.openhab.binding.transform;

import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.CouldNotTransformException;
import org.openbase.jul.exception.TypeNotSupportedException;
import rst.domotic.state.HandleStateType;

public class OpenClosedTiltedStateTransformer {
    public static HandleStateType.HandleState transform(String stringType) throws CouldNotTransformException {
        switch (stringType) {
            case "CLOSED": {
                return HandleStateType.HandleState.newBuilder().setPosition(0).build();
            }
            case "OPEN": {
                return HandleStateType.HandleState.newBuilder().setPosition(90).build();
            }
            case "TILTED": {
                return HandleStateType.HandleState.newBuilder().setPosition(180).build();
            }
        }
        throw new CouldNotTransformException("Could not transform " + String.class.getName() + "! " + String.class.getSimpleName() + "[" + stringType + "] is unknown!");
    }

    public static String transform(HandleStateType.HandleState handleState) throws CouldNotTransformException {
        try {
            switch (handleState.getPosition()) {
                case 0: {
                    return "CLOSED";
                }
                case 90: {
                    return "OPEN";
                }
                case 180: {
                    return "TILTED";
                }
            }
            throw new TypeNotSupportedException((Object)handleState, String.class);
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotTransformException("Could not transform " + HandleStateType.HandleState.class.getName() + "!", (Throwable)ex);
        }
    }
}

