/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.extension.openhab.binding;

import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.extension.openhab.binding.interfaces.OpenHABBinding;
import org.openbase.jul.extension.openhab.binding.interfaces.OpenHABRemote;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOpenHABBinding
implements OpenHABBinding {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractOpenHABBinding.class);
    protected static OpenHABBinding instance;
    protected OpenHABRemote openHABRemote;

    public AbstractOpenHABBinding() throws InstantiationException {
        instance = this;
    }

    public static OpenHABBinding getInstance() throws NotAvailableException {
        if (instance == null) {
            throw new NotAvailableException(OpenHABBinding.class);
        }
        return instance;
    }

    public void init(String itemFilter, OpenHABRemote openHABRemote) throws InitializationException, InterruptedException {
        try {
            this.openHABRemote = openHABRemote;
            this.openHABRemote.init(itemFilter);
            this.openHABRemote.activate();
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    public void shutdown() {
        if (this.openHABRemote != null) {
            this.openHABRemote.shutdown();
        }
        instance = null;
    }

    @Override
    public OpenHABRemote getOpenHABRemote() throws NotAvailableException {
        return this.openHABRemote;
    }
}

