/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.extension.openhab.binding.transform;

import org.openbase.jul.exception.CouldNotTransformException;
import rst.domotic.binding.openhab.HSBType;
import rst.domotic.state.ColorStateType;
import rst.vision.ColorType;
import rst.vision.HSBColorType;

public class ColorStateTransformer {
    public static ColorStateType.ColorState transform(HSBType.HSB hsbColor) throws CouldNotTransformException {
        try {
            HSBColorType.HSBColor hsbColorBuilder = HSBColorType.HSBColor.newBuilder().setHue(hsbColor.getHue()).setSaturation(hsbColor.getSaturation()).setBrightness(hsbColor.getBrightness()).build();
            ColorType.Color color = ColorType.Color.newBuilder().setHsbColor(hsbColorBuilder).setType(ColorType.Color.Type.HSB).build();
            return ColorStateType.ColorState.newBuilder().setColor(color).build();
        }
        catch (Exception ex) {
            throw new CouldNotTransformException("Could not transform " + HSBType.HSB.class.getName() + " to " + ColorStateType.ColorState.class.getName() + "!", (Throwable)ex);
        }
    }

    public static HSBType.HSB transform(ColorStateType.ColorState colorState) throws CouldNotTransformException {
        try {
            HSBColorType.HSBColor color = colorState.getColor().getHsbColor();
            return HSBType.HSB.newBuilder().setHue(color.getHue()).setSaturation(color.getSaturation()).setBrightness(color.getBrightness()).build();
        }
        catch (Exception ex) {
            throw new CouldNotTransformException("Could not transform " + HSBColorType.HSBColor.class.getName() + " to " + HSBType.class.getName() + "!", (Throwable)ex);
        }
    }
}

