/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.extension.openhab.binding.transform;

import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.CouldNotTransformException;
import org.openbase.jul.exception.InvalidStateException;
import org.openbase.jul.exception.TypeNotSupportedException;
import rst.domotic.state.MotionStateType;

public class MotionStateTransformer {
    public static MotionStateType.MotionState transform(Double decimalType) throws CouldNotTransformException {
        MotionStateType.MotionState.Builder motionState = MotionStateType.MotionState.newBuilder();
        try {
            if (decimalType.intValue() == 0) {
                motionState.setValue(MotionStateType.MotionState.State.NO_MOTION);
            } else {
                motionState.setValue(MotionStateType.MotionState.State.MOTION);
            }
            return motionState.build();
        }
        catch (Exception ex) {
            throw new CouldNotTransformException("Could not transform " + Double.class.getName() + "! " + Double.class.getSimpleName() + "[" + decimalType + "] is unknown!", (Throwable)ex);
        }
    }

    public static Double transform(MotionStateType.MotionState motionState) throws CouldNotTransformException {
        try {
            switch (motionState.getValue()) {
                case NO_MOTION: {
                    return 0.0;
                }
                case MOTION: {
                    return 1.0;
                }
                case UNKNOWN: {
                    throw new InvalidStateException("Unknown state is invalid!");
                }
            }
            throw new TypeNotSupportedException(MotionStateType.MotionState.State.class, Double.class);
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotTransformException("Could not transform " + MotionStateType.MotionState.State.class.getName() + "!", (Throwable)ex);
        }
    }
}

