/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.extension.openhab.binding.transform;

import com.google.protobuf.MessageOrBuilder;
import java.util.concurrent.TimeUnit;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.CouldNotTransformException;
import org.openbase.jul.exception.NotSupportedException;
import org.openbase.jul.extension.openhab.binding.transform.AlarmStateTransformer;
import org.openbase.jul.extension.openhab.binding.transform.BatteryStateTransformer;
import org.openbase.jul.extension.openhab.binding.transform.BlindStateTransformer;
import org.openbase.jul.extension.openhab.binding.transform.BrightnessStateTransformer;
import org.openbase.jul.extension.openhab.binding.transform.ButtonStateTransformer;
import org.openbase.jul.extension.openhab.binding.transform.ColorStateTransformer;
import org.openbase.jul.extension.openhab.binding.transform.HandleStateTransformer;
import org.openbase.jul.extension.openhab.binding.transform.IlluminanceStateTransformer;
import org.openbase.jul.extension.openhab.binding.transform.MotionStateTransformer;
import org.openbase.jul.extension.openhab.binding.transform.OpenClosedStateTransformer;
import org.openbase.jul.extension.openhab.binding.transform.PowerConsumptionStateTransformer;
import org.openbase.jul.extension.openhab.binding.transform.PowerStateTransformer;
import org.openbase.jul.extension.openhab.binding.transform.SmokeStateTransformer;
import org.openbase.jul.extension.openhab.binding.transform.StopMoveStateTransformer;
import org.openbase.jul.extension.openhab.binding.transform.TamperStateTransformer;
import org.openbase.jul.extension.openhab.binding.transform.TemperatureStateTransformer;
import org.openbase.jul.extension.openhab.binding.transform.UpDownStateTransformer;
import org.openbase.jul.extension.rst.processing.TimestampProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.binding.openhab.OpenhabCommandType;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.ContactStateType;

public final class OpenhabCommandTransformer {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenhabCommandTransformer.class);

    public static Object getServiceData(OpenhabCommandType.OpenhabCommand command, ServiceTemplateType.ServiceTemplate.ServiceType serviceType) throws CouldNotPerformException {
        ContactStateType.ContactState msg;
        block0 : switch (command.getType()) {
            case DECIMAL: {
                switch (serviceType) {
                    case POWER_CONSUMPTION_STATE_SERVICE: {
                        msg = PowerConsumptionStateTransformer.transform(command.getDecimal());
                        break block0;
                    }
                    case MOTION_STATE_SERVICE: {
                        msg = MotionStateTransformer.transform(command.getDecimal());
                        break block0;
                    }
                    case TAMPER_STATE_SERVICE: {
                        msg = TamperStateTransformer.transform(command.getDecimal());
                        break block0;
                    }
                    case BATTERY_STATE_SERVICE: {
                        msg = BatteryStateTransformer.transform(command.getDecimal());
                        break block0;
                    }
                    case TEMPERATURE_ALARM_STATE_SERVICE: 
                    case SMOKE_ALARM_STATE_SERVICE: {
                        msg = AlarmStateTransformer.transform(command.getDecimal());
                        break block0;
                    }
                    case SMOKE_STATE_SERVICE: {
                        msg = SmokeStateTransformer.transform(command.getDecimal());
                        break block0;
                    }
                    case TEMPERATURE_STATE_SERVICE: 
                    case TARGET_TEMPERATURE_STATE_SERVICE: {
                        msg = TemperatureStateTransformer.transform(command.getDecimal());
                        break block0;
                    }
                    case BRIGHTNESS_STATE_SERVICE: {
                        msg = BrightnessStateTransformer.transform(command.getDecimal());
                        break block0;
                    }
                    case ILLUMINANCE_STATE_SERVICE: {
                        msg = IlluminanceStateTransformer.transform(command.getDecimal());
                        break block0;
                    }
                }
                return command.getDecimal();
            }
            case HSB: {
                switch (serviceType) {
                    case COLOR_STATE_SERVICE: {
                        msg = ColorStateTransformer.transform(command.getHsb());
                        break block0;
                    }
                }
                throw new NotSupportedException((Object)serviceType, OpenhabCommandTransformer.class);
            }
            case INCREASEDECREASE: {
                throw new NotSupportedException((Object)command.getType(), OpenhabCommandTransformer.class);
            }
            case ONOFF: {
                switch (serviceType) {
                    case BUTTON_STATE_SERVICE: {
                        msg = ButtonStateTransformer.transform(command.getOnOff().getState());
                        break block0;
                    }
                    case POWER_STATE_SERVICE: {
                        msg = PowerStateTransformer.transform(command.getOnOff().getState());
                        break block0;
                    }
                    case BRIGHTNESS_STATE_SERVICE: 
                    case COLOR_STATE_SERVICE: {
                        return null;
                    }
                }
                throw new NotSupportedException((Object)serviceType, OpenhabCommandTransformer.class);
            }
            case OPENCLOSED: {
                msg = OpenClosedStateTransformer.transform(command.getOpenClosed().getState());
                break;
            }
            case PERCENT: {
                switch (serviceType) {
                    case BRIGHTNESS_STATE_SERVICE: {
                        msg = BrightnessStateTransformer.transform(command.getPercent().getValue());
                        break block0;
                    }
                    case BLIND_STATE_SERVICE: {
                        msg = BlindStateTransformer.transform(command.getPercent().getValue());
                        break block0;
                    }
                }
                return command.getPercent().getValue();
            }
            case STOPMOVE: {
                msg = StopMoveStateTransformer.transform(command.getStopMove().getState());
                break;
            }
            case STRING: {
                switch (serviceType) {
                    case HANDLE_STATE_SERVICE: {
                        msg = HandleStateTransformer.transform(command.getText());
                        break block0;
                    }
                }
                return command.getText();
            }
            case UPDOWN: {
                msg = UpDownStateTransformer.transform(command.getUpDown().getState());
                break;
            }
            default: {
                throw new CouldNotTransformException("No corresponding data found for " + command + ".");
            }
        }
        return TimestampProcessor.updateTimestamp((long)command.getTimestamp().getTime(), (MessageOrBuilder)msg, (TimeUnit)TimeUnit.MICROSECONDS);
    }

    public static Object getCommandData(OpenhabCommandType.OpenhabCommand command) throws CouldNotPerformException {
        switch (command.getType()) {
            case DECIMAL: {
                return command.getDecimal();
            }
            case HSB: {
                return command.getHsb();
            }
            case INCREASEDECREASE: {
                return command.getIncreaseDecrease();
            }
            case ONOFF: {
                return command.getOnOff();
            }
            case OPENCLOSED: {
                return command.getOpenClosed();
            }
            case PERCENT: {
                return command.getPercent();
            }
            case STOPMOVE: {
                return command.getStopMove();
            }
            case STRING: {
                return command.getText();
            }
            case UPDOWN: {
                return command.getUpDown();
            }
        }
        throw new CouldNotTransformException("No corresponding data found for " + command + ".");
    }
}

