/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.extension.openhab.binding.transform;

import org.openbase.jul.exception.CouldNotTransformException;
import rst.domotic.state.SmokeStateType;

public class SmokeStateTransformer {
    public static SmokeStateType.SmokeState transform(Double decimalType) throws CouldNotTransformException {
        SmokeStateType.SmokeState.Builder smokeState = SmokeStateType.SmokeState.newBuilder();
        try {
            smokeState.setSmokeLevel(decimalType.doubleValue());
            if (decimalType == 0.0) {
                smokeState.setValue(SmokeStateType.SmokeState.State.NO_SMOKE);
            } else if (decimalType < 20.0) {
                smokeState.setValue(SmokeStateType.SmokeState.State.SOME_SMOKE);
            } else {
                smokeState.setValue(SmokeStateType.SmokeState.State.SMOKE);
            }
            return smokeState.build();
        }
        catch (Exception ex) {
            throw new CouldNotTransformException("Could not transform " + Double.class.getName() + "! " + Double.class.getSimpleName() + "[" + decimalType + "] is unknown!", (Throwable)ex);
        }
    }

    public static Double transform(SmokeStateType.SmokeState smokeState) {
        return smokeState.getSmokeLevel();
    }
}

