/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.extension.rst.storage.registry.consistency;

import com.google.protobuf.GeneratedMessage;
import java.util.ArrayList;
import java.util.List;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.extension.protobuf.IdentifiableMessage;
import org.openbase.jul.processing.StringProcessor;
import org.openbase.jul.storage.registry.AbstractProtoBufRegistryConsistencyHandler;
import org.openbase.jul.storage.registry.EntryModification;
import org.openbase.jul.storage.registry.ProtoBufRegistry;
import rst.domotic.unit.UnitConfigType;
import rst.spatial.PlacementConfigType;

public abstract class AbstractTransformationFrameConsistencyHandler<KEY extends Comparable<KEY>, M extends GeneratedMessage, MB extends GeneratedMessage.Builder<MB>>
extends AbstractProtoBufRegistryConsistencyHandler<KEY, M, MB> {
    private final List<String> labelCollisionList = new ArrayList<String>();
    private final ProtoBufRegistry<String, UnitConfigType.UnitConfig, UnitConfigType.UnitConfig.Builder> locationRegistry;

    public AbstractTransformationFrameConsistencyHandler(ProtoBufRegistry<String, UnitConfigType.UnitConfig, UnitConfigType.UnitConfig.Builder> locationRegistry) {
        this.locationRegistry = locationRegistry;
    }

    protected PlacementConfigType.PlacementConfig verifyAndUpdatePlacement(String label, PlacementConfigType.PlacementConfig placementConfig) throws CouldNotPerformException, EntryModification {
        try {
            if (label == null || label.isEmpty()) {
                throw new NotAvailableException("label");
            }
            if (placementConfig == null) {
                throw new NotAvailableException("placementconfig");
            }
            String frameId = this.generateFrameId(label, placementConfig);
            if (placementConfig.getTransformationFrameId().equals(frameId)) {
                return null;
            }
            return placementConfig.toBuilder().setTransformationFrameId(frameId).build();
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not verify and update placement!", (Throwable)ex);
        }
    }

    protected String generateFrameId(String label, PlacementConfigType.PlacementConfig placementConfig) throws CouldNotPerformException {
        try {
            String frameId = StringProcessor.transformToIdString((String)label);
            if (this.labelCollisionList.contains(frameId.toLowerCase())) {
                return ((UnitConfigType.UnitConfig)((IdentifiableMessage)this.locationRegistry.get((Object)placementConfig.getLocationId())).getMessage()).getPlacementConfig().getTransformationFrameId() + "_" + frameId;
            }
            this.labelCollisionList.add(frameId.toLowerCase());
            return frameId;
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not generate frame id!", (Throwable)ex);
        }
    }

    public void reset() {
        this.labelCollisionList.clear();
    }
}

