/*
 * Decompiled with CFR 0.152.
 */
package org.openbites.concurrent.locks.gcs;

public class GcsLockConfig {
    private String gcsBucketName;
    private String gcsLockFilename;
    private Integer refreshIntervalInSeconds;
    private Integer lifeExtensionInSeconds;

    private GcsLockConfig() {
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getGcsBucketName() {
        return this.gcsBucketName;
    }

    public String getGcsLockFilename() {
        return this.gcsLockFilename;
    }

    public Integer getRefreshIntervalInSeconds() {
        return this.refreshIntervalInSeconds;
    }

    public Integer getLifeExtensionInSeconds() {
        return this.lifeExtensionInSeconds;
    }

    public String toString() {
        return String.format("[gcsBucketName=%s, gcsLockFilename=%s]", this.gcsBucketName, this.gcsLockFilename);
    }

    public static final class Builder {
        private String gcsBucketName;
        private String gcsLockFilename;
        private Integer refreshIntervalInSeconds = 10;
        private Integer lifeExtensionInSeconds = 60;

        private Builder() {
        }

        public Builder setGcsBucketName(String gcsBucketName) {
            if (gcsBucketName == null) {
                throw new NullPointerException("Null gcsBucketName");
            }
            this.gcsBucketName = gcsBucketName;
            return this;
        }

        public Builder setGcsLockFilename(String gcsLockFilename) {
            if (gcsLockFilename == null) {
                throw new NullPointerException("Null gcsLockFilename");
            }
            this.gcsLockFilename = gcsLockFilename;
            return this;
        }

        public Builder setRefreshIntervalInSeconds(Integer refreshIntervalInSeconds) {
            if (refreshIntervalInSeconds == null) {
                throw new NullPointerException("Null refreshIntervalInSeconds");
            }
            this.refreshIntervalInSeconds = refreshIntervalInSeconds;
            return this;
        }

        public Builder setLifeExtensionInSeconds(Integer iifeExtensionInSeconds) {
            if (iifeExtensionInSeconds == null) {
                throw new NullPointerException("Null iifeExtensionInSeconds");
            }
            this.lifeExtensionInSeconds = iifeExtensionInSeconds;
            return this;
        }

        public GcsLockConfig build() {
            if (this.gcsBucketName == null || this.gcsLockFilename == null) {
                StringBuilder missing = new StringBuilder();
                if (this.gcsBucketName == null) {
                    missing.append(" gcsBucketName");
                }
                if (this.gcsLockFilename == null) {
                    missing.append(" gcsLockFilename");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            GcsLockConfig configuration = new GcsLockConfig();
            configuration.gcsBucketName = this.gcsBucketName;
            configuration.gcsLockFilename = this.gcsLockFilename;
            configuration.refreshIntervalInSeconds = this.refreshIntervalInSeconds;
            configuration.lifeExtensionInSeconds = this.lifeExtensionInSeconds;
            return configuration;
        }
    }
}

