/*
 * Decompiled with CFR 0.152.
 */
package org.openbites.concurrent.locks.gcs;

import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.StorageOptions;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import org.openbites.concurrent.locks.DistributedLock;
import org.openbites.concurrent.locks.gcs.GcsLockConfig;
import org.openbites.concurrent.locks.gcs.GcsLockListener;

public class GcsLock
implements DistributedLock,
Serializable {
    private static final long serialVersionUID = 5184201915922962120L;
    private static final String LOCK_FILE_CONTENT = "_lock";
    private static final String MIME_TYPE_TEXT_PLAIN = "text/plain";
    private static final String CREATING_HOST = "CREATING_HOST";
    private static final String TTL_EXTENSION_SECONDS = "TTL_EXTENSION_SECONDS";
    private static final String REFRESH_SECONDS = "REFRESH_SECONDS";
    private static final String HOST_NAME = GcsLock.getHostName();
    static final String LOCK_TTL_EPOCH_MS = "LOCK_TTL_EPOCH_MS";
    static final int GCS_PRECONDITION_FAILED = 412;
    private final GcsLockConfig lockConfig;
    private final long intervalNanos;
    private final Storage storage;
    private final Set<GcsLockListener> lockListeners = new HashSet<GcsLockListener>();
    private final ReentrantLock lock = new ReentrantLock();
    private final KeepLockAlive keepLockAlive = new KeepLockAlive();
    private final CleanupDeadLock cleanupDeadLock = new CleanupDeadLock();
    private volatile transient Optional<Blob> acquired = Optional.empty();
    private volatile transient Thread exclusiveOwnerThread;
    private transient Collection<Thread> waitingThreads = new ConcurrentLinkedQueue<Thread>();

    public GcsLock(GcsLockConfig lockConfig) {
        if (Objects.isNull(lockConfig)) {
            throw new NullPointerException("Null GcsLockConfig");
        }
        this.lockConfig = lockConfig;
        this.storage = (Storage)StorageOptions.getDefaultInstance().getService();
        this.intervalNanos = (long)((double)lockConfig.getRefreshIntervalInSeconds().intValue() * 1.0E9);
    }

    @Override
    public boolean tryLock() {
        try {
            Map<String, String> metadata = this.computeMetaData();
            BlobId blobId = BlobId.of((String)this.lockConfig.getGcsBucketName(), (String)this.lockConfig.getGcsLockFilename());
            BlobInfo blobInfo = BlobInfo.newBuilder((BlobId)blobId).setMetadata(metadata).setContentType(MIME_TYPE_TEXT_PLAIN).build();
            Storage.BlobTargetOption blobOption = Storage.BlobTargetOption.doesNotExist();
            Blob blob = this.storage.create(blobInfo, LOCK_FILE_CONTENT.getBytes(), new Storage.BlobTargetOption[]{blobOption});
            this.acquired = Optional.of(blob);
            this.exclusiveOwnerThread = Thread.currentThread();
            this.keepLockAlive.start();
            return true;
        }
        catch (Exception exception) {
            if (exception instanceof StorageException && ((StorageException)exception).getCode() == 412) {
                this.cleanupDeadLock.start();
                return false;
            }
            this.notifyAcquireLockListeners(exception);
            return false;
        }
    }

    @Override
    public boolean tryLock(long time, TimeUnit timeUnit) throws InterruptedException {
        block4: {
            if (time <= 0L) {
                return false;
            }
            long deadline = TimeUnit.MILLISECONDS.convert(time, timeUnit) + System.currentTimeMillis();
            try {
                while (System.currentTimeMillis() <= deadline && !this.tryLock()) {
                    this.waitingThreads.add(Thread.currentThread());
                    LockSupport.parkUntil(deadline);
                    this.waitingThreads.remove(Thread.currentThread());
                    if (!Thread.currentThread().isInterrupted()) continue;
                    throw new InterruptedException();
                }
            }
            catch (Exception exception) {
                this.notifyAcquireLockListeners(exception);
                if (!(exception instanceof InterruptedException)) break block4;
                Thread.interrupted();
                throw (InterruptedException)exception;
            }
        }
        return this.isLocked() && this.isHeldByCurrentThread();
    }

    @Override
    public void lock() {
        try {
            while (!this.tryLock()) {
                this.waitingThreads.add(Thread.currentThread());
                LockSupport.park();
                this.waitingThreads.remove(Thread.currentThread());
            }
        }
        catch (Exception exception) {
            this.notifyAcquireLockListeners(exception);
        }
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        block3: {
            try {
                while (!this.tryLock()) {
                    this.waitingThreads.add(Thread.currentThread());
                    LockSupport.park();
                    this.waitingThreads.remove(Thread.currentThread());
                    if (!Thread.currentThread().isInterrupted()) continue;
                    throw new InterruptedException();
                }
            }
            catch (Exception exception) {
                this.notifyAcquireLockListeners(exception);
                if (!(exception instanceof InterruptedException)) break block3;
                Thread.interrupted();
                throw (InterruptedException)exception;
            }
        }
    }

    @Override
    public void unlock() {
        this.lock.lock();
        try {
            if (this.isHeldByCurrentThread()) {
                this.acquired.ifPresent(blob -> {
                    this.acquired = Optional.empty();
                    this.exclusiveOwnerThread = null;
                    this.deleteLock((Blob)blob);
                });
            }
        }
        catch (Exception exception) {
            this.notifyReleaseLockListeners(exception);
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isLocked() {
        return this.acquired.isPresent();
    }

    public boolean isHeldByCurrentThread() {
        return this.exclusiveOwnerThread == Thread.currentThread();
    }

    public void addLockListener(GcsLockListener listener) {
        this.lockListeners.add(listener);
    }

    public void removeLockListener(GcsLockListener listener) {
        this.lockListeners.remove(listener);
    }

    private Map<String, String> computeMetaData() {
        long keepAliveToUnitMillis = System.currentTimeMillis() + (long)this.lockConfig.getLifeExtensionInSeconds().intValue() * 1000L;
        HashMap<String, String> metaData = new HashMap<String, String>();
        metaData.put(LOCK_TTL_EPOCH_MS, String.valueOf(keepAliveToUnitMillis));
        metaData.put(CREATING_HOST, HOST_NAME);
        metaData.put(TTL_EXTENSION_SECONDS, String.valueOf(this.lockConfig.getLifeExtensionInSeconds()));
        metaData.put(REFRESH_SECONDS, String.valueOf(this.lockConfig.getRefreshIntervalInSeconds()));
        return metaData;
    }

    private void notifyAcquireLockListeners(Exception exception) {
        this.lockListeners.forEach(listener -> {
            try {
                listener.acquireLockException(exception);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        });
    }

    private void notifyReleaseLockListeners(Exception exception) {
        this.lockListeners.forEach(listener -> {
            try {
                listener.releaseLockException(exception);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        });
    }

    private void notifyKeepLockAliveListeners(Exception exception) {
        this.lockListeners.forEach(listener -> {
            try {
                listener.keepLockAliveException(exception);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        });
    }

    private void notifyCleanupDeadLockListeners(Exception exception) {
        this.lockListeners.forEach(listener -> {
            try {
                listener.cleanupDeadLockException(exception);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        });
    }

    private void deleteLock(Blob blob) {
        this.storage.delete(blob.getBlobId(), new Storage.BlobSourceOption[]{Storage.BlobSourceOption.generationMatch((long)blob.getGeneration()), Storage.BlobSourceOption.metagenerationMatch((long)blob.getMetageneration())});
    }

    private static String getHostName() {
        String hostName = "NONE";
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return hostName;
    }

    private class CleanupDeadLock
    extends SingleIntervalExecution {
        private CleanupDeadLock() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Blob blob;
            Map metaData;
            long ttl;
            do {
                LockSupport.parkNanos(GcsLock.this.intervalNanos);
                blob = GcsLock.this.storage.get(GcsLock.this.lockConfig.getGcsBucketName(), GcsLock.this.lockConfig.getGcsLockFilename(), new Storage.BlobGetOption[0]);
                if (!Objects.isNull(blob)) continue;
                this.finish();
                return;
            } while ((ttl = Optional.ofNullable(metaData = blob.getMetadata()).map(metadata -> (String)metaData.get(GcsLock.LOCK_TTL_EPOCH_MS)).map(Long::valueOf).orElse(Long.MAX_VALUE).longValue()) > System.currentTimeMillis());
            try {
                GcsLock.this.deleteLock(blob);
            }
            catch (Exception exception) {
                GcsLock.this.notifyCleanupDeadLockListeners(exception);
            }
            finally {
                this.finish();
                return;
            }
        }

        @Override
        void finish() {
            super.finish();
            Optional thread = GcsLock.this.waitingThreads.stream().findAny();
            thread.ifPresent(LockSupport::unpark);
            if (GcsLock.this.waitingThreads.size() > 0) {
                this.start();
            }
        }
    }

    private class KeepLockAlive
    extends SingleIntervalExecution {
        private KeepLockAlive() {
        }

        @Override
        public void run() {
            while (true) {
                GcsLock.this.lock.lock();
                try {
                    Blob updatedBlob;
                    if (!GcsLock.this.acquired.isPresent() || Objects.isNull(updatedBlob = GcsLock.this.storage.get(GcsLock.this.lockConfig.getGcsBucketName(), GcsLock.this.lockConfig.getGcsLockFilename(), new Storage.BlobGetOption[]{Storage.BlobGetOption.generationMatch((long)((Blob)GcsLock.this.acquired.get()).getGeneration()), Storage.BlobGetOption.metagenerationMatch((long)((Blob)GcsLock.this.acquired.get()).getMetageneration())}))) {
                        this.finish();
                        return;
                    }
                    updatedBlob = updatedBlob.toBuilder().setMetadata(GcsLock.this.computeMetaData()).build();
                    updatedBlob = GcsLock.this.storage.update((BlobInfo)updatedBlob, new Storage.BlobTargetOption[]{Storage.BlobTargetOption.generationMatch(), Storage.BlobTargetOption.metagenerationMatch()});
                    GcsLock.this.acquired = Optional.of(updatedBlob);
                }
                catch (Exception exception) {
                    GcsLock.this.notifyKeepLockAliveListeners(exception);
                    this.finish();
                    return;
                }
                finally {
                    GcsLock.this.lock.unlock();
                }
                LockSupport.parkNanos(GcsLock.this.intervalNanos);
            }
        }
    }

    private abstract class SingleIntervalExecution
    implements Runnable {
        Thread executingThread;

        private SingleIntervalExecution() {
        }

        void start() {
            GcsLock.this.lock.lock();
            try {
                if (this.executingThread == null) {
                    Thread thread = new Thread(this);
                    thread.setName(String.format("%s-%s-%s", this.getClass().getSimpleName(), GcsLock.this.lockConfig.getGcsBucketName(), GcsLock.this.lockConfig.getGcsLockFilename()));
                    thread.setDaemon(true);
                    thread.start();
                    this.executingThread = thread;
                }
            }
            finally {
                GcsLock.this.lock.unlock();
            }
        }

        void finish() {
            this.executingThread = null;
        }
    }
}

