/*
 * Decompiled with CFR 0.152.
 */
package org.openbites.concurrent.locks.gcs;

public class GcsLockConfig {
    private String gcsBucketName;
    private String gcsLockFilename;
    private Integer refreshIntervalInSeconds;
    private Integer iifeExtensionInSeconds;

    private GcsLockConfig() {
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getGcsBucketName() {
        return this.gcsBucketName;
    }

    public String getGcsLockFilename() {
        return this.gcsLockFilename;
    }

    public Integer getRefreshIntervalInSeconds() {
        return this.refreshIntervalInSeconds;
    }

    public Integer getLifeExtensionInSeconds() {
        return this.iifeExtensionInSeconds;
    }

    public String toString() {
        return String.format("[gcsBucketName=%s, gcsLockFilename=%s]", this.gcsBucketName, this.gcsLockFilename);
    }

    static final class Builder {
        private String gcsBucketName;
        private String gcsLockFilename;
        private Integer refreshIntervalInSeconds;
        private Integer iifeExtensionInSeconds;

        private Builder() {
        }

        public Builder setGcsBucketName(String gcsBucketName) {
            if (gcsBucketName == null) {
                throw new NullPointerException("Null gcsBucketName");
            }
            this.gcsBucketName = gcsBucketName;
            return this;
        }

        public Builder setGcsLockFilename(String gcsLockFilename) {
            if (gcsLockFilename == null) {
                throw new NullPointerException("Null gcsLockFilename");
            }
            this.gcsLockFilename = gcsLockFilename;
            return this;
        }

        public Builder setRefreshIntervalInSeconds(Integer refreshIntervalInSeconds) {
            if (refreshIntervalInSeconds == null) {
                throw new NullPointerException("Null refreshIntervalInSeconds");
            }
            this.refreshIntervalInSeconds = refreshIntervalInSeconds;
            return this;
        }

        public Builder setLifeExtensionInSeconds(Integer iifeExtensionInSeconds) {
            if (iifeExtensionInSeconds == null) {
                throw new NullPointerException("Null iifeExtensionInSeconds");
            }
            this.iifeExtensionInSeconds = iifeExtensionInSeconds;
            return this;
        }

        public GcsLockConfig build() {
            if (this.gcsBucketName == null || this.gcsLockFilename == null || this.refreshIntervalInSeconds == null || this.iifeExtensionInSeconds == null) {
                StringBuilder missing = new StringBuilder();
                if (this.gcsBucketName == null) {
                    missing.append(" gcsBucketName");
                }
                if (this.gcsLockFilename == null) {
                    missing.append(" gcsLockFilename");
                }
                if (this.refreshIntervalInSeconds == null) {
                    missing.append(" refreshIntervalInSeconds");
                }
                if (this.iifeExtensionInSeconds == null) {
                    missing.append(" iifeExtensionInSeconds");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            GcsLockConfig configuration = new GcsLockConfig();
            configuration.gcsBucketName = this.gcsBucketName;
            configuration.gcsLockFilename = this.gcsLockFilename;
            configuration.refreshIntervalInSeconds = this.refreshIntervalInSeconds;
            configuration.iifeExtensionInSeconds = this.iifeExtensionInSeconds;
            return configuration;
        }
    }
}

