/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.util.VariableSubstitutor;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class XInfoPanel
extends IzPanel {
    private static final long serialVersionUID = 3257009856274970416L;
    private JTextArea textArea;
    private String info;

    public XInfoPanel(InstallerFrame installerFrame, InstallData installData) {
        super(installerFrame, installData);
        Serializable serializable;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        JLabel jLabel = LabelFactory.create(installerFrame.langpack.getString("InfoPanel.info"), installerFrame.icons.getImageIcon("edit"), 11);
        installerFrame.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 1.0, 0.0);
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 16;
        gridBagLayout.addLayoutComponent(jLabel, gridBagConstraints);
        this.add(jLabel);
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        String string = installData.getVariable("XInfoPanel.font");
        if (string != null && string.length() > 0) {
            serializable = Font.decode(string);
            this.textArea.setFont((Font)serializable);
        }
        serializable = new JScrollPane(this.textArea);
        installerFrame.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 1.0, 0.9);
        gridBagConstraints.anchor = 10;
        gridBagLayout.addLayoutComponent((Component)serializable, gridBagConstraints);
        this.add((Component)serializable);
    }

    private void loadInfo() {
        try {
            this.info = ResourceManager.getInstance().getTextResource("XInfoPanel.info");
        }
        catch (Exception exception) {
            this.info = "Error : could not load the info text !";
        }
    }

    private void parseText() {
        try {
            VariableSubstitutor variableSubstitutor = new VariableSubstitutor(this.idata.getVariables());
            this.info = variableSubstitutor.substitute(this.info, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void panelActivate() {
        this.loadInfo();
        this.parseText();
        this.textArea.setText(this.info);
        this.textArea.setCaretPosition(0);
    }

    public boolean isValidated() {
        return true;
    }
}

