/*
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */
package org.openbp.cockpit.plugins.finder.treemodel;

import java.util.Comparator;

/**
 * Strategy for the generic model.
 *
 * @author Baumgartner Michael
 */
public interface Strategy
{
	/**
	 * Create a datamapper for a data object.
	 * @param leafData The data object to map
	 * @return data mapper
	 */
	public DataMapper createDataMapper(Object leafData);

	/**
	 * Get the comparator that is used in the tree.
	 * @return comparator or null if the tree should
	 * not be sorted
	 */
	public Comparator getTreeComparator();
}
