/*
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */
package org.openbp.cockpit.plugins.toolbox;

import java.awt.event.KeyEvent;

import org.openbp.cockpit.modeler.util.ProcessElementFactory;
import org.openbp.core.model.item.process.NodeSocket;
import org.openbp.core.model.item.process.NodeSocketImpl;
import org.openbp.core.model.item.process.ProcessItemImpl;
import org.openbp.core.model.item.process.TextElementImpl;

/**
 * This is a Standard ToolBox with all standard entrys.
 *
 * @author Jens Ferchland
 */
public class StandardToolBoxPlugin extends ToolBoxPlugin
{
	/**
	 * @see org.openbp.cockpit.plugins.toolbox.ToolBoxPlugin#addStandardToolBoxItems()
	 */
	protected void addStandardToolBoxItems()
	{
		// Add initial node
		addToolBoxItem(ProcessElementFactory.getInstance().createStandardInitialNode(), "toolboxitem.initial.tooltip");

		// Add final node
		addToolBoxItem(ProcessElementFactory.getInstance().createStandardFinalNode(), "toolboxitem.final.tooltip");

		// Add merge node
		addToolBoxItem(ProcessElementFactory.getInstance().createStandardMergeNode(), "toolboxitem.merge.tooltip");

		// Add decision node
		addToolBoxItem(ProcessElementFactory.getInstance().createStandardDecisionNode(), "toolboxitem.decision.tooltip");

		// Add wait state node
		addToolBoxItem(ProcessElementFactory.getInstance().createStandardWaitStateNode(), "toolboxitem.waitstate.tooltip");

		// Add workflow node
		addToolBoxItem(ProcessElementFactory.getInstance().createStandardWorkflowNode(), "toolboxitem.workflow.tooltip");

		// Add workflow final node
		addToolBoxItem(ProcessElementFactory.getInstance().createStandardWorkflowEndNode(), "toolboxitem.workflowend.tooltip");

		// Add fork node
		addToolBoxItem(ProcessElementFactory.getInstance().createStandardForkNode(), "toolboxitem.fork.tooltip");

		// Add join node
		addToolBoxItem(ProcessElementFactory.getInstance().createStandardJoinNode(), "toolboxitem.join.tooltip");

		// Add placeholder template
		addToolBoxItem(ProcessElementFactory.getInstance().createStandardPlaceholderNode(), "toolboxitem.placeholder.tooltip");

		// Add activity template
		addToolBoxItem(ProcessElementFactory.getInstance().createStandardActivityNode(), "toolboxitem.activity.tooltip");

		// Add visual template
		addToolBoxItem(ProcessElementFactory.getInstance().createStandardVisualNode(), "toolboxitem.visual.tooltip");

		// Add process template
		addToolBoxItem(new ProcessItemImpl(), "toolboxitem.process.tooltip");

		/*
		 // Add actor template
		 addToolBoxItem (new ActorItemImpl (), "toolboxitem.actor.tooltip");

		 // Add vertical swimline line template
		 addToolBoxItem (new VLineFigure (null), "VLine");

		 // Add horizontal swimline line template
		 addToolBoxItem (new HLineFigure (null), "HLine");
		 */

		// Add text element template
		addToolBoxItem(new TextElementImpl(), "toolboxitem.textelement.tooltip");

		NodeSocket socket;

		// Add entry socket
		socket = new NodeSocketImpl();
		socket.setEntrySocket(true);
		addToolBoxItem(socket, "toolboxitem.socketentry.tooltip");

		// Add exit socket
		socket = new NodeSocketImpl();
		socket.setEntrySocket(false);
		addToolBoxItem(socket, "toolboxitem.socketexit.tooltip");
	}

	/**
	 * @see org.openbp.cockpit.plugins.toolbox.ToolBoxPlugin#canTitleChange()
	 */
	protected boolean canTitleChange()
	{
		// Disable title change
		return false;
	}

	/**
	 * @see org.openbp.cockpit.plugins.toolbox.ToolBoxPlugin#acceptDrop()
	 */
	protected boolean acceptDrop()
	{
		// Disable drop
		return false;
	}

	/**
	 * @see org.openbp.cockpit.plugins.toolbox.ToolBoxPlugin#acceptFlyWheelKey(int)
	 */
	protected boolean acceptFlyWheelKey(int key)
	{
		// Trigger this toolbox using the space key
		return key == KeyEvent.VK_SPACE;
	}
}
