/*
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */
package org.openbp.guiclient.event;

import org.openbp.jaspira.plugin.Plugin;

/**
 * This event is used if a file is to be opened in its associated editor.
 *
 * @author Andreas Putz
 */
public class FileOpenEvent extends OpenEvent
{
	/** Line number to select */
	private int lineNumber;

	/** Column number to select */
	private int columnNumber;

	/**
	 * Constructor.
	 *
	 * In Comparison to the object that shall be opened the underlying object
	 * contains the environmental information of former.
	 *
	 * @param source Source of the event
	 * @param eventName Name of the event
	 * @param filePath Path of the file that shall be opened
	 * @param mimeTypes MIME types of the object or null
	 */
	public FileOpenEvent(Plugin source, String eventName, String filePath, String [] mimeTypes)
	{
		super(source, eventName, filePath);
		setMimeTypes(mimeTypes);
	}

	/**
	 * Gets the file path
	 *
	 */
	public String getFilePath()
	{
		return (String) getObject();
	}

	/**
	 * Gets the line number to select.
	 */
	public int getLineNumber()
	{
		return lineNumber;
	}

	/**
	 * Sets the line number to select.
	 */
	public void setLineNumber(int lineNumber)
	{
		this.lineNumber = lineNumber;
	}

	/**
	 * Gets the column number to select.
	 */
	public int getColumnNumber()
	{
		return columnNumber;
	}

	/**
	 * Sets the column number to select.
	 */
	public void setColumnNumber(int columnNumber)
	{
		this.columnNumber = columnNumber;
	}
}
