/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.generator;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.openbp.cockpit.generator.Generator;
import org.openbp.cockpit.generator.GeneratorCustomizer;
import org.openbp.cockpit.generator.GeneratorPageDescriptor;
import org.openbp.cockpit.generator.GeneratorProperty;
import org.openbp.cockpit.generator.GeneratorSettings;
import org.openbp.common.ExceptionUtil;
import org.openbp.common.application.Application;
import org.openbp.common.classloader.XClassLoader;
import org.openbp.common.classloader.XClassLoaderConfiguration;
import org.openbp.common.generic.description.DescriptionObjectImpl;
import org.openbp.common.generic.description.DisplayObjectImpl;
import org.openbp.common.generic.propertybrowser.CollectionDescriptor;
import org.openbp.common.generic.propertybrowser.ObjectDescriptor;
import org.openbp.common.generic.propertybrowser.PropertyDescriptor;
import org.openbp.common.io.xml.XMLDriver;
import org.openbp.common.io.xml.XMLDriverException;
import org.openbp.common.resource.ResourceMgr;
import org.openbp.common.resource.ResourceMgrException;
import org.springframework.core.io.Resource;

public final class GeneratorMgr {
    private List generatorList;
    private static GeneratorMgr singletonInstance;
    private static Class[] standardMappedClasses;

    public static synchronized GeneratorMgr getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new GeneratorMgr();
        }
        return singletonInstance;
    }

    private GeneratorMgr() {
        this.loadGenerators();
    }

    public void reload() {
        this.loadGenerators();
    }

    public Generator getGenerator(String name) {
        int n = this.generatorList.size();
        for (int i = 0; i < n; ++i) {
            Generator generator = (Generator)this.generatorList.get(i);
            if (!generator.getName().equals(name)) continue;
            return generator;
        }
        return null;
    }

    public List getGenerators(String itemType, boolean createItem) {
        if (itemType == null) {
            return this.generatorList;
        }
        int n = this.generatorList.size();
        if (n == 0) {
            return null;
        }
        ArrayList<Generator> list = new ArrayList<Generator>();
        for (int i = 0; i < n; ++i) {
            Generator generator = (Generator)this.generatorList.get(i);
            if (!itemType.equalsIgnoreCase(generator.getItemType()) || createItem != generator.isItemGenerator() || !generator.checkPrecondition()) continue;
            list.add(generator);
        }
        if (list.size() == 0) {
            return null;
        }
        Collections.sort(list);
        return list;
    }

    private void loadGenerators() {
        XMLDriver xmlDriver = XMLDriver.getInstance();
        try {
            xmlDriver.loadMappings(standardMappedClasses);
        }
        catch (XMLDriverException e) {
            ExceptionUtil.printTrace((Throwable)e);
            return;
        }
        this.generatorList = new ArrayList();
        ClassLoader classLoader = this.getClass().getClassLoader();
        String classesDir = Application.getRootDir() + "/" + "generator" + "/" + "classes";
        if (new File(classesDir).isDirectory()) {
            XClassLoaderConfiguration config = new XClassLoaderConfiguration();
            config.setName("Generator template class loader");
            config.setParentClassLoader(this.getClass().getClassLoader());
            config.addRepository(classesDir);
            try {
                classLoader = new XClassLoader(config);
            }
            catch (Exception e) {
                ExceptionUtil.printTrace((Throwable)e);
                return;
            }
        }
        ResourceMgr resMgr = ResourceMgr.getDefaultInstance();
        String resourcePattern = "generator/*.xml";
        Resource[] resources = null;
        try {
            resources = resMgr.findResources(resourcePattern);
        }
        catch (ResourceMgrException e) {
            return;
        }
        if (resources.length == 0) {
            return;
        }
        for (int i = 0; i < resources.length; ++i) {
            Generator generator;
            block19: {
                generator = null;
                try {
                    generator = (Generator)xmlDriver.deserializeResource(Generator.class, resources[i]);
                }
                catch (XMLDriverException e) {
                    ExceptionUtil.printTrace((Throwable)e);
                    continue;
                }
                generator.setGeneratorMgr(this);
                generator.setClassLoader(classLoader);
                XMLDriver generatorXmlDriver = new XMLDriver(classLoader);
                try {
                    generatorXmlDriver.loadMappings(standardMappedClasses);
                    generator.setXmlDriver(generatorXmlDriver);
                }
                catch (XMLDriverException e) {
                    ExceptionUtil.printTrace((Throwable)e);
                    continue;
                }
                try {
                    generator.createCustomizer();
                }
                catch (Exception e) {
                    ExceptionUtil.printTrace((Throwable)e);
                    continue;
                }
                try {
                    Class settingsClass;
                    GeneratorCustomizer customizer = generator.getCustomizer();
                    if (customizer == null) break block19;
                    Class[] dependentClasses = customizer.getDependentSettingsClasses();
                    if (dependentClasses != null) {
                        for (int iClasses = 0; iClasses < dependentClasses.length; ++iClasses) {
                            generatorXmlDriver.loadMapping(dependentClasses[iClasses]);
                        }
                    }
                    if ((settingsClass = customizer.getSettingsClass()) == null) break block19;
                    generatorXmlDriver.loadMapping(settingsClass);
                }
                catch (XMLDriverException e) {
                    ExceptionUtil.printTrace((Throwable)e);
                    continue;
                }
            }
            this.generatorList.add(generator);
        }
        Collections.sort(this.generatorList, new Comparator(){

            public int compare(Object o1, Object o2) {
                int s1 = ((Generator)o1).getXmlLoaderSequenceNr();
                int s2 = ((Generator)o2).getXmlLoaderSequenceNr();
                return s1 - s2;
            }
        });
    }

    static {
        standardMappedClasses = new Class[]{DescriptionObjectImpl.class, DisplayObjectImpl.class, CollectionDescriptor.class, ObjectDescriptor.class, PropertyDescriptor.class, Generator.class, GeneratorPageDescriptor.class, GeneratorProperty.class, GeneratorSettings.class};
    }
}

