/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.generator.activity;

import org.openbp.cockpit.generator.GeneratorContext;
import org.openbp.cockpit.generator.GeneratorCustomizer;
import org.openbp.cockpit.generator.GeneratorSettings;
import org.openbp.core.model.item.activity.ActivityItem;
import org.openbp.core.model.item.activity.JavaActivityItem;
import org.openbp.guiclient.util.ClassNameBuilderUtil;
import org.openbp.jaspira.gui.wizard.JaspiraWizardObjectPage;
import org.openbp.swing.components.wizard.WizardEvent;

public class ActivityCustomizer
extends GeneratorCustomizer {
    @Override
    public Class getSettingsClass() {
        return GeneratorSettings.class;
    }

    @Override
    public String getTemplateName(GeneratorContext context) {
        JavaActivityItem activity = (JavaActivityItem)context.getItem();
        if (activity.getHandlerDefinition().getHandlerClassName() != null) {
            return super.getTemplateName(context);
        }
        return null;
    }

    @Override
    public boolean hasResultPage(GeneratorContext context) {
        return this.getTemplateName(context) != null;
    }

    @Override
    public void processWizardEvent(GeneratorContext context, WizardEvent event) {
        String pageName = event.wizard.getManager().getCurrent();
        if (pageName.equals("property") && event.eventType == 0 && context.isEmptyItem() && !context.isClassnameSet()) {
            JavaActivityItem activity = (JavaActivityItem)context.getItem();
            if (activity.getHandlerDefinition().getHandlerClassName() == null) {
                activity.getHandlerDefinition().setHandlerClassName(ClassNameBuilderUtil.constructActivityClassName((ActivityItem)activity));
                JaspiraWizardObjectPage page = (JaspiraWizardObjectPage)((Object)event.wizard.getPage(pageName));
                page.handleWizardEvent(event);
            }
            context.setClassnameSet(true);
        }
        super.processWizardEvent(context, event);
    }
}

