/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.generator.generic;

import org.openbp.common.MsgFormat;
import org.openbp.common.generic.description.DisplayObjectImpl;
import org.openbp.common.generic.msgcontainer.MsgContainer;
import org.openbp.core.model.Model;
import org.openbp.core.model.ModelException;
import org.openbp.core.model.ModelQualifier;
import org.openbp.core.model.item.Item;
import org.openbp.core.model.item.process.InitialNode;
import org.openbp.core.model.item.process.Node;
import org.openbp.core.model.item.process.ProcessItem;

public class ProcessEntry
extends DisplayObjectImpl {
    private InitialNode initialNode;
    private String entryName;
    private Model model;

    public void copyFrom(Object source, int copyMode) throws CloneNotSupportedException {
        if (source == this) {
            return;
        }
        super.copyFrom(source, copyMode);
        ProcessEntry src = (ProcessEntry)((Object)source);
        this.initialNode = src.initialNode;
        this.entryName = src.entryName;
    }

    public InitialNode getInitialNode() {
        return this.initialNode;
    }

    public void setInitialNode(InitialNode initialNode) {
        this.initialNode = initialNode;
    }

    public String getEntryName() {
        return this.entryName;
    }

    public void setEntryName(String entryName) {
        this.entryName = entryName;
    }

    public Model getModel() {
        return this.model;
    }

    public void setModel(Model model) {
        this.model = model;
    }

    public void beforeSerialization(Model model) {
        this.entryName = this.initialNode != null ? model.determineItemRef((Item)this.initialNode.getProcess()) + ModelQualifier.OBJECT_DELIMITER_CHAR + this.initialNode.getName() : null;
    }

    public void afterDeserialization(MsgContainer msgs, Model model) {
        ProcessItem process;
        this.initialNode = null;
        if (this.entryName == null) {
            return;
        }
        int index = this.entryName.lastIndexOf(ModelQualifier.OBJECT_DELIMITER_CHAR);
        if (index < 0) {
            return;
        }
        String processName = this.entryName.substring(0, index);
        this.entryName = this.entryName.substring(index + 1);
        try {
            process = (ProcessItem)model.resolveItemRef(processName, "Process");
        }
        catch (ModelException e) {
            String msg = e.getMessage();
            msgs.addMsg(null, "Cannot resolve the process name of an entry. Maybe the process has been deleted.\n" + msg);
            return;
        }
        Node node = process.getNodeByName(this.entryName);
        if (node instanceof InitialNode) {
            this.initialNode = (InitialNode)node;
        } else {
            String msg = MsgFormat.format((String)"Cannot resolve the entry $0 in process $1. Maybe the entry has been deleted.", (Object)this.entryName, (Object)process.getQualifier());
            msgs.addMsg(null, msg);
        }
    }
}

