/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.generator.wizard;

import org.openbp.cockpit.generator.Generator;
import org.openbp.cockpit.generator.GeneratorContext;
import org.openbp.cockpit.generator.GeneratorPageDescriptor;
import org.openbp.cockpit.generator.GeneratorSettings;
import org.openbp.cockpit.generator.wizard.GeneratorWizard;
import org.openbp.common.ExceptionUtil;
import org.openbp.common.io.xml.XMLDriverException;
import org.openbp.jaspira.gui.wizard.JaspiraWizardObjectPage;
import org.openbp.jaspira.propertybrowser.PropertyBrowser;
import org.openbp.swing.components.wizard.Wizard;
import org.openbp.swing.components.wizard.WizardEvent;

public class WizardObjectPage
extends JaspiraWizardObjectPage {
    private GeneratorPageDescriptor pageDescriptor;

    public WizardObjectPage(Wizard wizard, GeneratorPageDescriptor pageDescriptor) {
        super(wizard);
        this.pageDescriptor = pageDescriptor;
        if (!((GeneratorWizard)wizard).getContext().isNewItem()) {
            this.canFinish = true;
        }
    }

    @Override
    public void handleWizardEvent(WizardEvent event) {
        GeneratorContext context = this.getContext();
        if (event.eventType == 0) {
            Object o = context.getProperty(this.pageDescriptor.getName());
            try {
                this.getPropertyBrowser().setObject(o, true);
                if (context.isNewItem()) {
                    this.getPropertyBrowser().setObjectModified(true);
                }
            }
            catch (XMLDriverException e) {
                ExceptionUtil.printTrace((Throwable)e);
            }
            catch (CloneNotSupportedException e) {
                ExceptionUtil.printTrace((Throwable)e);
            }
        } else if (event.eventType == 4 || event.eventType == 3 || event.eventType == 2) {
            if (this.getPropertyBrowser().isObjectModified()) {
                context.setNeedGeneration(true);
            }
        } else if (event.eventType == 1) {
            this.getPropertyBrowser().reset();
        }
        super.handleWizardEvent(event);
    }

    @Override
    public boolean executeSave(PropertyBrowser pb) {
        Object o = pb.getModifiedObject();
        GeneratorContext context = this.getContext();
        context.setProperty(this.pageDescriptor.getName(), o);
        if (o instanceof GeneratorSettings) {
            context.setGeneratorSettings((GeneratorSettings)o);
        }
        return true;
    }

    public GeneratorContext getContext() {
        return ((GeneratorWizard)this.getWizard()).getContext();
    }

    public Generator getGenerator() {
        return ((GeneratorWizard)this.getWizard()).getContext().getSelectedGenerator();
    }

    public GeneratorSettings getGeneratorSettings() {
        return ((GeneratorWizard)this.getWizard()).getContext().getGeneratorSettings();
    }
}

