/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.generator.wizard;

import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openbp.cockpit.generator.Generator;
import org.openbp.cockpit.generator.GeneratorContext;
import org.openbp.cockpit.generator.GeneratorSettings;
import org.openbp.cockpit.generator.wizard.GeneratorNode;
import org.openbp.cockpit.generator.wizard.GeneratorWizard;
import org.openbp.common.icon.MultiIcon;
import org.openbp.common.rc.ResourceCollection;
import org.openbp.jaspira.gui.StdIcons;
import org.openbp.jaspira.gui.wizard.JaspiraWizardPage;
import org.openbp.swing.components.treetable.DefaultTreeCellRenderer;
import org.openbp.swing.components.treetable.DefaultTreeTableModel;
import org.openbp.swing.components.treetable.DefaultTreeTableNode;
import org.openbp.swing.components.treetable.JTreeTable;
import org.openbp.swing.components.treetable.TreeTableModel;
import org.openbp.swing.components.wizard.SequenceManager;
import org.openbp.swing.components.wizard.Wizard;
import org.openbp.swing.components.wizard.WizardEvent;

public class WizardSelectionPage
extends JaspiraWizardPage
implements TreeSelectionListener {
    private DefaultTreeTableModel treeModel;
    private JTreeTable treeTable;
    private static String[] tableHeader;
    private String defaultDescription;
    private GeneratorNode rootNode = new GeneratorNode();
    private Map groupNodes = new HashMap();

    public WizardSelectionPage(GeneratorWizard wizard) {
        super((Wizard)wizard);
        this.rootNode = new GeneratorNode();
        this.treeModel = new DefaultTreeTableModel((DefaultTreeTableNode)this.rootNode);
        if (tableHeader == null) {
            ResourceCollection resourceCollection = wizard.getResource();
            tableHeader = new String[]{resourceCollection.getRequiredString("wizard.selection.header1"), resourceCollection.getRequiredString("wizard.selection.header2")};
        }
        this.treeModel.setColumnHeader(tableHeader);
        this.treeTable = new JTreeTable((TreeTableModel)this.treeModel);
        this.treeTable.setRootVisible(false);
        this.treeTable.getTree().setCellRenderer((TreeCellRenderer)((Object)new GeneratorTreeCellRenderer(this.treeTable)));
        this.treeTable.getTree().addTreeSelectionListener(this);
        JPanel cp = this.getContentPanel();
        JScrollPane sp = new JScrollPane((Component)this.treeTable);
        cp.add((Component)sp, "Center");
    }

    public void handleWizardEvent(WizardEvent event) {
        if (event.eventType == 0) {
            if (this.defaultDescription == null) {
                this.defaultDescription = this.getDescription();
            }
            GeneratorNode currentNode = null;
            GeneratorContext context = this.getContext();
            Generator generator = context.getSelectedGenerator();
            if (generator != null) {
                currentNode = this.findNode(this.rootNode, generator);
            }
            if (currentNode != null) {
                this.treeTable.selectNode((TreeNode)((Object)currentNode));
            } else {
                this.treeTable.selectDefaultCell();
            }
            this.updatePageStatus();
        }
    }

    private GeneratorNode findNode(GeneratorNode node, Generator generator) {
        if (node.getGenerator() == generator) {
            return node;
        }
        int n = node.getChildCount();
        for (int i = 0; i < n; ++i) {
            GeneratorNode childNode = (GeneratorNode)((Object)node.getChildAt(i));
            if ((childNode = this.findNode(childNode, generator)) == null) continue;
            return childNode;
        }
        return null;
    }

    public void addGenerator(Generator generator) {
        String group = generator.getFunctionalGroup();
        GeneratorNode groupNode = (GeneratorNode)((Object)this.groupNodes.get(group));
        if (groupNode == null) {
            groupNode = new GeneratorNode(group);
            this.rootNode.addChild(groupNode);
            this.groupNodes.put(group, groupNode);
        }
        groupNode.addChild(new GeneratorNode(generator));
    }

    public void expandTree() {
        this.treeTable.expandAll(true);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        GeneratorNode node;
        GeneratorContext context = this.getContext();
        Generator generator = null;
        TreePath path = e.getNewLeadSelectionPath();
        if (path != null && (generator = (node = (GeneratorNode)((Object)path.getLastPathComponent())).getGenerator()) == context.getSelectedGenerator()) {
            return;
        }
        context.setSelectedGenerator(generator);
        context.setNeedGeneration(true);
        ((GeneratorWizard)this.getWizard()).updateGeneratorPageSequence();
        this.updatePageStatus();
    }

    private void updatePageStatus() {
        GeneratorContext context = this.getContext();
        Generator generator = context.getSelectedGenerator();
        String description = generator != null ? generator.getDescription() : this.defaultDescription;
        this.setDescription(description);
        this.canFinish = false;
        this.canMoveForward = false;
        if (generator != null && !context.isInvalidGenerator()) {
            SequenceManager manager = this.getWizard().getManager();
            if (manager.getNext() != null) {
                this.canMoveForward = true;
            } else {
                this.canFinish = true;
            }
        }
        this.updateNavigator();
    }

    public GeneratorContext getContext() {
        return ((GeneratorWizard)this.getWizard()).getContext();
    }

    public Generator getGenerator() {
        return ((GeneratorWizard)this.getWizard()).getContext().getSelectedGenerator();
    }

    public GeneratorSettings getGeneratorSettings() {
        return ((GeneratorWizard)this.getWizard()).getContext().getGeneratorSettings();
    }

    private class GeneratorTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private GeneratorTreeCellRenderer(JTreeTable treeTable) {
            super(treeTable);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component c = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (c instanceof JLabel) {
                MultiIcon icon = null;
                if (row == 0) {
                    icon = expanded ? StdIcons.openFolderIcon : StdIcons.closedFolderIcon;
                } else {
                    GeneratorNode node;
                    Generator generator;
                    TreePath path = tree.getPathForRow(row);
                    if (path != null && (generator = (node = (GeneratorNode)((Object)path.getLastPathComponent())).getGenerator()) == null) {
                        icon = expanded ? StdIcons.openFolderIcon : StdIcons.closedFolderIcon;
                    }
                }
                ((JLabel)c).setIcon((Icon)icon);
            }
            return c;
        }
    }
}

