/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.itemeditor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.List;
import javax.swing.JPanel;
import org.openbp.cockpit.generator.Generator;
import org.openbp.cockpit.generator.GeneratorMgr;
import org.openbp.cockpit.generator.GeneratorSettings;
import org.openbp.cockpit.generator.wizard.WizardSelectionPage;
import org.openbp.cockpit.itemeditor.NodeItemEditorPage;
import org.openbp.cockpit.itemeditor.StandardItemEditor;
import org.openbp.cockpit.modeler.skins.Skin;
import org.openbp.cockpit.modeler.util.FigureUtil;
import org.openbp.core.model.item.Item;
import org.openbp.core.model.item.activity.ActivityItem;
import org.openbp.core.model.item.process.ItemProvider;
import org.openbp.core.model.item.process.Node;
import org.openbp.core.model.item.process.NodeProvider;
import org.openbp.core.model.item.process.ProcessItem;
import org.openbp.core.model.item.process.ProcessItemImpl;
import org.openbp.jaspira.gui.wizard.JaspiraWizardPage;
import org.openbp.jaspira.plugin.ApplicationUtil;
import org.openbp.jaspira.plugin.PluginMgr;
import org.openbp.swing.components.wizard.Wizard;
import org.openbp.swing.components.wizard.WizardEvent;

public class NodeItemEditor
extends StandardItemEditor {
    public static final String NODEEDITOR_PROCESS_NAME = "NodeEditorDummyProcess";
    public static final String EDITOR_PAGE = "editor";
    private EditorPage editorWizardPage;
    protected NodeItemEditorPage editorJaspiraPage;

    @Override
    public Item openItem(Item item, int editedItemStatus) {
        Item ret = super.openItem(item, editedItemStatus);
        this.disposeEditorJaspiraPage(this.editorWizardPage.getContentPanel());
        return ret;
    }

    @Override
    protected Dimension getInitialSize() {
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        size.height -= 30;
        if (size.width > 900) {
            size.width = 900;
        }
        if (size.height > 800) {
            size.height = 800;
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setupPages() {
        ApplicationUtil.waitCursorOn();
        try {
            List list;
            this.clearPages();
            Item item = this.context.getItem();
            if (this.context.getSelectedGenerator() == null && (list = GeneratorMgr.getInstance().getGenerators(item.getItemType(), true)) != null) {
                Generator gen;
                int n = list.size();
                if (n > 1) {
                    WizardSelectionPage selectionPage = new WizardSelectionPage(this);
                    for (int i = 0; i < n; ++i) {
                        Generator generator = (Generator)list.get(i);
                        selectionPage.addGenerator(generator);
                    }
                    selectionPage.expandTree();
                    this.addAndLinkPage("selection", (Component)((Object)selectionPage));
                } else if (n == 1 && (gen = (Generator)list.get(0)) != null) {
                    this.context.setSelectedGenerator(gen);
                    GeneratorSettings settings = new GeneratorSettings();
                    settings.setGeneratorName(gen.getName());
                    this.context.setGeneratorSettings(settings);
                    this.context.setProperty("settings", settings);
                }
            }
            this.addPropertyPage();
            if (this.editorWizardPage == null) {
                this.editorWizardPage = new EditorPage(this);
            }
            this.addAndLinkPage(EDITOR_PAGE, (Component)((Object)this.editorWizardPage));
        }
        finally {
            ApplicationUtil.waitCursorOff();
        }
    }

    @Override
    protected void setupPosition() {
        if (this.context.isNewItem()) {
            this.displayFirst();
        } else {
            String page = null;
            Generator generator = this.context.getSelectedGenerator();
            if (generator != null) {
                page = generator.getDefaultStartPageName();
            }
            if (page == null) {
                page = EDITOR_PAGE;
            }
            this.displayPage(page);
        }
    }

    @Override
    protected boolean fireWizardEvent(WizardEvent event) {
        Item item;
        String pageName;
        if ((event.eventType == 2 || event.eventType == 3) && (pageName = event.wizard.getManager().getCurrent()).equals("property") && this.context.isEmptyItem() && (item = this.context.getItem()) instanceof ActivityItem) {
            FigureUtil.updateItemGeometry(null, item);
        }
        return super.fireWizardEvent(event);
    }

    void createEditorJaspiraPage(JPanel contentPanel) {
        this.editorJaspiraPage = (NodeItemEditorPage)PluginMgr.getInstance().createInstance(NodeItemEditorPage.class, null);
        this.getDndPane().addDropClient(this.editorJaspiraPage.getNodeEditor().getPluginPanel());
        contentPanel.add((Component)this.editorJaspiraPage.getPluginComponent(), "Center");
    }

    private void disposeEditorJaspiraPage(JPanel contentPanel) {
        contentPanel.removeAll();
        this.getDndPane().clearDropClients();
        PluginMgr.getInstance().removeInstance(this.editorJaspiraPage);
        this.editorJaspiraPage = null;
    }

    public class EditorPage
    extends JaspiraWizardPage {
        private Node node;

        public EditorPage(NodeItemEditor wizard) {
            super((Wizard)wizard);
            this.canFinish = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleWizardEvent(WizardEvent event) {
            Item item = NodeItemEditor.this.context.getItem();
            if (event.eventType == 0) {
                ApplicationUtil.waitCursorOn();
                try {
                    if (NodeItemEditor.this.editorJaspiraPage == null) {
                        NodeItemEditor.this.createEditorJaspiraPage(this.getContentPanel());
                    }
                    ProcessItemImpl dummyProcess = new ProcessItemImpl();
                    dummyProcess.setName(NodeItemEditor.NODEEDITOR_PROCESS_NAME);
                    dummyProcess.setModel(item.getModel());
                    Skin processSkin = FigureUtil.determineProcessSkin((ProcessItem)dummyProcess);
                    processSkin.initalizeNewProcess((ProcessItem)dummyProcess);
                    this.node = ((NodeProvider)item).toNode((ProcessItem)dummyProcess, 122);
                    dummyProcess.addNode(this.node);
                    NodeItemEditor.this.editorJaspiraPage.setNode(this.node);
                }
                finally {
                    ApplicationUtil.waitCursorOff();
                }
            } else if ((event.eventType == 2 || event.eventType == 1 || event.eventType == 3 || event.eventType == 4) && event.eventType != 1) {
                NodeItemEditor.this.editorJaspiraPage.saveNode();
                int syncFlags = 122;
                if (NodeItemEditor.this.context.isEmptyItem()) {
                    syncFlags |= 1;
                }
                ((ItemProvider)this.node).copyToItem(item, syncFlags);
            }
        }
    }
}

