/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.itemeditor;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.framework.ViewChangeListener;
import CH.ifa.draw.util.UndoManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openbp.cockpit.modeler.ClipboardSupport;
import org.openbp.cockpit.modeler.StandardToolSupportSetup;
import org.openbp.cockpit.modeler.drawing.DrawingEditorPlugin;
import org.openbp.cockpit.modeler.drawing.ProcessDrawing;
import org.openbp.cockpit.modeler.drawing.Trackable;
import org.openbp.cockpit.modeler.drawing.WorkspaceDrawingView;
import org.openbp.cockpit.modeler.figures.generic.Colorizable;
import org.openbp.cockpit.modeler.figures.process.MultiSocketNodeFigure;
import org.openbp.cockpit.modeler.tools.ModelerToolSupport;
import org.openbp.cockpit.modeler.util.ModelerFlavors;
import org.openbp.common.ExceptionUtil;
import org.openbp.common.listener.SwingListenerSupport;
import org.openbp.core.model.ModelObject;
import org.openbp.core.model.item.process.Node;
import org.openbp.core.model.item.process.ProcessItem;
import org.openbp.core.model.item.process.ProcessItemImpl;
import org.openbp.guiclient.util.ClientFlavors;
import org.openbp.jaspira.action.JaspiraAction;
import org.openbp.jaspira.event.InteractionEvent;
import org.openbp.jaspira.event.JaspiraEvent;
import org.openbp.jaspira.event.JaspiraEventHandlerCode;
import org.openbp.jaspira.gui.clipboard.ClipboardMgr;
import org.openbp.jaspira.gui.interaction.InteractionClient;
import org.openbp.jaspira.gui.plugin.AbstractVisiblePlugin;
import org.openbp.jaspira.plugin.EventModule;
import org.openbp.jaspira.plugin.InteractionModule;
import org.openbp.jaspira.plugins.propertybrowser.PropertyBrowserSaveEvent;
import org.openbp.jaspira.undo.Undoable;

public class NodeItemEditorPlugin
extends AbstractVisiblePlugin
implements DrawingEditorPlugin,
Trackable,
ComponentListener,
FocusListener {
    private ModelerToolSupport toolSupport;
    protected WorkspaceDrawingView workspaceView;
    protected ProcessDrawing drawing;
    private MultiSocketNodeFigure figure;
    private JScrollPane scrollPane;
    private ClipboardSupport clipboardSupport;
    private SwingListenerSupport listenerSupport;
    private boolean trackSuspended;

    @Override
    public String getResourceCollectionContainerName() {
        return "plugin.cockpit";
    }

    public void setNode(Node node) {
        this.clipboardSupport = new ClipboardSupport(this.workspaceView, this.getPluginResourceCollection(), true);
        ProcessItem process = node.getProcess();
        this.drawing = new ProcessDrawing(process, this);
        this.drawing.setDisplayAll(true);
        this.figure = (MultiSocketNodeFigure)this.drawing.figureAt(0);
        this.positionFigure();
        this.workspaceView.setDrawing((Drawing)this.drawing);
        this.workspaceView.singleSelect(this.figure);
        this.addPluginFocusListener(this);
    }

    public void saveNode() {
        this.figure.encodeGeometry();
    }

    @Override
    public ModelerToolSupport getToolSupport() {
        return this.toolSupport;
    }

    @Override
    protected void initializeComponents() {
        this.workspaceView = new WorkspaceDrawingView(this);
        this.workspaceView.setSizeOffset(0);
        this.drawing = new ProcessDrawing((ProcessItem)new ProcessItemImpl(), this);
        this.workspaceView.setDrawing((Drawing)this.drawing);
        this.toolSupport = new ModelerToolSupport(this);
        StandardToolSupportSetup.setupToolSupport(this.toolSupport, false);
        this.scrollPane = new JScrollPane((Component)((Object)this.workspaceView));
        this.getPluginComponent().add(this.scrollPane);
        this.getPluginComponent().addComponentListener(this);
    }

    @Override
    public void pluginShown() {
        super.pluginShown();
        if (this.figure != null) {
            this.figure.updateFigure();
            this.positionFigure();
            this.workspaceView.singleSelect(this.figure);
            this.toolSupport.updateToolState();
        }
    }

    private void positionFigure() {
        this.figure.displayBox(new Rectangle(this.getPluginComponent().getSize()));
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.figure != null) {
            this.positionFigure();
            this.workspaceView.redraw();
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    public void figureSelectionChanged(DrawingView arg0) {
    }

    public UndoManager getUndoManager() {
        return null;
    }

    public void addViewChangeListener(ViewChangeListener arg0) {
    }

    public void removeViewChangeListener(ViewChangeListener arg0) {
    }

    public void showStatus(String arg0) {
    }

    public Tool tool() {
        return this.toolSupport;
    }

    public void toolDone() {
    }

    public DrawingView view() {
        return this.workspaceView;
    }

    public DrawingView[] views() {
        return new DrawingView[]{this.workspaceView};
    }

    @Override
    public void repairDamage() {
        this.workspaceView.repairDamage();
    }

    @Override
    public List getSubClients() {
        if (this.figure != null) {
            return Collections.singletonList(this.figure);
        }
        return null;
    }

    @Override
    public boolean canCopy() {
        return this.clipboardSupport != null ? this.clipboardSupport.canCopy() : false;
    }

    @Override
    public boolean canDelete() {
        return this.clipboardSupport != null ? this.clipboardSupport.canDelete() : false;
    }

    @Override
    public boolean canCut() {
        return this.clipboardSupport != null ? this.clipboardSupport.canCopy() && this.clipboardSupport.canDelete() : false;
    }

    @Override
    public boolean canPaste(Transferable transferable) {
        if (transferable != null) {
            if (transferable.isDataFlavorSupported(ClientFlavors.NODE_SOCKETS)) {
                return true;
            }
            if (transferable.isDataFlavorSupported(ClientFlavors.NODE_PARAMS)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Transferable copy() {
        Transferable transferable = this.clipboardSupport.getCopyData();
        ClipboardMgr.getInstance().addEntry(transferable);
        return transferable;
    }

    @Override
    public Transferable cut() {
        Transferable transferable = this.clipboardSupport.cut();
        ClipboardMgr.getInstance().addEntry(transferable);
        return transferable;
    }

    @Override
    public void delete() {
        this.clipboardSupport.delete();
    }

    @Override
    public void paste(Transferable transferable) {
        this.clipboardSupport.paste(transferable);
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.fireEvent("global.clipboard.updatestatus");
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.fireEvent("global.clipboard.updatestatus");
    }

    @Override
    public Dimension getDocumentSize() {
        return this.workspaceView.getSize();
    }

    @Override
    public Rectangle getVisibleArea() {
        Rectangle r = this.scrollPane.getViewport().getViewRect();
        return this.workspaceView.applyScale(r, true);
    }

    @Override
    public void setVisibleArea(Rectangle r) {
        this.workspaceView.setVisibleRect(r);
    }

    @Override
    public void centerTrackerAt(Point p) {
        p = this.workspaceView.applyScale(p, false);
        Dimension d = this.scrollPane.getViewport().getSize();
        p.x -= d.width / 2;
        p.y -= d.height / 2;
        if (p.x < 0) {
            p.x = 0;
        }
        if (p.y < 0) {
            p.y = 0;
        }
        if (p.x + d.width > this.workspaceView.getWidth()) {
            p.x = this.workspaceView.getWidth() - d.width;
        }
        if (p.y + d.height > this.workspaceView.getHeight()) {
            p.y = this.workspaceView.getHeight() - d.height;
        }
        this.scrollPane.getViewport().setViewPosition(p);
    }

    @Override
    public void moveTrackerBy(int x, int y) {
        Rectangle r = this.getVisibleArea();
        r.translate(x, y);
        this.workspaceView.scrollRectToVisible(r);
    }

    @Override
    public void addTrackChangedListener(ChangeListener listener) {
        if (this.listenerSupport == null) {
            this.listenerSupport = new SwingListenerSupport();
        }
        this.listenerSupport.addWeakListener(ChangeListener.class, (EventListener)listener);
    }

    @Override
    public void removeTrackChangedListener(ChangeListener listener) {
        if (this.listenerSupport != null) {
            this.listenerSupport.removeListener(ChangeListener.class, (EventListener)listener);
        }
    }

    @Override
    public void fireTrackChangedEvent(ChangeEvent event) {
        if (!this.trackSuspended && this.listenerSupport != null && this.listenerSupport.containsListeners(ChangeListener.class)) {
            this.listenerSupport.fireStateChanged(event);
        }
    }

    @Override
    public void suspendTrack() {
        this.trackSuspended = true;
    }

    @Override
    public void resumeTrack() {
        this.trackSuspended = false;
        this.fireTrackChangedEvent(new ChangeEvent(this));
    }

    @Override
    public boolean isTrackSuspended() {
        return this.trackSuspended;
    }

    public void setScaleFactor(double scaleFactor) {
        this.workspaceView.setScaleFactor(scaleFactor);
    }

    @Override
    public Undoable startUndo(String displayName) {
        return null;
    }

    @Override
    public void endUndo() {
    }

    @Override
    public void cancelUndo() {
    }

    @Override
    public boolean isUndoRecording() {
        return false;
    }

    public class InteractionEvents
    extends InteractionModule {
        @Override
        public int getPriority() {
            return 5;
        }

        @Override
        public JaspiraEventHandlerCode popup(InteractionEvent ie) {
            if (ie.getSourcePlugin() != NodeItemEditorPlugin.this) {
                return EVENT_IGNORED;
            }
            DataFlavor[] flavor = ie.getTransferDataFlavors();
            JaspiraAction group = new JaspiraAction("popup", null, null, null, null, 100, "group");
            for (int i = 0; i < flavor.length; ++i) {
                Colorizable col;
                if (flavor[i].equals(ModelerFlavors.FIGURE)) {
                    Figure figure = (Figure)ie.getSafeTransferData(flavor[i]);
                    NodeItemEditorPlugin.this.workspaceView.singleSelect(figure);
                }
                if (flavor[i].equals(ModelerFlavors.COLORIZABLE) && (col = (Colorizable)ie.getSafeTransferData(flavor[i])).getFillColor() != null && !col.getFillColor().equals(col.getDefaultFillColor())) {
                    group.addMenuChild(new JaspiraAction(NodeItemEditorPlugin.this, "modeler.edit.resetcolor"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            col.setFillColor(col.getDefaultFillColor());
                            col.invalidate();
                        }
                    });
                }
                NodeItemEditorPlugin modeler = NodeItemEditorPlugin.this;
                boolean copyEnabled = modeler.canCopy();
                boolean cutEnabled = modeler.canCut();
                boolean deleteEnabled = modeler.canDelete();
                boolean pasteEnabled = modeler.canPaste(ClipboardMgr.getInstance().getCurrentEntry());
                if (!copyEnabled && !deleteEnabled && !cutEnabled && !pasteEnabled) continue;
                JaspiraAction copyPasteGroup = new JaspiraAction("copypaste", null, null, null, null, 2, "group");
                JaspiraAction ja = new JaspiraAction(modeler, "modeler.edit.copy"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        NodeItemEditorPlugin.this.copy();
                    }
                };
                ja.setEnabled(copyEnabled);
                copyPasteGroup.addMenuChild(ja);
                ja = new JaspiraAction(modeler, "modeler.edit.cut"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        NodeItemEditorPlugin.this.cut();
                    }
                };
                ja.setEnabled(cutEnabled);
                copyPasteGroup.addMenuChild(ja);
                ja = new JaspiraAction(modeler, "modeler.edit.paste"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Transferable transferable = ClipboardMgr.getInstance().getCurrentEntry();
                        NodeItemEditorPlugin.this.paste(transferable);
                    }
                };
                ja.setEnabled(pasteEnabled);
                copyPasteGroup.addMenuChild(ja);
                ie.add(copyPasteGroup);
                ja = new JaspiraAction(modeler, "modeler.edit.delete"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        NodeItemEditorPlugin.this.delete();
                    }
                };
                ja.setEnabled(deleteEnabled);
                ie.add(ja);
            }
            ie.add(group);
            return EVENT_HANDLED;
        }
    }

    public class Events
    extends EventModule {
        @Override
        public String getName() {
            return "plugin.nodeeditor";
        }

        public JaspiraEventHandlerCode plugin_propertybrowser_executesave(PropertyBrowserSaveEvent oee) {
            if (!(oee.original instanceof ModelObject)) {
                return EVENT_IGNORED;
            }
            ModelObject orig = (ModelObject)oee.original;
            try {
                orig.copyFrom(oee.getObject(), 0);
            }
            catch (CloneNotSupportedException e) {
                ExceptionUtil.printTrace((Throwable)e);
                return EVENT_CONSUMED;
            }
            orig.maintainReferences(0);
            NodeItemEditorPlugin.this.drawing.updateFigure();
            NodeItemEditorPlugin.this.drawing.invalidate();
            NodeItemEditorPlugin.this.workspaceView.checkDamage();
            oee.saved = true;
            return EVENT_CONSUMED;
        }

        public JaspiraEventHandlerCode modeler_view_importtoselection(JaspiraEvent je) {
            boolean imported = false;
            Object regionId = null;
            Transferable transferable = (Transferable)je.getObject();
            Vector selectedFigures = NodeItemEditorPlugin.this.workspaceView.selection();
            int n = selectedFigures.size();
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    InteractionClient interactionClient;
                    Object o = selectedFigures.get(i);
                    if (!(o instanceof InteractionClient) || !(interactionClient = (InteractionClient)o).importData(regionId, transferable, null)) continue;
                    imported = true;
                }
            }
            if (imported) {
                return EVENT_HANDLED;
            }
            return EVENT_IGNORED;
        }
    }
}

