/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.custommodelobjectconfigurator;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import org.openbp.cockpit.modeler.Modeler;
import org.openbp.cockpit.modeler.custommodelobjectconfigurator.CustomModelObjectConfigurator;
import org.openbp.cockpit.modeler.custommodelobjectconfigurator.CustomModelObjectConfiguratorDescriptor;
import org.openbp.cockpit.modeler.util.ModelerUtil;
import org.openbp.common.ReflectUtil;
import org.openbp.common.logger.LogUtil;
import org.openbp.core.model.ModelObject;
import org.openbp.jaspira.action.JaspiraAction;

public class CustomModelObjectConfiguratorSupport {
    List<CustomModelObjectConfigurator> configurators;
    private Modeler modeler;
    private JaspiraAction templateAction;

    public CustomModelObjectConfiguratorSupport(Modeler modeler) {
        this.modeler = modeler;
        this.initialize();
    }

    public void initialize() {
        this.configurators = new ArrayList<CustomModelObjectConfigurator>();
        List<String> configuratorClassNames = ModelerUtil.getStringListFromSettings("openbp.cockpit.modelObjectConfigurators");
        for (String className : configuratorClassNames) {
            try {
                CustomModelObjectConfigurator configurator = (CustomModelObjectConfigurator)ReflectUtil.instantiate((String)className, CustomModelObjectConfigurator.class, (String)"custom model object configurator");
                this.configurators.add(configurator);
            }
            catch (Exception e) {
                LogUtil.error(this.getClass(), (String)"Error instantiating custom model object configurator $0.", (Object)className, (Object)e);
            }
        }
        this.templateAction = new JaspiraAction(this.modeler, "modeler.popup.custom");
    }

    public void addConfiguratorMenuOptions(final ModelObject mo, JaspiraAction group) {
        for (CustomModelObjectConfigurator configurator : this.configurators) {
            CustomModelObjectConfiguratorDescriptor desc = configurator.checkAppliance(mo);
            if (desc == null) continue;
            final CustomModelObjectConfigurator foundConfigurator = configurator;
            JaspiraAction action = new JaspiraAction(desc.getName(), desc.getDisplayName(), desc.getDescription(), null, null, desc.getPriority(), "action"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (foundConfigurator.displayActivityConfigurationDialog(mo)) {
                        CustomModelObjectConfiguratorSupport.this.modeler.getDrawing().setModified();
                    }
                }
            };
            action.setIcon(this.templateAction.getIcon());
            group.addMenuChild(action);
        }
    }
}

