/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.drawing.shadowlayout;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.openbp.cockpit.modeler.drawing.shadowlayout.ShadowLayouter;

public class PointLightSourceShadowLayouter
implements ShadowLayouter {
    private double lightX;
    private double lightY;
    private AffineTransform to = new AffineTransform();

    public PointLightSourceShadowLayouter(DrawingView view, double factor) {
        this.lightX = view.getSize().getWidth() / 2.0;
        this.lightY = view.getSize().getHeight() / 2.0;
        this.to.translate(this.lightX, this.lightY);
        this.to.scale(factor, factor);
        this.to.translate(-this.lightX, -this.lightY);
    }

    @Override
    public void drawShadows(FigureEnumeration en, Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform trans = g2.getTransform();
        g2.transform(this.to);
        while (en.hasMoreElements()) {
            Figure next = en.nextFigure();
            next.draw(g);
        }
        g2.setTransform(trans);
    }

    @Override
    public Rectangle transformRectangle(Rectangle r) {
        Point2D c1 = new Point2D.Double(r.getMinX(), r.getMinY());
        Point2D.Double c2 = new Point2D.Double(r.getMaxX(), r.getMaxY());
        c1 = this.to.transform(c1, null);
        Point p = new Point((int)c1.getX(), (int)c1.getY());
        Rectangle rec = new Rectangle(p);
        rec.add(this.to.transform(c2, null));
        return rec;
    }

    @Override
    public void releaseShadowLayouter() {
    }
}

