/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.figures.generic;

import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.AbstractFigure;
import java.awt.Color;
import java.awt.Graphics;
import org.openbp.cockpit.modeler.figures.generic.ChildFigure;
import org.openbp.cockpit.modeler.figures.generic.Colorizable;
import org.openbp.jaspira.decoration.DecorationMgr;

public abstract class BasicFigure
extends AbstractFigure
implements ChildFigure,
Colorizable {
    public static final String DECO_FILLCOLOR = "Figure.FillColor";
    public static final String DECO_OVERLAY = "Figure.Overlay";
    private Color fillColor;
    private transient Figure parent;

    public Object clone() {
        BasicFigure c = (BasicFigure)super.clone();
        c.fillColor = this.fillColor;
        c.parent = this.parent;
        c.displayBox(this.displayBox());
        return c;
    }

    protected Object decorateValue(String key, Object value) {
        return DecorationMgr.decorate(this.getDecorationOwner(), key, value);
    }

    public Object getDecorationOwner() {
        return this.getParent();
    }

    public void draw(Graphics g) {
        Color c = this.getFillColor();
        if (c == null) {
            c = this.getDefaultFillColor();
        }
        if ((c = (Color)this.decorateValue(DECO_FILLCOLOR, c)) != null) {
            Color oldColor = g.getColor();
            g.setColor(c);
            this.drawFigure(g);
            g.setColor(oldColor);
        }
    }

    protected void drawFigure(Graphics g) {
    }

    @Override
    public Figure getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Figure parent) {
        this.parent = parent;
    }

    @Override
    public Color getFillColor() {
        return this.fillColor;
    }

    @Override
    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    @Override
    public Color getDefaultFillColor() {
        return Color.BLACK;
    }
}

