/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.figures.generic;

import CH.ifa.draw.figures.AbstractLineDecoration;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Polygon;
import java.io.IOException;
import org.openbp.common.CommonUtil;

public class XArrowTip
extends AbstractLineDecoration {
    private double angle;
    private double outerRadius;
    private double innerRadius;

    public XArrowTip() {
        this(0.4, 8.0, 8.0);
    }

    public XArrowTip(double angle, double outerRadius, double innerRadius) {
        this.angle = angle;
        this.outerRadius = outerRadius;
        this.innerRadius = innerRadius;
    }

    public Polygon outline(int x1, int y1, int x2, int y2) {
        double direction = 1.5707963267948966 - Math.atan2(x2 - x1, y2 - y1);
        int x = x1;
        int y = y1;
        Polygon shape = new Polygon();
        shape.addPoint(x, y);
        this.addPointRelative(shape, x, y, this.outerRadius, direction - this.angle);
        if (this.innerRadius >= 0.0) {
            this.addPointRelative(shape, x, y, this.innerRadius, direction);
        }
        this.addPointRelative(shape, x, y, this.outerRadius, direction + this.angle);
        shape.addPoint(x, y);
        return shape;
    }

    private void addPointRelative(Polygon shape, int x, int y, double radius, double angle) {
        shape.addPoint(x + CommonUtil.rnd((double)(radius * Math.cos(angle))), y + CommonUtil.rnd((double)(radius * Math.sin(angle))));
    }

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double angle) {
        this.angle = angle;
    }

    public double getOuterRadius() {
        return this.outerRadius;
    }

    public void setOuterRadius(double outerRadius) {
        this.outerRadius = outerRadius;
    }

    public double getInnerRadius() {
        return this.innerRadius;
    }

    public void setInnerRadius(double innerRadius) {
        this.innerRadius = innerRadius;
    }

    public void write(StorableOutput dw) {
        dw.writeDouble(this.angle);
        dw.writeDouble(this.outerRadius);
        dw.writeDouble(this.innerRadius);
        super.write(dw);
    }

    public void read(StorableInput dr) throws IOException {
        this.angle = dr.readDouble();
        this.outerRadius = dr.readDouble();
        this.innerRadius = dr.readDouble();
        super.read(dr);
    }
}

