/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.figures.generic;

import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import org.openbp.cockpit.modeler.figures.generic.CircleConstants;
import org.openbp.cockpit.modeler.figures.generic.Quarter;
import org.openbp.cockpit.modeler.figures.generic.XPolygonFigure;
import org.openbp.common.CommonUtil;

public class XDiamondFigure
extends XPolygonFigure {
    public static final double TOLERANCE = 0.2;

    @Override
    public Rectangle placeAdjacent(Rectangle rect, double angle) {
        double b = this.box.getWidth() / 2.0 + 2.0;
        double h = this.box.getHeight() / 2.0 + 2.0;
        double recHeight = rect.getHeight();
        double recWidth = rect.getWidth();
        double x = 0.0;
        double y = 0.0;
        double recX = 0.0;
        double recY = 0.0;
        double normalizedAngle = this.convertToStandardAngle(angle);
        if (6.083185307179586 < normalizedAngle || normalizedAngle < 0.2) {
            recX = b;
            recY = recHeight / 2.0;
        } else if (1.3707963267948966 < normalizedAngle && normalizedAngle < 1.7707963267948965) {
            recX = -recWidth / 2.0;
            recY = h + recHeight;
        } else if (2.941592653589793 < normalizedAngle && normalizedAngle < 3.3415926535897933) {
            recX = -b - recWidth;
            recY = recHeight / 2.0;
        } else if (4.5123889803846895 < normalizedAngle && normalizedAngle < 4.91238898038469) {
            recX = -recWidth / 2.0;
            recY = -h;
        } else {
            Quarter quarter = CircleConstants.determineQuarter(angle, rect);
            double tana = Math.tan(normalizedAngle);
            switch (quarter) {
                case NE: {
                    x = b * h / (b * tana + h);
                    y = h * (1.0 - h / (b * tana + h));
                    recX = x;
                    recY = y + recHeight;
                    break;
                }
                case NW: {
                    x = b * h / (b * tana - h);
                    y = h * (1.0 + h / (b * tana - h));
                    recX = x - recWidth;
                    recY = y + recHeight;
                    break;
                }
                case SW: {
                    x = -(b * h) / (b * tana + h);
                    y = -h * (1.0 - h / (b * tana + h));
                    recX = x - recWidth;
                    recY = y;
                    break;
                }
                case SE: {
                    x = -(b * h) / (b * tana - h);
                    y = -h * (1.0 + h / (b * tana - h));
                    recX = x;
                    recY = y;
                }
            }
        }
        Point c = this.center();
        int xPos = c.x + CommonUtil.rnd((double)recX);
        int yPos = c.y - CommonUtil.rnd((double)recY);
        rect.setLocation(xPos, yPos);
        return rect;
    }

    @Override
    public Polygon getPolygon() {
        if (this.polygon == null) {
            Rectangle r = this.box;
            this.polygon = new Polygon();
            this.polygon.addPoint(r.x + r.width / 2, r.y);
            this.polygon.addPoint(r.x, r.y + r.height / 2);
            this.polygon.addPoint(r.x + r.width / 2, r.y + r.height);
            this.polygon.addPoint(r.x + r.width, r.y + r.height / 2);
        }
        return this.polygon;
    }

    public double convertToStandardAngle(double angle) {
        return Math.PI * 2 - angle;
    }
}

