/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.figures.generic;

import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeEvent;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.StringTokenizer;
import java.util.Vector;
import org.openbp.cockpit.modeler.figures.generic.BasicFigure;
import org.openbp.common.CollectionUtil;
import org.openbp.common.CommonUtil;
import org.openbp.swing.SwingUtil;

public class XTextFigure
extends BasicFigure {
    public static final int HANDLE_DISTANCE = 5;
    private String text;
    private Font font = new Font("Helvetica", 0, 12);
    protected int originX;
    protected int originY;
    private int alignment;
    private boolean autoSize;
    protected Rectangle displayBoxCache;

    protected void basicMoveBy(int x, int y) {
        this.originX += x;
        this.originY += y;
        if (this.autoSize) {
            this.displayBoxCache = null;
        } else if (this.displayBoxCache != null) {
            this.displayBoxCache.x += x;
            this.displayBoxCache.y += y;
        }
    }

    public void basicDisplayBox(Point newOrigin, Point newCorner) {
        this.originX = newOrigin.x;
        this.originY = newOrigin.y;
        this.displayBoxCache = this.autoSize ? null : new Rectangle(newOrigin.x, newOrigin.y, newCorner.x - newOrigin.x, newCorner.y - newOrigin.y);
    }

    public Rectangle displayBox() {
        if (this.displayBoxCache == null) {
            this.displayBoxCache = new Rectangle(this.originX, this.originY, 0, 0);
            if (this.autoSize) {
                FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(this.font);
                SwingUtil.computeMultilineStringBounds((FontMetrics)fm, (String)this.text, (int)this.alignment, (Rectangle)this.displayBoxCache);
            }
        }
        return new Rectangle(this.displayBoxCache);
    }

    @Override
    protected void drawFigure(Graphics g) {
        g.setFont(this.font);
        Rectangle db = this.displayBox();
        SwingUtil.drawMultilineString((Graphics)g, (String)this.text, (int)this.alignment, (Rectangle)db, (boolean)true);
    }

    public void invalidate() {
        if (this.listener() != null) {
            Rectangle r = this.displayBox();
            r.grow(13, 13);
            this.listener().figureInvalidated(new FigureChangeEvent((Figure)this, r));
        }
    }

    public Vector handles() {
        return CollectionUtil.EMPTY_VECTOR;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        if (!CommonUtil.equalsNull((Object)text, (Object)this.text)) {
            this.willChange();
            this.text = text;
            if (this.autoSize) {
                this.displayBoxCache = null;
            }
            this.changed();
        }
    }

    public int getFontSize() {
        Font font = this.getFont();
        return font.getSize();
    }

    public void setFontSize(int fontSize) {
        Font font = this.getFont();
        this.setFont(new Font(font.getName(), font.getStyle(), fontSize));
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.willChange();
        this.font = font;
        if (this.autoSize) {
            this.displayBoxCache = null;
        }
        this.changed();
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    public boolean isAutoSize() {
        return this.autoSize;
    }

    public void setAutoSize(boolean autoSize) {
        this.autoSize = autoSize;
    }

    public void parseGeometry(String geometry) {
        if (geometry == null) {
            return;
        }
        StringTokenizer tok = new StringTokenizer(geometry, "|");
        while (tok.hasMoreTokens()) {
            this.parseParameter(tok.nextToken());
        }
    }

    protected void parseParameter(String parameter) {
        StringTokenizer inner = new StringTokenizer(parameter, ":");
        try {
            String paramName = inner.nextToken();
            if (paramName.equals("rect")) {
                int x = Integer.parseInt(inner.nextToken());
                int y = Integer.parseInt(inner.nextToken());
                int w = Integer.parseInt(inner.nextToken());
                int h = Integer.parseInt(inner.nextToken());
                Rectangle db = new Rectangle(x, y, w, h);
                this.displayBox(db);
            } else if (paramName.equals("fillcolor")) {
                int r = Integer.parseInt(inner.nextToken());
                int g = Integer.parseInt(inner.nextToken());
                int b = Integer.parseInt(inner.nextToken());
                this.setFillColor(new Color(r, g, b));
            } else if (paramName.equals("fontsize")) {
                int s = Integer.parseInt(inner.nextToken());
                this.setFontSize(s);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String createGeometry() {
        int fontSize;
        Rectangle db = this.displayBox();
        String geometry = "rect:" + db.x + ":" + db.y + ":" + db.width + ":" + db.height;
        Color c = this.getFillColor();
        if (c != null && !c.equals(this.getDefaultFillColor())) {
            geometry = geometry + "|fillcolor:" + c.getRed() + ":" + c.getGreen() + ":" + c.getBlue();
        }
        if ((fontSize = this.getFontSize()) != 12) {
            geometry = geometry + "|fontsize:" + fontSize;
        }
        return geometry;
    }
}

