/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.figures.generic;

import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import org.openbp.cockpit.modeler.figures.generic.CircleConstants;
import org.openbp.cockpit.modeler.figures.generic.Orientation;
import org.openbp.cockpit.modeler.figures.generic.XPolygonFigure;
import org.openbp.common.CommonUtil;

public class XTriangleFigure
extends XPolygonFigure {
    private static final int SECTOR_N = 0;
    private static final int SECTOR_NE = 1;
    private static final int SECTOR_SE = 2;
    private static final int SECTOR_S = 3;
    private static final int SECTOR_SW = 4;
    private static final int SECTOR_NW = 5;

    @Override
    public Rectangle placeAdjacent(Rectangle rect, double angle) {
        double xRectCenter = rect.getWidth() / 2.0;
        double yRectCenter = rect.getHeight() / 2.0;
        double boxCenter = this.box.getWidth() / 2.0 + 2.0;
        double alpha = Math.atan((boxCenter - yRectCenter) / (boxCenter + xRectCenter));
        double beta = Math.atan((boxCenter + yRectCenter) / (boxCenter + xRectCenter));
        double gamma = Math.atan(xRectCenter / (boxCenter + yRectCenter));
        alpha = Math.abs(alpha);
        beta = Math.abs(beta);
        gamma = Math.abs(gamma);
        alpha = CircleConstants.normalizeAngle(alpha);
        beta = CircleConstants.normalizeAngle(beta);
        gamma = CircleConstants.normalizeAngle(gamma);
        Orientation orientation = this.getOrientation();
        int sector = orientation == Orientation.BOTTOM ? (angle < 1.5707963267948966 - gamma || angle > Math.PI * 2 - alpha ? 2 : (angle < 1.5707963267948966 + gamma ? 3 : (angle < Math.PI + alpha ? 4 : (angle < Math.PI + beta ? 5 : (angle < Math.PI * 2 - beta ? 0 : 1))))) : (angle < alpha || angle > 4.71238898038469 + gamma ? 1 : (angle < beta ? 2 : (angle < Math.PI - beta ? 3 : (angle < Math.PI - alpha ? 4 : (angle < 4.71238898038469 - gamma ? 5 : 0)))));
        double x = 0.0;
        double y = 0.0;
        double tana = Math.tan(angle);
        if (orientation == Orientation.BOTTOM) {
            switch (sector) {
                case 0: {
                    x = -((boxCenter + yRectCenter) / tana);
                    y = -(boxCenter + yRectCenter);
                    break;
                }
                case 1: {
                    x = boxCenter + xRectCenter;
                    y = tana * (boxCenter + xRectCenter);
                    break;
                }
                case 2: {
                    double temp;
                    x = temp = (boxCenter + yRectCenter + 2.0 * xRectCenter) / (2.0 + tana);
                    y = temp * tana;
                    break;
                }
                case 3: {
                    x = (boxCenter + yRectCenter) / tana;
                    y = boxCenter + yRectCenter;
                    break;
                }
                case 4: {
                    double temp;
                    x = temp = (boxCenter + yRectCenter + 2.0 * xRectCenter) / (-2.0 + tana);
                    y = temp * tana;
                    break;
                }
                case 5: {
                    x = -(boxCenter + xRectCenter);
                    y = -(tana * (boxCenter + xRectCenter));
                }
            }
        } else {
            switch (sector) {
                case 0: {
                    x = -((boxCenter + yRectCenter) / tana);
                    y = -(boxCenter + yRectCenter);
                    break;
                }
                case 2: {
                    x = boxCenter + xRectCenter;
                    y = tana * (boxCenter + xRectCenter);
                    break;
                }
                case 1: {
                    double temp;
                    x = temp = -(boxCenter + yRectCenter + 2.0 * xRectCenter) / (-2.0 + tana);
                    y = temp * tana;
                    break;
                }
                case 3: {
                    x = (boxCenter + yRectCenter) / tana;
                    y = boxCenter + yRectCenter;
                    break;
                }
                case 5: {
                    double temp;
                    x = temp = -(boxCenter + yRectCenter + 2.0 * xRectCenter) / (2.0 + tana);
                    y = temp * tana;
                    break;
                }
                case 4: {
                    x = -(boxCenter + xRectCenter);
                    y = -(tana * (boxCenter + xRectCenter));
                }
            }
        }
        Point c = this.center();
        int xPos = c.x + CommonUtil.rnd((double)(x - xRectCenter)) + 1;
        int yPos = c.y + CommonUtil.rnd((double)(y - yRectCenter)) + 2;
        rect.setLocation(xPos, yPos);
        return rect;
    }

    @Override
    public Polygon getPolygon() {
        if (this.polygon == null) {
            Rectangle r = this.box;
            this.polygon = new Polygon();
            Orientation orientation = this.getOrientation();
            switch (orientation) {
                case BOTTOM: {
                    this.polygon.addPoint(r.x + r.width / 2, r.y + r.height);
                    this.polygon.addPoint(r.x, r.y);
                    this.polygon.addPoint(r.x + r.width, r.y);
                    break;
                }
                case LEFT: {
                    this.polygon.addPoint(r.x, r.y + r.height / 2);
                    this.polygon.addPoint(r.x + r.width, r.y);
                    this.polygon.addPoint(r.x + r.width, r.y + r.height);
                    break;
                }
                case TOP: {
                    this.polygon.addPoint(r.x + r.width / 2, r.y);
                    this.polygon.addPoint(r.x + r.width, r.y + r.height);
                    this.polygon.addPoint(r.x, r.y + r.height);
                    break;
                }
                case RIGHT: {
                    this.polygon.addPoint(r.x + r.width, r.y + r.height / 2);
                    this.polygon.addPoint(r.x, r.y + r.height);
                    this.polygon.addPoint(r.x, r.y);
                }
            }
        }
        return this.polygon;
    }
}

