/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.figures.layouter;

import java.awt.Insets;
import java.awt.Rectangle;
import org.openbp.cockpit.modeler.figures.layouter.AbstractTagLayouter;
import org.openbp.cockpit.modeler.figures.layouter.HorizontalLayouter;
import org.openbp.cockpit.modeler.figures.layouter.TagLayouter;
import org.openbp.cockpit.modeler.figures.layouter.VerticalLayouter;
import org.openbp.cockpit.modeler.figures.tag.AbstractTagFigure;

public class MultiplexLayouter
extends AbstractTagLayouter {
    private TagLayouter activeLayouter;
    private TagLayouter[] subLayouters;
    private int[] directionMapper;
    private static final int NUMBER_OF_LAYOUTERS_PER_CIRCLE = 8;

    public MultiplexLayouter(AbstractTagFigure tagFigure) {
        super(tagFigure);
    }

    public void setLayouter(int begin, int end, TagLayouter layouter, int mappedDir) {
        if (end < begin) {
            this.setLayouter(begin, 8, layouter, mappedDir);
            this.setLayouter(0, end, layouter, mappedDir);
        } else {
            for (int i = begin; i < end; ++i) {
                this.setLayouter(i, layouter, mappedDir);
            }
        }
    }

    public void setLayouter(int dir, TagLayouter layouter, int mappedDir) {
        if (layouter != null) {
            this.subLayouters[dir] = layouter;
        }
        this.directionMapper[dir] = mappedDir;
    }

    @Override
    public void setupLayouter() {
        this.subLayouters = new TagLayouter[8];
        this.directionMapper = new int[8];
        HorizontalLayouter l = new HorizontalLayouter(this.tagFigure);
        for (int i = 0; i < 8; ++i) {
            this.subLayouters[i] = l;
            this.directionMapper[i] = i;
        }
    }

    @Override
    public void applyDirection() {
        this.activeLayouter = this.subLayouters[this.direction];
        this.activeLayouter.setDirection(this.directionMapper[this.direction]);
    }

    @Override
    public boolean isVerticalLayouter() {
        return this.getActiveLayouter().isVerticalLayouter();
    }

    @Override
    public Rectangle calculateSize() {
        return this.getActiveLayouter().calculateSize();
    }

    @Override
    public void performLayout(Rectangle box) {
        this.getActiveLayouter().performLayout(box);
    }

    @Override
    public void setInsets(Insets insets) {
        for (int i = 0; i < 8; ++i) {
            this.subLayouters[i].setInsets(insets);
        }
    }

    @Override
    public Insets getInsets() {
        return this.getActiveLayouter().getInsets();
    }

    public TagLayouter getActiveLayouter() {
        if (this.activeLayouter == null) {
            this.applyDirection();
        }
        return this.activeLayouter;
    }

    public static MultiplexLayouter getStraightInstance(AbstractTagFigure tag) {
        MultiplexLayouter result = new MultiplexLayouter(tag);
        result.setLayouter(7, null, 0);
        result.setLayouter(0, null, 0);
        result.setLayouter(3, null, 4);
        result.setLayouter(4, null, 4);
        VerticalLayouter vertical = new VerticalLayouter(tag);
        result.setLayouter(1, vertical, 2);
        result.setLayouter(2, vertical, 2);
        result.setLayouter(5, vertical, 6);
        result.setLayouter(6, vertical, 6);
        return result;
    }

    public static MultiplexLayouter getLeftRightInstance(AbstractTagFigure tag) {
        MultiplexLayouter result = new MultiplexLayouter(tag);
        result.setLayouter(6, 2, null, 0);
        result.setLayouter(2, 6, null, 4);
        return result;
    }

    public static MultiplexLayouter getUpDownInstance(AbstractTagFigure tag) {
        MultiplexLayouter result = new MultiplexLayouter(tag);
        VerticalLayouter vertical = new VerticalLayouter(tag);
        result.setLayouter(0, 4, vertical, 2);
        result.setLayouter(4, 0, vertical, 6);
        return result;
    }

    public static MultiplexLayouter getRadialInstance(AbstractTagFigure tag) {
        MultiplexLayouter result = new MultiplexLayouter(tag);
        VerticalLayouter vertical = new VerticalLayouter(tag);
        result.setLayouter(0, null, 0);
        result.setLayouter(7, vertical, 6);
        result.setLayouter(6, vertical, 6);
        result.setLayouter(5, null, 4);
        result.setLayouter(4, null, 4);
        result.setLayouter(3, vertical, 2);
        result.setLayouter(2, vertical, 2);
        result.setLayouter(1, null, 0);
        return result;
    }

    public static MultiplexLayouter getRadialInstance2(AbstractTagFigure tag) {
        MultiplexLayouter result = new MultiplexLayouter(tag);
        VerticalLayouter vertical = new VerticalLayouter(tag);
        result.setLayouter(0, vertical, 6);
        result.setLayouter(7, null, 0);
        result.setLayouter(6, null, 4);
        result.setLayouter(5, vertical, 6);
        result.setLayouter(4, vertical, 2);
        result.setLayouter(3, null, 4);
        result.setLayouter(2, null, 0);
        result.setLayouter(1, vertical, 2);
        return result;
    }
}

