/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.figures.process;

import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeListener;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.CompositeFigure;
import CH.ifa.draw.standard.TextHolder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseEvent;
import java.awt.geom.RectangularShape;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import org.openbp.cockpit.modeler.ModelerColors;
import org.openbp.cockpit.modeler.ModelerGraphics;
import org.openbp.cockpit.modeler.drawing.ProcessDrawing;
import org.openbp.cockpit.modeler.drawing.WorkspaceDrawingView;
import org.openbp.cockpit.modeler.figures.VisualElement;
import org.openbp.cockpit.modeler.figures.VisualElementEvent;
import org.openbp.cockpit.modeler.figures.generic.CircleConstants;
import org.openbp.cockpit.modeler.figures.generic.Expandable;
import org.openbp.cockpit.modeler.figures.generic.FixedTitleFigure;
import org.openbp.cockpit.modeler.figures.generic.GeometryException;
import org.openbp.cockpit.modeler.figures.generic.GeometryUtil;
import org.openbp.cockpit.modeler.figures.generic.MoveableTitleFigure;
import org.openbp.cockpit.modeler.figures.generic.Orientation;
import org.openbp.cockpit.modeler.figures.generic.ShadowDropper;
import org.openbp.cockpit.modeler.figures.generic.SimpleImageFigure;
import org.openbp.cockpit.modeler.figures.generic.UpdatableFigure;
import org.openbp.cockpit.modeler.figures.generic.XFigure;
import org.openbp.cockpit.modeler.figures.process.ProcessElementContainer;
import org.openbp.cockpit.modeler.figures.process.SocketFigure;
import org.openbp.cockpit.modeler.figures.tag.AbstractTagFigure;
import org.openbp.cockpit.modeler.figures.tag.SimpleTextTagFigure;
import org.openbp.cockpit.modeler.skins.SymbolDescriptor;
import org.openbp.cockpit.modeler.util.FigureResources;
import org.openbp.cockpit.modeler.util.FigureUtil;
import org.openbp.cockpit.modeler.util.ModelerFlavors;
import org.openbp.common.CollectionUtil;
import org.openbp.common.MsgFormat;
import org.openbp.common.generic.description.DisplayObject;
import org.openbp.common.logger.LogUtil;
import org.openbp.common.rc.ResourceCollection;
import org.openbp.common.string.StringUtil;
import org.openbp.common.util.ToStringHelper;
import org.openbp.core.model.ModelObject;
import org.openbp.core.model.item.process.MultiSocketNode;
import org.openbp.core.model.item.process.Node;
import org.openbp.core.model.item.process.NodeSocket;
import org.openbp.core.model.item.process.ProcessObject;
import org.openbp.core.model.item.process.ProcessUtil;
import org.openbp.core.model.item.process.SingleSocketNode;
import org.openbp.core.model.item.process.WorkflowNode;
import org.openbp.core.model.item.type.DataTypeItem;
import org.openbp.guiclient.model.item.ItemIconMgr;
import org.openbp.guiclient.util.ClientFlavors;
import org.openbp.jaspira.decoration.DecorationMgr;
import org.openbp.jaspira.gui.interaction.DropClientUtil;
import org.openbp.jaspira.gui.interaction.InteractionClient;
import org.openbp.jaspira.gui.interaction.ViewDropRegion;
import org.openbp.swing.SwingUtil;
import org.openbp.swing.components.JMsgBox;

public abstract class NodeFigure
extends CompositeFigure
implements FigureChangeListener,
ShadowDropper,
Expandable,
ProcessElementContainer,
TextHolder {
    public static final int ROTATE_CW = 1;
    public static final int ROTATE_CCW = 2;
    public static final String REGION_TYPE = "DataTypeRegionId";
    protected Node node;
    protected XFigure presentationFigure;
    protected Figure iconFigure;
    protected Figure iconOverlayFigure;
    protected XFigure shadowFigure;
    private FixedTitleFigure fixedTitleFigure;
    private SimpleTextTagFigure rotatingTitleFigure;
    protected Rectangle displayBox;
    private int visualStatus = 1;
    private boolean createdFromScratch;
    private ProcessDrawing drawing;

    public Object clone() {
        NodeFigure copy = null;
        try {
            copy = (NodeFigure)this.getClass().newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Cannot clone object of class '" + this.getClass() + ".");
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Cannot clone object of class '" + this.getClass() + ".");
        }
        if (this.getNode() != null && this.getDrawing() != null) {
            copy.connect(this.getNode(), this.getDrawing());
        }
        return copy;
    }

    public void connect(Node node, ProcessDrawing drawing) {
        this.node = node;
        this.drawing = drawing;
        node.setRepresentation((Object)this);
        this.initialize();
    }

    public String toString() {
        return ToStringHelper.toString((Object)this, (String)"node");
    }

    protected void initialize() {
        int h;
        this.initPresentationFigure();
        this.initSockets();
        Rectangle box = this.presentationFigure.displayBox();
        int w = box.width;
        if (w == 0) {
            w = this.presentationFigure.getDescriptor().getSizeX();
        }
        if ((h = box.height) == 0) {
            h = this.presentationFigure.getDescriptor().getSizeX();
        }
        this.setSize(w, h);
        this.decodeGeometry();
        this.updateFigure();
        this.init(this.displayBox());
    }

    protected void initPresentationFigure() {
        SymbolDescriptor desc = FigureUtil.getSymbolDescriptorForModelObject(this.getDrawing().getProcessSkin(), (ModelObject)this.node);
        this.presentationFigure = desc.createFigure();
        this.presentationFigure.setParent(this);
        this.initShadow();
        String textPosition = ((SymbolDescriptor)this.presentationFigure.getDescriptor()).getTextPosition();
        this.initTextFigure(textPosition);
    }

    protected void initTextFigure(String textPosition) {
        if (this.fixedTitleFigure != null) {
            this.fixedTitleFigure = null;
        }
        if (this.rotatingTitleFigure != null) {
            this.remove(this.rotatingTitleFigure);
            this.rotatingTitleFigure = null;
        }
        if (textPosition == null || textPosition.equals("c")) {
            this.fixedTitleFigure = new FixedTitleFigure((DisplayObject)this.node);
            this.fixedTitleFigure.setVerboseDisplay(true);
            this.fixedTitleFigure.setParent(this);
        } else {
            this.rotatingTitleFigure = new SimpleTextTagFigure(this, null);
            MoveableTitleFigure titleFigure = new MoveableTitleFigure((DisplayObject)this.node);
            titleFigure.setVerboseDisplay(true);
            this.rotatingTitleFigure.addContent(titleFigure, 2);
            this.rotatingTitleFigure.setContentState(2);
            this.add(this.rotatingTitleFigure);
            double angle = ProcessUtil.determineAngle((String)textPosition);
            this.rotatingTitleFigure.setAngle(angle);
        }
    }

    protected void initIcon() {
        Icon icon = this.determineCustomIcon();
        if (icon == null && !((SymbolDescriptor)this.presentationFigure.getDescriptor()).isImageDisabled()) {
            icon = this.determineCenterIcon();
        }
        if (icon != null) {
            this.setIconFigure((Figure)new SimpleImageFigure(icon));
        } else {
            this.setIconFigure(null);
        }
    }

    protected Icon determineCustomIcon() {
        Icon icon = null;
        String customImagePath = this.determineCustomIconPath();
        if (customImagePath != null) {
            String id = this.node.getOwningModel().getQualifier().toString() + "." + customImagePath;
            icon = ItemIconMgr.getInstance().getIcon(id, 48);
            if (icon == null) {
                String pathName = StringUtil.absolutePathName((String)StringUtil.buildPath((String)this.node.getOwningModel().getModelPath(), (String)customImagePath));
                if (new File(pathName).exists()) {
                    icon = new ImageIcon(pathName, null);
                    ItemIconMgr.getInstance().registerIcon(id, icon);
                } else {
                    LogUtil.error(this.getClass(), (String)("Image file '" + pathName + "' for node '" + this.node.getQualifier() + "' does not exist."));
                }
            }
        }
        return icon;
    }

    protected String determineCustomIconPath() {
        MultiSocketNode msNode;
        String customImagePath = null;
        if (this.node instanceof MultiSocketNode && (msNode = (MultiSocketNode)this.node).getImagePath() != null) {
            customImagePath = msNode.getImagePath();
        }
        return customImagePath;
    }

    protected Icon determineCenterIcon() {
        return null;
    }

    protected void initSockets() {
        Iterator it = this.node.getSockets();
        while (it.hasNext()) {
            this.addSocket((NodeSocket)it.next());
        }
        this.layoutUnarrangedSockets();
    }

    protected void initShadow() {
        this.shadowFigure = FigureUtil.createShadowFigure(this.presentationFigure);
    }

    public SocketFigure addSocket(NodeSocket socket) {
        SocketFigure socketFigure = new SocketFigure(this, socket);
        this.add(socketFigure);
        return socketFigure;
    }

    protected void layoutUnarrangedSockets() {
        LinkedList<SocketFigure> entriesToLayout = null;
        LinkedList<SocketFigure> exitsToLayout = null;
        LinkedList<SocketFigure> othersToLayout = null;
        FigureEnumeration fe = this.figures();
        while (fe.hasMoreElements()) {
            SocketFigure socketFigure;
            NodeSocket socket;
            String geometry;
            Figure f = fe.nextFigure();
            if (!(f instanceof SocketFigure) || (geometry = (socket = (socketFigure = (SocketFigure)f).getNodeSocket()).getGeometry()) != null && geometry.indexOf("angle") >= 0) continue;
            if (socket.getNode() instanceof WorkflowNode && socket.isExitSocket() && socket.getName().equals("TaskPublished")) {
                if (othersToLayout == null) {
                    othersToLayout = new LinkedList<SocketFigure>();
                }
                othersToLayout.add(socketFigure);
                continue;
            }
            if (socketFigure.isEntrySocket()) {
                if (entriesToLayout == null) {
                    entriesToLayout = new LinkedList<SocketFigure>();
                }
                entriesToLayout.add(socketFigure);
                continue;
            }
            if (exitsToLayout == null) {
                exitsToLayout = new LinkedList<SocketFigure>();
            }
            exitsToLayout.add(socketFigure);
        }
        this.layoutSockets(entriesToLayout, "n");
        this.layoutSockets(exitsToLayout, "s");
        this.layoutSockets(othersToLayout, "e");
    }

    protected void layoutSockets(List socketsToLayout, String orientation) {
        int yTo;
        int yFrom;
        int xTo;
        int xFrom;
        if (socketsToLayout == null) {
            return;
        }
        Rectangle nodeRect = this.compactDisplayBox();
        if ("n".equals(orientation)) {
            xFrom = nodeRect.x;
            xTo = nodeRect.x + nodeRect.width;
            yFrom = nodeRect.y;
            yTo = nodeRect.y;
        } else if ("s".equals(orientation)) {
            xFrom = nodeRect.x;
            xTo = nodeRect.x + nodeRect.width;
            yFrom = nodeRect.y + nodeRect.height;
            yTo = nodeRect.y + nodeRect.height;
        } else if ("w".equals(orientation)) {
            yFrom = nodeRect.y;
            yTo = nodeRect.y + nodeRect.height;
            xFrom = nodeRect.x;
            xTo = nodeRect.x;
        } else {
            yFrom = nodeRect.y;
            yTo = nodeRect.y + nodeRect.height;
            xFrom = nodeRect.x + nodeRect.width;
            xTo = nodeRect.x + nodeRect.width;
        }
        int n = socketsToLayout.size();
        int xDist = (xTo - xFrom) / (n * 2);
        int yDist = (yTo - yFrom) / (n * 2);
        int x = xFrom + xDist;
        int y = yFrom + yDist;
        Point center = this.center();
        for (int i = 0; i < n; ++i) {
            SocketFigure socketFigure = (SocketFigure)socketsToLayout.get(i);
            int xRelative = x - center.x;
            int yRelative = y - center.y;
            double angle = Math.atan2(yRelative, xRelative);
            angle = this.findAvailableAngle(angle);
            socketFigure.setAngle(angle);
            x += 2 * xDist;
            y += 2 * yDist;
        }
    }

    private double findAvailableAngle(double angle) {
        boolean loop = true;
        block0: while (loop) {
            loop = false;
            FigureEnumeration fe = this.figures();
            while (fe.hasMoreElements()) {
                double sa;
                SocketFigure socketFigure;
                String geometry;
                boolean arranged;
                Figure f = fe.nextFigure();
                if (!(f instanceof SocketFigure) || !(arranged = (geometry = (socketFigure = (SocketFigure)f).getNodeSocket().getGeometry()) != null && geometry.indexOf("angle") >= 0) || !(angle >= (sa = socketFigure.getAngle()) - 0.011) || !(angle <= sa + 0.011)) continue;
                angle += 0.3141592653589793;
                loop = true;
                continue block0;
            }
        }
        return angle;
    }

    public boolean isVerticallyOriented() {
        SocketFigure socketFigure;
        Orientation orientation;
        NodeSocket socket = null;
        if (this.node instanceof MultiSocketNode) {
            socket = ((MultiSocketNode)this.node).getDefaultEntrySocket();
        } else if (this.node instanceof SingleSocketNode) {
            socket = ((SingleSocketNode)this.node).getSocket();
        }
        return socket != null && ((orientation = CircleConstants.determineOrientation((socketFigure = this.getSocket(socket)).getAngle(), this.displayBox())) == Orientation.TOP || orientation == Orientation.BOTTOM);
    }

    public void flipOrientation() {
        boolean vertical = this.isVerticallyOriented();
        this.willChange();
        FigureEnumeration fe = this.figures();
        while (fe.hasMoreElements()) {
            Figure f = fe.nextFigure();
            if (!(f instanceof AbstractTagFigure)) continue;
            AbstractTagFigure tagFigure = (AbstractTagFigure)f;
            double angle = tagFigure.getAngle();
            angle = vertical ? Math.PI * 2 - angle : Math.PI - angle;
            angle = CircleConstants.normalizeAngle(angle);
            tagFigure.setAngle(angle);
        }
        this.changed();
    }

    public void changeOrientation(int mode) {
        this.willChange();
        FigureEnumeration fe = this.figures();
        while (fe.hasMoreElements()) {
            Figure f = fe.nextFigure();
            if (!(f instanceof AbstractTagFigure)) continue;
            AbstractTagFigure tagFigure = (AbstractTagFigure)f;
            double angle = tagFigure.getAngle();
            angle = (mode & 1) != 0 ? (angle += 1.5707963267948966) : (angle -= 1.5707963267948966);
            angle = CircleConstants.normalizeAngle(angle);
            tagFigure.setAngle(angle);
        }
        this.changed();
    }

    public Node getNode() {
        return this.node;
    }

    public SocketFigure getSocket(NodeSocket socket) {
        FigureEnumeration fe = this.figures();
        while (fe.hasMoreElements()) {
            SocketFigure socketFigure;
            Figure f = fe.nextFigure();
            if (!(f instanceof SocketFigure) || !(socketFigure = (SocketFigure)f).getNodeSocket().equals(socket)) continue;
            return socketFigure;
        }
        return null;
    }

    public SocketFigure getConnectableSocket(boolean isEntry) {
        NodeSocket socket = this.node.getConnectableSocket(isEntry);
        if (socket != null) {
            return (SocketFigure)socket.getRepresentation();
        }
        return null;
    }

    protected void removeConnections() {
        FigureEnumeration fe = this.figures();
        while (fe.hasMoreElements()) {
            Figure f = fe.nextFigure();
            if (!(f instanceof SocketFigure)) continue;
            ((SocketFigure)f).removeConnections();
        }
    }

    public void decodeGeometry() {
        if (this.node.getGeometry() == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(this.node.getGeometry(), "|");
        while (st.hasMoreTokens()) {
            this.decodeParameter(st.nextToken());
        }
    }

    protected void decodeParameter(String parameter) {
        StringTokenizer st = new StringTokenizer(parameter, ":");
        String errIdent = this.node.getQualifier().toUntypedString();
        String paramName = st.nextToken();
        if (paramName.equals("origin")) {
            int x = GeometryUtil.parseInt(st, paramName, errIdent);
            int y = GeometryUtil.parseInt(st, paramName, errIdent);
            Point p = new Point(x, y);
            this.displayBox(p, p);
        } else if (paramName.equals("size")) {
            int x;
            int y = x = GeometryUtil.parseInt(st, paramName, errIdent);
            if (st.hasMoreTokens()) {
                y = GeometryUtil.parseInt(st, paramName, errIdent);
            }
            this.setSize(x, y);
        } else if (paramName.equals("nameangle")) {
            if (this.rotatingTitleFigure != null) {
                this.rotatingTitleFigure.setAngle(GeometryUtil.parseAngle(st, paramName, errIdent));
            }
        } else if (paramName.equals("fillcolor")) {
            this.setFillColor(GeometryUtil.parseColor(st, paramName, errIdent));
        } else {
            throw new GeometryException("Unknown paramter '" + paramName + "'.", errIdent);
        }
    }

    public void encodeGeometry() {
        Color c;
        Rectangle box = this.presentationFigure.displayBox();
        String geometry = "origin:" + this.center().x + ":" + this.center().y + "|size:" + box.width;
        if (box.height != box.width) {
            geometry = geometry + ":" + box.height;
        }
        if ((c = this.getFillColor()) != null) {
            geometry = geometry + "|fillcolor:" + c.getRed() + ":" + c.getGreen() + ":" + c.getBlue();
        }
        if (this.rotatingTitleFigure != null) {
            geometry = geometry + "|nameangle:" + GeometryUtil.printAngle(this.rotatingTitleFigure.getAngle());
        }
        this.node.setGeometry(geometry);
        FigureEnumeration fe = this.figures();
        while (fe.hasMoreElements()) {
            Figure f = fe.nextFigure();
            if (!(f instanceof SocketFigure)) continue;
            ((SocketFigure)f).encodeGeometry();
        }
    }

    public Rectangle displayBox() {
        Rectangle db = this.presentationFigure.displayBox();
        FigureEnumeration fe = this.figures();
        while (fe.hasMoreElements()) {
            Figure f = fe.nextFigure();
            Rectangle kind = f.displayBox();
            db = db.union(kind);
        }
        return db;
    }

    public void basicDisplayBox(Point newOrigin, Point newCorner) {
        Rectangle rect = new Rectangle(newOrigin);
        rect.add(newCorner);
        this.basicMoveBy((int)rect.getCenterX() - this.center().x, (int)rect.getCenterY() - this.center().y);
    }

    protected void basicMoveBy(int dx, int dy) {
        this.presentationFigure.moveBy(dx, dy);
        if (this.iconFigure != null) {
            this.iconFigure.moveBy(dx, dy);
        }
        if (this.iconOverlayFigure != null) {
            this.iconOverlayFigure.moveBy(dx, dy);
        }
        if (this.fixedTitleFigure != null) {
            this.fixedTitleFigure.moveBy(dx, dy);
        }
        this.translateChildren(dx, dy);
        if (this.shadowFigure != null) {
            this.shadowFigure.moveBy(dx, dy);
        }
    }

    public Vector handles() {
        Vector v = null;
        FigureEnumeration fe = this.figures();
        while (fe.hasMoreElements()) {
            Figure f = fe.nextFigure();
            Vector subHandles = f.handles();
            if (subHandles.size() <= 0) continue;
            if (v == null) {
                v = new Vector();
            }
            v.addAll(subHandles);
        }
        return v != null ? v : CollectionUtil.EMPTY_VECTOR;
    }

    public void draw(Graphics g) {
        if (this.isVisible()) {
            super.draw(g);
            if (this.isPresentationFigureVisible()) {
                this.presentationFigure.draw(g);
            } else {
                this.drawSelectionMarker(g);
            }
            if (this.iconFigure != null) {
                this.iconFigure.draw(g);
            }
            if (this.iconOverlayFigure != null) {
                this.iconOverlayFigure.draw(g);
            }
            if (this.fixedTitleFigure != null) {
                this.fixedTitleFigure.draw(g);
            }
        }
    }

    protected boolean isPresentationFigureVisible() {
        return !(this.node instanceof MultiSocketNode) || !((MultiSocketNode)this.node).isImageOnly();
    }

    protected void drawSelectionMarker(Graphics g) {
        Stroke stroke;
        Color c = (Color)DecorationMgr.decorate(this, "Figure.FrameColor", null);
        if (c != null && (stroke = (Stroke)DecorationMgr.decorate(this, "Figure.FrameStroke", FigureResources.standardStroke1)) != null) {
            Graphics2D g2 = (Graphics2D)g;
            Color oldColor = g.getColor();
            g2.setColor(c);
            Stroke oldStroke = g2.getStroke();
            g2.setStroke(stroke);
            Rectangle r = this.compactDisplayBox();
            g2.drawOval(r.x, r.y, r.width - 1, r.height - 1);
            g2.setStroke(oldStroke);
            g2.setColor(oldColor);
        }
    }

    public void changed() {
        super.changed();
        this.presentationFigure.changed();
    }

    public Connector connectorAt(int x, int y) {
        return this.presentationFigure.connectorAt(x, y);
    }

    public Rectangle placeAdjacent(Rectangle rect, double angle) {
        return this.presentationFigure.placeAdjacent(rect, angle);
    }

    public boolean containsPoint(int x, int y) {
        if (!this.isVisible()) {
            return false;
        }
        if (this.presentationFigure.containsPoint(x, y)) {
            return true;
        }
        FigureEnumeration en = this.figures();
        while (en.hasMoreElements()) {
            if (!en.nextFigure().containsPoint(x, y)) continue;
            return true;
        }
        return false;
    }

    public Figure findFigure(int x, int y) {
        if (this.presentationFigure.containsPoint(x, y)) {
            return this.presentationFigure;
        }
        return super.findFigure(x, y);
    }

    public Figure findFigureInside(int x, int y) {
        if (this.presentationFigure.containsPoint(x, y)) {
            return this.presentationFigure;
        }
        return super.findFigureInside(x, y);
    }

    public Point center() {
        return this.presentationFigure.center();
    }

    public void release() {
        super.release();
        this.removeConnections();
        this.node.getProcess().removeNode(this.node);
    }

    public void translateChildren(int dx, int dy) {
        FigureEnumeration fe = this.figures();
        while (fe.hasMoreElements()) {
            Figure f = fe.nextFigure();
            f.moveBy(dx, dy);
        }
    }

    public void setIconFigure(Figure iconFigure) {
        this.iconFigure = iconFigure;
    }

    public void setIconOverlayFigure(Figure iconOverlayFigure) {
        this.iconOverlayFigure = iconOverlayFigure;
    }

    @Override
    public Figure getShadow() {
        return this.isVisible() ? this.shadowFigure : null;
    }

    public void setSize(int w, int h) {
        this.willChange();
        Rectangle box = this.presentationFigure.displayBox();
        box.grow((w - box.width) / 2, (h - box.height) / 2);
        this.presentationFigure.displayBox(box);
        Rectangle iconRect = null;
        if (this.iconFigure != null) {
            boolean resize = true;
            if (this.node instanceof MultiSocketNode && !((MultiSocketNode)this.node).isImageResize()) {
                resize = false;
            }
            if (resize) {
                int iconSize = Math.min(w, h);
                iconRect = new Rectangle(box.x + box.width / 2 - iconSize / 2, box.y + box.height / 2 - iconSize / 2, iconSize, iconSize);
                iconRect.grow(-iconSize / 6, -iconSize / 6);
            } else {
                Image image = ((SimpleImageFigure)this.iconFigure).getImage();
                int iw = image.getWidth(null);
                int ih = image.getHeight(null);
                iconRect = new Rectangle(box.x + box.width / 2 - iw / 2, box.y + box.height / 2 - ih / 2, iw, ih);
            }
            this.iconFigure.displayBox(iconRect);
        }
        Rectangle textRect = null;
        if (this.fixedTitleFigure != null) {
            textRect = new Rectangle(box);
            textRect.grow(-5, -5);
            this.fixedTitleFigure.displayBox(textRect);
        }
        this.positionOverlayFigure(box, iconRect, textRect);
        if (this.shadowFigure != null) {
            this.shadowFigure.displayBox(box);
        }
        FigureEnumeration fe = this.figures();
        while (fe.hasMoreElements()) {
            Figure f = fe.nextFigure();
            if (!(f instanceof AbstractTagFigure)) continue;
            ((AbstractTagFigure)f).layoutTag();
        }
    }

    protected void positionOverlayFigure(Rectangle box, Rectangle iconRect, Rectangle textRect) {
        if (this.iconOverlayFigure == null) {
            return;
        }
        Rectangle overlayRect = this.iconOverlayFigure.displayBox();
        overlayRect.x = box.x + box.width - overlayRect.width - 20;
        overlayRect.y = box.y + box.height - overlayRect.height - 10;
        this.iconOverlayFigure.displayBox(overlayRect);
    }

    @Override
    public Rectangle compactDisplayBox() {
        return this.presentationFigure.displayBox();
    }

    public void setFillColor(Color color) {
        this.presentationFigure.setFillColor(color);
    }

    public Color getFillColor() {
        return this.presentationFigure.getFillColor();
    }

    @Override
    public ProcessObject getProcessElement() {
        return this.node;
    }

    @Override
    public ProcessObject getReferredProcessElement() {
        return this.getProcessElement();
    }

    @Override
    public Figure selectionOnDelete() {
        return null;
    }

    @Override
    public ProcessElementContainer findProcessElementContainer(int x, int y) {
        if (!this.presentationFigure.containsPoint(x, y)) {
            FigureEnumeration fe = this.figures();
            while (fe.hasMoreElements()) {
                ProcessElementContainer element;
                Figure f = fe.nextFigure();
                if (!(f instanceof ProcessElementContainer) || !(element = (ProcessElementContainer)f).containsPoint(x, y)) continue;
                return element;
            }
        }
        return null;
    }

    @Override
    public ProcessElementContainer findProcessElementContainerInside(int x, int y) {
        ProcessElementContainer child = this.findProcessElementContainer(x, y);
        return child != null ? child.findProcessElementContainerInside(x, y) : this;
    }

    public Rectangle textDisplayBox() {
        if (this.fixedTitleFigure != null) {
            return this.fixedTitleFigure.displayBox();
        }
        if (this.rotatingTitleFigure != null) {
            return this.rotatingTitleFigure.displayBox();
        }
        return this.displayBox();
    }

    public String getText() {
        return this.getProcessElement().getName();
    }

    public void setText(String newText) {
        this.getProcessElement().setName(newText);
    }

    public boolean acceptsTyping() {
        return true;
    }

    public int overlayColumns() {
        String text = this.getText();
        int columns = 20;
        if (text != null && text.length() > 17) {
            columns = text.length() + 3;
        }
        return columns;
    }

    public void connect(Figure connectedFigure) {
    }

    public void disconnect(Figure disconnectFigure) {
    }

    public Font getFont() {
        return ModelerGraphics.getStandardTextFont();
    }

    @Override
    public void setDrawing(ProcessDrawing drawing) {
        this.drawing = drawing;
    }

    @Override
    public ProcessDrawing getDrawing() {
        return this.drawing;
    }

    @Override
    public VisualElement getParentElement() {
        return this.getDrawing();
    }

    @Override
    public Figure getPresentationFigure() {
        return this.presentationFigure;
    }

    @Override
    public void updatePresentationFigure() {
        this.presentationFigure.changed();
        this.encodeGeometry();
        this.initPresentationFigure();
        this.decodeGeometry();
        this.presentationFigure.changed();
    }

    @Override
    public boolean isVisible() {
        return (this.visualStatus & 1) != 0;
    }

    @Override
    public void setVisible(boolean visible) {
        this.willChange();
        this.visualStatus = visible ? (this.visualStatus |= 1) : (this.visualStatus &= 0xFFFFFFFE);
        FigureEnumeration fe = this.figures();
        while (fe.hasMoreElements()) {
            Figure f = fe.nextFigure();
            if (!(f instanceof AbstractTagFigure)) continue;
            ((AbstractTagFigure)f).setVisible(visible);
        }
        this.changed();
    }

    public boolean isCreatedFromScratch() {
        return this.createdFromScratch;
    }

    public void setCreatedFromScratch(boolean createdFromScratch) {
        this.createdFromScratch = createdFromScratch;
    }

    @Override
    public boolean handleEvent(VisualElementEvent event) {
        if (event.mouseEvent != null) {
            VisualElement child = this.findVisualElement(event.x, event.y);
            if (child != null) {
                return child.handleEvent(event);
            }
        } else if (event.type == "UpdateState") {
            boolean ret = false;
            FigureEnumeration fe = this.figures();
            while (fe.hasMoreElements()) {
                Figure f = fe.nextFigure();
                if (!(f instanceof VisualElement) || !((VisualElement)f).handleEvent(event)) continue;
                ret = true;
            }
            return ret;
        }
        return false;
    }

    @Override
    public VisualElement findVisualElement(int x, int y) {
        if (this.presentationFigure.containsPoint(x, y)) {
            return null;
        }
        FigureEnumeration fe = this.figures();
        while (fe.hasMoreElements()) {
            Figure f = fe.nextFigure();
            if (!(f instanceof VisualElement) || !f.containsPoint(x, y)) continue;
            return (VisualElement)f;
        }
        return null;
    }

    @Override
    public VisualElement findVisualElementInside(int x, int y) {
        if (!this.containsPoint(x, y)) {
            return null;
        }
        VisualElement next = this.findVisualElement(x, y);
        return next == null ? this : next.findVisualElementInside(x, y);
    }

    @Override
    public void updateFigure() {
        this.willChange();
        this.initIcon();
        FigureEnumeration fe = this.figures();
        while (fe.hasMoreElements()) {
            Figure next = fe.nextFigure();
            if (!(next instanceof UpdatableFigure)) continue;
            ((UpdatableFigure)next).updateFigure();
        }
        if (this.presentationFigure instanceof UpdatableFigure) {
            ((UpdatableFigure)((Object)this.presentationFigure)).updateFigure();
        }
        if (this.fixedTitleFigure != null) {
            this.fixedTitleFigure.updateFigure();
        }
        this.encodeGeometry();
        String textPosition = ((SymbolDescriptor)this.presentationFigure.getDescriptor()).getTextPosition();
        this.initTextFigure(textPosition);
        this.decodeGeometry();
        Rectangle box = this.presentationFigure.displayBox();
        this.setSize(box.width, box.height);
        this.changed();
    }

    @Override
    public void dragActionTriggered(Object regionId, Point p) {
    }

    @Override
    public void dragStarted(Transferable transferable) {
        DropClientUtil.dragStarted(this, transferable);
    }

    @Override
    public void dragEnded(Transferable transferable) {
        DropClientUtil.dragEnded(this, transferable);
    }

    @Override
    public List getAllDropRegions(List flavors, Transferable data, MouseEvent mouseEvent) {
        return DropClientUtil.getAllDropRegions(this, flavors, data, mouseEvent);
    }

    @Override
    public List getDropRegions(List flavors, Transferable data, MouseEvent mouseEvent) {
        if (flavors.contains(ClientFlavors.TYPE_ITEM)) {
            return Collections.singletonList(this.createNodeDropRegion(REGION_TYPE, flavors));
        }
        return null;
    }

    @Override
    public List getImportersAt(Point p) {
        return null;
    }

    @Override
    public List getAllImportersAt(Point p) {
        return DropClientUtil.getAllImportersAt(this, p);
    }

    @Override
    public List getSubClients() {
        return FigureUtil.getTypedFigureList(this, InteractionClient.class);
    }

    @Override
    public boolean importData(Object regionId, Transferable data, Point p) {
        if (data.isDataFlavorSupported(ClientFlavors.TYPE_ITEM)) {
            int nEntry = 0;
            int nExit = 0;
            boolean found = false;
            Iterator it = this.node.getSockets();
            while (it.hasNext()) {
                NodeSocket nodeSocket = (NodeSocket)it.next();
                if (nodeSocket.isEntrySocket()) {
                    ++nEntry;
                } else {
                    ++nExit;
                }
                found = true;
            }
            if (!found) {
                return false;
            }
            int DO_ENTRY = 4;
            int DO_EXIT = 8;
            int DO_ALL = 16;
            int choice = 0;
            if (nEntry == 1 && nExit == 0 || nEntry == 0 && nExit == 1) {
                choice = DO_ALL;
            } else {
                int msgType = 2;
                if (nEntry > 0) {
                    msgType |= DO_ENTRY;
                }
                if (nExit > 0) {
                    msgType |= DO_EXIT;
                }
                if (nEntry > 0 && nExit > 0) {
                    msgType |= DO_ALL;
                }
                ResourceCollection res = this.getDrawing().getEditor().getPluginResourceCollection();
                String title = res.getRequiredString("node.addparam.title");
                String text = res.getRequiredString("node.addparam.text");
                try {
                    DataTypeItem type = (DataTypeItem)data.getTransferData(ClientFlavors.TYPE_ITEM);
                    text = MsgFormat.format((String)text, (Object)type.getDisplayText());
                }
                catch (UnsupportedFlavorException e) {
                }
                catch (IOException e) {
                    // empty catch block
                }
                JMsgBox msgBox = new JMsgBox(null, title, text, msgType);
                msgBox.setResource(res);
                msgBox.setResourcePrefix("node.addparam.");
                msgBox.initDialog();
                SwingUtil.show((JDialog)msgBox);
                choice = msgBox.getUserChoice();
            }
            Iterator it2 = this.node.getSockets();
            while (it2.hasNext()) {
                NodeSocket nodeSocket = (NodeSocket)it2.next();
                boolean doit = false;
                if (nodeSocket.isEntrySocket()) {
                    doit = (choice & (DO_ENTRY | DO_ALL)) != 0;
                } else {
                    boolean bl = doit = (choice & (DO_EXIT | DO_ALL)) != 0;
                }
                if (!doit) continue;
                SocketFigure socketFigure = (SocketFigure)nodeSocket.getRepresentation();
                socketFigure.importData(REGION_TYPE, data, null);
            }
            return true;
        }
        return false;
    }

    protected ViewDropRegion createNodeDropRegion(String regionId, List flavors) {
        WorkspaceDrawingView view = this.getDrawing().getView();
        RectangularShape shape = this.presentationFigure.createRectangularShape();
        Rectangle r = this.presentationFigure.displayBox();
        r = view.applyScale(r, false);
        shape.setFrame(r);
        Color color = ModelerColors.DROP_REGION;
        if (flavors.contains(ModelerFlavors.COLOR)) {
            color = null;
        }
        ViewDropRegion region = new ViewDropRegion(regionId, this, shape, (Component)((Object)view));
        region.setPaint(color);
        return region;
    }
}

