/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.figures.process;

import CH.ifa.draw.figures.LineDecoration;
import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeListener;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.openbp.cockpit.modeler.ViewModeMgr;
import org.openbp.cockpit.modeler.drawing.ProcessDrawing;
import org.openbp.cockpit.modeler.figures.generic.CircleConstants;
import org.openbp.cockpit.modeler.figures.generic.GeometryException;
import org.openbp.cockpit.modeler.figures.generic.GeometryUtil;
import org.openbp.cockpit.modeler.figures.generic.Orientation;
import org.openbp.cockpit.modeler.figures.generic.XArrowTip;
import org.openbp.cockpit.modeler.figures.process.ParamFigure;
import org.openbp.cockpit.modeler.figures.process.ProcessElementContainer;
import org.openbp.cockpit.modeler.figures.process.SocketFigure;
import org.openbp.cockpit.modeler.figures.spline.PolySplineConnection;
import org.openbp.cockpit.modeler.figures.tag.TagConnector;
import org.openbp.cockpit.modeler.skins.LinkDescriptor;
import org.openbp.common.CollectionUtil;
import org.openbp.common.generic.description.DisplayObject;
import org.openbp.common.util.ToStringHelper;
import org.openbp.core.model.item.process.ControlLink;
import org.openbp.core.model.item.process.DataLink;
import org.openbp.core.model.item.process.DataLinkImpl;
import org.openbp.core.model.item.process.NodeParam;
import org.openbp.core.model.item.process.NodeSocket;
import org.openbp.core.model.item.process.Param;
import org.openbp.core.model.item.process.ProcessItem;
import org.openbp.core.model.item.process.ProcessObject;

public class ParamConnection
extends PolySplineConnection
implements ProcessElementContainer {
    private DataLink dataLink;
    private ProcessItem process;
    private Color memberPathColor = Color.BLACK;
    private static final LineDecoration endDecoration = new XArrowTip(0.4, 12.0, 9.0);

    public ParamConnection(DataLink dataLink, Connector startConnector, Connector endConnector, ProcessDrawing drawing) {
        super(drawing);
        this.dataLink = dataLink;
        dataLink.setRepresentation((Object)this);
        this.process = dataLink.getProcess();
        this.getLabel().setClient((DisplayObject)dataLink);
        this.setStartConnector(startConnector);
        this.setEndConnector(endConnector);
        this.decodeGeometry();
        this.initializeFigureAttributes();
        this.connectStart(startConnector);
        this.connectEnd(endConnector);
    }

    public ParamConnection(ProcessDrawing drawing) {
        super(drawing);
        this.process = drawing.getProcess();
        this.dataLink = this.process.createDataLink();
        this.dataLink.setRepresentation((Object)this);
        this.getLabel().setClient((DisplayObject)this.dataLink);
        this.drawDecorations = false;
        this.initializeFigureAttributes();
    }

    protected void initializeFigureAttributes() {
        this.setEndDecoration(endDecoration);
        LinkDescriptor desc = this.getDrawing().getProcessSkin().getLinkDescriptor("Data");
        if (desc != null) {
            this.setStroke(desc.getStroke());
            this.setFrameColor(desc.getColor());
            this.memberPathColor = desc.getColor2();
        }
    }

    public DataLink getDataLink() {
        return this.dataLink;
    }

    public String toString() {
        return ToStringHelper.toString((Object)this, (String)"dataLink");
    }

    @Override
    public void draw(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Stroke oldStroke = g2.getStroke();
        g2.setStroke(this.getStroke());
        Color oldColor = g2.getColor();
        Color c = this.dataLink.getSourceMemberPath() != null || this.dataLink.getTargetMemberPath() != null ? this.memberPathColor : this.getFrameColor();
        g2.setColor(c);
        this.drawSpline(g2);
        if (this.drawDecorations) {
            g2.setColor(c);
            this.drawDecorations(g);
        }
        g2.setColor(oldColor);
        g2.setStroke(oldStroke);
    }

    @Override
    public boolean canConnectFigures(Figure startFigure, Figure endFigure, int flags) {
        ControlLink link;
        if (!(startFigure instanceof ParamFigure) || !(endFigure instanceof ParamFigure)) {
            return false;
        }
        SocketFigure startSocketFigure = (SocketFigure)((ParamFigure)startFigure).getParent();
        SocketFigure endSocketFigure = (SocketFigure)((ParamFigure)endFigure).getParent();
        if (startSocketFigure.isEntrySocket() == endSocketFigure.isEntrySocket()) {
            return false;
        }
        boolean haveControlLink = false;
        NodeSocket startSocket = startSocketFigure.getNodeSocket();
        NodeSocket endSocket = endSocketFigure.getNodeSocket();
        Iterator it = startSocket.getControlLinks();
        while (it.hasNext()) {
            link = (ControlLink)it.next();
            if (link.getTargetSocket() != endSocket) continue;
            haveControlLink = true;
            break;
        }
        it = endSocket.getControlLinks();
        while (it.hasNext()) {
            link = (ControlLink)it.next();
            if (link.getTargetSocket() != startSocket) continue;
            haveControlLink = true;
            break;
        }
        if (!haveControlLink) {
            return false;
        }
        return DataLinkImpl.canLink((Param)((ParamFigure)startFigure).getNodeParam(), (String)this.dataLink.getSourceMemberPath(), (Param)((ParamFigure)endFigure).getNodeParam(), (String)this.dataLink.getTargetMemberPath(), (int)flags) != 0;
    }

    @Override
    protected boolean shouldReverse(Figure startFigure, Figure endFigure) {
        SocketFigure socketFigure = (SocketFigure)((ParamFigure)this.startFigure()).getParent();
        return socketFigure.isEntrySocket();
    }

    @Override
    protected void handleConnect(Figure startFigure, Figure endFigure) {
        ParamFigure startParamFigure = (ParamFigure)startFigure;
        ParamFigure endParamFigure = (ParamFigure)endFigure;
        NodeParam startParam = startParamFigure.getNodeParam();
        NodeParam endParam = endParamFigure.getNodeParam();
        this.dataLink.link((Param)startParam, (Param)endParam);
        startParamFigure.addParamConnection(this);
        endParamFigure.addParamConnection(this);
        if (CollectionUtil.containsReference((Collection)this.process.getDataLinkList(), (Object)this.dataLink)) {
            return;
        }
        this.process.addDataLink(this.dataLink);
        this.dataLink.maintainReferences(5);
    }

    @Override
    protected void handleDisconnect(Figure startFigure, Figure endFigure) {
        this.process.removeDataLink(this.dataLink);
        ParamFigure startParamFigure = (ParamFigure)startFigure;
        ParamFigure endParamFigure = (ParamFigure)endFigure;
        if (startParamFigure != null) {
            startParamFigure.removeParamConnection(this);
        }
        if (endParamFigure != null) {
            endParamFigure.removeParamConnection(this);
        }
    }

    @Override
    public boolean connectsSame(ConnectionFigure other) {
        if (!(other instanceof ParamConnection)) {
            return false;
        }
        DataLink otherLink = ((ParamConnection)other).getDataLink();
        return this.dataLink.getSourceParamName().equals(otherLink.getSourceParamName()) && this.dataLink.getTargetParamName().equals(otherLink.getTargetParamName());
    }

    @Override
    protected void addStartConnectorChangeListener() {
        if (this.getStartConnector() != null) {
            ((TagConnector)this.getStartConnector()).getSocketFigure().addFigureChangeListener((FigureChangeListener)this);
        }
    }

    @Override
    protected void removeStartConnectorChangeListener() {
        if (this.getStartConnector() != null) {
            ((TagConnector)this.getStartConnector()).getSocketFigure().removeFigureChangeListener((FigureChangeListener)this);
        }
    }

    @Override
    protected void addEndConnectorChangeListener() {
        if (this.getEndConnector() != null) {
            ((TagConnector)this.getEndConnector()).getSocketFigure().addFigureChangeListener((FigureChangeListener)this);
        }
    }

    @Override
    protected void removeEndConnectorChangeListener() {
        if (this.getEndConnector() != null) {
            ((TagConnector)this.getEndConnector()).getSocketFigure().removeFigureChangeListener((FigureChangeListener)this);
        }
    }

    @Override
    public boolean isMinimized() {
        return !ViewModeMgr.getInstance().isDataLinkVisible(this);
    }

    @Override
    public void release() {
        super.release();
        this.process.removeDataLink(this.dataLink);
    }

    public boolean isOrientationLocked() {
        TagConnector startConnector = (TagConnector)this.getStartConnector();
        TagConnector endConnector = (TagConnector)this.getEndConnector();
        return startConnector.isOrientationLocked() || endConnector.isOrientationLocked();
    }

    public void toggleOrientationLock() {
        TagConnector startConnector = (TagConnector)this.getStartConnector();
        TagConnector endConnector = (TagConnector)this.getEndConnector();
        boolean startLocked = startConnector.isOrientationLocked();
        boolean endLocked = endConnector.isOrientationLocked();
        if (startLocked && endLocked) {
            if (startLocked) {
                startConnector.setLockedOrientation(Orientation.UNDETERMINED);
            }
            if (endLocked) {
                endConnector.setLockedOrientation(Orientation.UNDETERMINED);
            }
        } else {
            if (!startLocked) {
                startConnector.toggleOrientationLock();
            }
            if (!endLocked) {
                endConnector.toggleOrientationLock();
            }
        }
    }

    public void flipOrientation() {
        TagConnector startConnector = (TagConnector)this.getStartConnector();
        TagConnector endConnector = (TagConnector)this.getEndConnector();
        if (!startConnector.isOrientationLocked()) {
            startConnector.toggleOrientationLock();
        }
        if (!endConnector.isOrientationLocked()) {
            endConnector.toggleOrientationLock();
        }
        Orientation startOrientation = startConnector.getLockedOrientation();
        Orientation endOrientation = endConnector.getLockedOrientation();
        if (!(startOrientation != Orientation.TOP && startOrientation != Orientation.LEFT || endOrientation != Orientation.TOP && endOrientation != Orientation.LEFT)) {
            startConnector.flipOrientation();
        } else if (!(startOrientation != Orientation.BOTTOM && startOrientation != Orientation.RIGHT || endOrientation != Orientation.TOP && endOrientation != Orientation.LEFT)) {
            startConnector.flipOrientation();
            endConnector.flipOrientation();
        } else if (!(startOrientation != Orientation.TOP && startOrientation != Orientation.LEFT || endOrientation != Orientation.BOTTOM && endOrientation != Orientation.RIGHT)) {
            startConnector.flipOrientation();
        } else if (!(startOrientation != Orientation.BOTTOM && startOrientation != Orientation.RIGHT || endOrientation != Orientation.BOTTOM && endOrientation != Orientation.RIGHT)) {
            startConnector.flipOrientation();
            endConnector.flipOrientation();
        }
    }

    @Override
    public void layoutAndAdjustConnection() {
        boolean socketsInSync;
        TagConnector startConnector = (TagConnector)this.getStartConnector();
        TagConnector endConnector = (TagConnector)this.getEndConnector();
        Orientation startOrientation = startConnector.getOrientation();
        Orientation endOrientation = endConnector.getOrientation();
        SocketFigure startSocketFigure = (SocketFigure)((ParamFigure)this.startFigure()).getParent();
        SocketFigure endSocketFigure = (SocketFigure)((ParamFigure)this.endFigure()).getParent();
        Figure startNodeFigure = startSocketFigure.getParent();
        Figure endNodeFigure = endSocketFigure.getParent();
        Point startCenter = startSocketFigure.center();
        Point endCenter = endSocketFigure.center();
        Orientation startSocketOrientation = CircleConstants.determineOrientation(startSocketFigure.getAngle(), startNodeFigure.displayBox());
        Orientation endSocketOrientation = CircleConstants.determineOrientation(endSocketFigure.getAngle(), endNodeFigure.displayBox());
        boolean startSocketIsVertical = startSocketOrientation == Orientation.TOP || startSocketOrientation == Orientation.BOTTOM;
        boolean endSocketIsVertical = endSocketOrientation == Orientation.TOP || endSocketOrientation == Orientation.BOTTOM;
        boolean bl = socketsInSync = startSocketIsVertical == endSocketIsVertical;
        if (socketsInSync) {
            endOrientation = startOrientation;
        } else {
            if (startSocketOrientation == Orientation.LEFT || startSocketOrientation == Orientation.RIGHT) {
                startOrientation = startCenter.y <= endCenter.y ? Orientation.BOTTOM : Orientation.TOP;
            }
            if (startSocketOrientation == Orientation.TOP || startSocketOrientation == Orientation.BOTTOM) {
                startOrientation = startCenter.x <= endCenter.x ? Orientation.RIGHT : Orientation.LEFT;
            }
            if (endSocketOrientation == Orientation.LEFT || endSocketOrientation == Orientation.RIGHT) {
                endOrientation = startCenter.y <= endCenter.y ? Orientation.TOP : Orientation.BOTTOM;
            }
            if (endSocketOrientation == Orientation.TOP || endSocketOrientation == Orientation.BOTTOM) {
                endOrientation = startCenter.x <= endCenter.x ? Orientation.LEFT : Orientation.RIGHT;
            }
        }
        startConnector.setLockedOrientation(startOrientation);
        endConnector.setLockedOrientation(endOrientation);
        this.layoutConnection();
    }

    public void decodeGeometry() {
        String errIdent = this.dataLink.getQualifier().toUntypedString();
        this.decode(this.dataLink.getGeometry(), errIdent);
    }

    public void encodeGeometry() {
        this.dataLink.setGeometry(this.encode());
    }

    @Override
    protected boolean decodeParameter(String parameter, String errName) {
        if (super.decodeParameter(parameter, errName)) {
            return true;
        }
        StringTokenizer st = new StringTokenizer(parameter, ":");
        String paramName = st.nextToken();
        if (!paramName.equals("orientation")) {
            throw new GeometryException("Unknown paramter '" + paramName + "'.", errName);
        }
        Orientation startOrientation = Orientation.fromInt(GeometryUtil.parseInt(st, paramName, errName));
        Orientation endOrientation = Orientation.fromInt(GeometryUtil.parseInt(st, paramName, errName));
        ((TagConnector)this.getStartConnector()).setLockedOrientation(startOrientation);
        ((TagConnector)this.getEndConnector()).setLockedOrientation(endOrientation);
        return true;
    }

    @Override
    protected String encode() {
        String result = super.encode();
        TagConnector startConnector = (TagConnector)this.getStartConnector();
        TagConnector endConnector = (TagConnector)this.getEndConnector();
        if (startConnector != null && startConnector.getLockedOrientation() != Orientation.UNDETERMINED && endConnector != null && endConnector.getLockedOrientation() != Orientation.UNDETERMINED) {
            result = result + "|orientation:" + startConnector.getLockedOrientation() + ":" + endConnector.getLockedOrientation();
        }
        return result;
    }

    @Override
    public ProcessObject getProcessElement() {
        return this.dataLink;
    }

    @Override
    public ProcessObject getReferredProcessElement() {
        return this.getProcessElement();
    }

    @Override
    public Figure selectionOnDelete() {
        return this.startFigure();
    }

    @Override
    public ProcessElementContainer findProcessElementContainer(int x, int y) {
        return null;
    }

    @Override
    public ProcessElementContainer findProcessElementContainerInside(int x, int y) {
        return this.containsPoint(x, y) ? this : null;
    }
}

